/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.updatetable;

import java.util.function.Predicate;
import org.gvsig.app.extension.updatetable.UpdateTableProcess;
import org.gvsig.app.extension.updatetable.UpdateTableProcessParameters;
import org.gvsig.app.extension.updatetable.UpdateTableProcessParametersImpl;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.identitymanagement.IdentityUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTableProcessImpl
implements UpdateTableProcess {
    protected final Logger LOGGER = LoggerFactory.getLogger(UpdateTableProcessImpl.class);
    private UpdateTableProcessParameters parameters;
    private SimpleTaskStatus status;
    private Runnable postprocess;
    private FeatureSymbolTable featureSymbolTable;
    private DataTransaction transaction;
    private MutableSymbolTable out;

    public UpdateTableProcessImpl() {
    }

    public UpdateTableProcessImpl(UpdateTableProcessParameters parameters, SimpleTaskStatus status, Runnable postprocess) {
        this();
        this.parameters = parameters;
        this.status = status;
        this.postprocess = postprocess;
    }

    @Override
    public void start() {
        Thread th = new Thread(() -> {
            try {
                this.run();
            }
            catch (Exception ex) {
                this.LOGGER.warn("Can't process table update.");
            }
        }, "UpdateTableProcess");
        th.start();
    }

    @Override
    public void run() {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            FeatureStore store = this.parameters.getStore();
            if (!IdentityUtils.isAuthorized((String)"tools-updatetable", (Object)store, (String)store.getFullName())) {
                this.status.message("User not authotized to this action");
                return;
            }
            this.transactionBegin();
            this.transactionAdd(store);
            this.status.setTitle("Update table '" + store.getName() + "'");
            this.status.setIndeterminate();
            this.featureSymbolTable = dataManager.createFeatureSymbolTable();
            switch (this.parameters.getRowsToProcess()) {
                case 0: {
                    this.update_all();
                    break;
                }
                case 1: {
                    this.update_selection();
                    break;
                }
                case 2: {
                    this.update_editeds();
                }
            }
            if (this.status.isCancelled()) {
                this.abortEditing();
                this.transactionAbort();
                this.status.message("Operation cancelled by user");
            } else {
                this.endEditing();
                this.transactionEnd();
                this.status.terminate();
                this.output();
                this.out.setVar("store", (Object)store);
                if (this.postprocess != null) {
                    this.postprocess.run();
                }
            }
        }
        catch (Exception ex) {
            this.LOGGER.warn("Can't update features", (Throwable)ex);
            this.transactionAbort();
            this.status.abort();
            this.status.message("Can't update features");
        }
        finally {
            DisposeUtils.dispose((Disposable)this.transaction);
        }
    }

    /*
     * Exception decompiling
     */
    public void update_editeds() throws DataException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update_selection() throws DataException {
        FeatureStore store;
        Predicate saveNotificationsFilter;
        block5: {
            saveNotificationsFilter = null;
            store = this.parameters.getStore();
            try {
                saveNotificationsFilter = store.setNotificationsFilter((Predicate)new StoreNotificationsFilter());
                Expression filter = this.parameters.getFilter();
                FeatureSelection set = store.getFeatureSelection();
                this.beginEditing();
                long rows = set.getSize();
                this.status.setRangeOfValues(0L, rows);
                for (Feature feature : set) {
                    boolean sholdProcessFeature;
                    this.status.incrementCurrentValue();
                    if (this.status.isCancellationRequested()) {
                        this.status.cancel();
                        this.abortEditing();
                        break block5;
                    }
                    this.featureSymbolTable.setFeature(feature);
                    if (filter != null && !(sholdProcessFeature = DataTypeUtils.toBoolean((Object)filter.execute((SymbolTable)this.featureSymbolTable), (boolean)false))) continue;
                    EditableFeature editable_feature = feature.getEditable();
                    this.process_feature(editable_feature);
                    set.update(editable_feature);
                    this.restart_editing();
                }
                this.status.setRangeOfValues(0L, 0L);
                this.endEditing();
            }
            catch (Throwable throwable) {
                store.setNotificationsFilter(saveNotificationsFilter);
                throw throwable;
            }
            store.setNotificationsFilter(saveNotificationsFilter);
            return;
        }
        store.setNotificationsFilter(saveNotificationsFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update_all() throws DataException {
        FeatureStore store;
        Predicate saveNotificationsFilter;
        block5: {
            saveNotificationsFilter = null;
            store = this.parameters.getStore();
            try {
                saveNotificationsFilter = store.setNotificationsFilter((Predicate)new StoreNotificationsFilter());
                Expression filter = this.parameters.getFilter();
                FeatureQuery query = store.createFeatureQuery(filter);
                FeatureSet set = store.getFeatureSet(query);
                this.transactionAdd(set);
                this.beginEditing();
                long rows = set.getSize();
                this.status.setRangeOfValues(0L, rows);
                for (Feature feature : set) {
                    this.status.incrementCurrentValue();
                    if (this.status.isCancellationRequested()) {
                        this.status.cancel();
                        this.abortEditing();
                        break block5;
                    }
                    EditableFeature editable_feature = feature.getEditable();
                    this.process_feature(editable_feature);
                    set.update(editable_feature);
                    this.restart_editing();
                }
                this.status.setRangeOfValues(0L, 0L);
                this.endEditing();
            }
            catch (Throwable throwable) {
                store.setNotificationsFilter(saveNotificationsFilter);
                throw throwable;
            }
            store.setNotificationsFilter(saveNotificationsFilter);
            return;
        }
        store.setNotificationsFilter(saveNotificationsFilter);
    }

    private void process_feature(EditableFeature feature) {
        for (UpdateTableProcessParameters.ProcessFieldParameters field : this.parameters) {
            Expression expression;
            if (!field.isUpdate() || (expression = field.getExpression()) == null || expression.isPhraseEmpty()) continue;
            this.featureSymbolTable.setFeature((Feature)feature);
            Object x = expression.execute((SymbolTable)this.featureSymbolTable);
            feature.set(field.getName(), x);
        }
    }

    private void beginEditing() throws DataException {
        if (this.parameters.getRowsToProcess() == 2) {
            return;
        }
        if (!this.parameters.isBeginEditIfNeed()) {
            return;
        }
        FeatureStore store = this.parameters.getStore();
        if (store.getMode() != 0 && this.parameters.isFinishAndRestarEdit()) {
            store.finishEditing();
        }
        if (store.getMode() == 0) {
            store.edit(this.parameters.getEditMode());
        }
    }

    private void endEditing() throws DataException {
        FeatureStore store = this.parameters.getStore();
        if (store.getMode() == 0) {
            return;
        }
        if (this.parameters.isFinishEditAfterTerminate()) {
            store.finishEditing();
        } else {
            store.refresh();
        }
    }

    private void abortEditing() throws DataException {
        FeatureStore store = this.parameters.getStore();
        if (store.getMode() == 0) {
            return;
        }
        if (this.parameters.isFinishEditAfterTerminate()) {
            store.cancelEditing();
        } else {
            store.refresh();
        }
    }

    private void restart_editing() throws DataException {
        if (!this.parameters.isFinishAndRestarEdit()) {
            return;
        }
        if (this.parameters.getRowsToProcess() == 2) {
            return;
        }
        int n = this.parameters.getFinishAndRestarEditEach();
        if (n < 1) {
            return;
        }
        FeatureStore store = this.parameters.getStore();
        switch (store.getMode()) {
            case 2: 
            case 3: {
                return;
            }
        }
        if (store.getMode() != 1) {
            return;
        }
        if (store.getPendingChangesCount() < (long)n) {
            return;
        }
        store.finishEditing();
        store.edit(this.parameters.getEditMode());
    }

    @Override
    public UpdateTableProcess parameters(UpdateTableProcessParameters params) {
        this.parameters = params;
        return this;
    }

    @Override
    public UpdateTableProcess status(SimpleTaskStatus taskStatus) {
        this.status = taskStatus;
        return this;
    }

    @Override
    public UpdateTableProcess postProcess(Runnable postProcess) {
        this.postprocess = postProcess;
        return this;
    }

    @Override
    public UpdateTableProcessParameters createParameters() {
        return new UpdateTableProcessParametersImpl();
    }

    @Override
    public SymbolTable output() {
        if (this.out == null) {
            this.out = ExpressionUtils.createSymbolTable();
        }
        return this.out;
    }

    private void transactionBegin() throws DataException {
        if (!this.parameters.isFinishAndRestarEdit()) {
            return;
        }
        DataManager dataManager = DALLocator.getDataManager();
        this.transaction = dataManager.createTransaction();
        this.transaction.begin();
    }

    private void transactionEnd() throws DataException {
        if (!this.parameters.isFinishAndRestarEdit()) {
            return;
        }
        this.transaction.commit();
    }

    private void transactionAbort() {
        if (!this.parameters.isFinishAndRestarEdit()) {
            return;
        }
        DataTransaction.rollbackQuietly((DataTransaction)this.transaction);
    }

    private void transactionAdd(FeatureStore store) throws DataException {
        if (!this.parameters.isFinishAndRestarEdit()) {
            return;
        }
        this.transaction.add((DataStore)store, false);
    }

    private void transactionAdd(FeatureSet set) throws DataException {
        if (!this.parameters.isFinishAndRestarEdit()) {
            return;
        }
        this.transaction.add((Disposable)set);
    }

    private class StoreNotificationsFilter
    implements Predicate<FeatureStoreNotification> {
        private StoreNotificationsFilter() {
        }

        @Override
        public boolean test(FeatureStoreNotification t) {
            if (t != null) {
                switch (t.getType()) {
                    case "after_Update_Feature": 
                    case "before_Update_Feature": {
                        return true;
                    }
                }
                UpdateTableProcessImpl.this.LOGGER.info(t.getType());
            }
            return false;
        }
    }
}

