/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.app.extension.InitializeApplicationExtension;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.tools.dynobject.DynObject;

public class AppSymbolPreferences
implements SymbolPreferences {
    private static final String SYMBOL_COLOR = "defaultSymbolColor";
    private static final String SYMBOL_FILL_COLOR = "defaultSymbolFillColor";
    private static final String SYMBOL_FILL_COLOR_ALEATORY = "defaultSymbolFillColorAleatory";
    private static final String SYMBOL_FONT = "defaultSymbolFont";
    private static final String SYMBOL_LIBRARY_PATH = "symbolLibraryPath";
    private DynObject values = null;
    private String symbolFileExtension = ".gvssym";
    private Color defaultSymbolColor;
    private Color defaultSymbolFillColor;
    private boolean defaultSymbolFillColorAleatory;
    private Font defaultSymbolFont;
    private String symbolLibraryPath;
    private int defaultCartographicSupportMeasureUnit = -1;
    private int defaultCartographicSupportReferenceSystem = 0;

    public AppSymbolPreferences() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin(InitializeApplicationExtension.class);
        this.values = plugin.getPluginProperties();
        this.initDefaults();
    }

    private void initDefaults() {
        this.resetDefaultSymbolColor();
        this.resetDefaultSymbolFillColor();
        this.resetDefaultSymbolFillColorAleatory();
        this.resetSymbolLibraryPath();
        this.resetDefaultSymbolFont();
        if (this.getDefaultSymbolFont() == null) {
            this.setDefaultSymbolFont(this.defaultSymbolFont);
        }
        if (this.getDefaultSymbolColor() == null) {
            this.setDefaultSymbolColor(this.defaultSymbolColor);
        }
        if (this.getDefaultSymbolFillColor() == null) {
            this.setDefaultSymbolFillColor(this.defaultSymbolFillColor);
        }
        if (this.getSymbolLibraryPath() == null) {
            this.setSymbolLibraryPath(this.symbolLibraryPath);
        }
        this.setSymbolFileExtension(this.symbolFileExtension);
        this.setDefaultCartographicSupportMeasureUnit(this.defaultCartographicSupportMeasureUnit);
        this.setDefaultCartographicSupportReferenceSystem(this.defaultCartographicSupportReferenceSystem);
    }

    public String getSymbolFileExtension() {
        return this.symbolFileExtension;
    }

    public void setSymbolFileExtension(String symbolFileExtension) {
        this.symbolFileExtension = symbolFileExtension;
    }

    public String getSymbolLibraryPath() {
        String spath = (String)this.values.getDynValue(SYMBOL_LIBRARY_PATH);
        if (spath == null) {
            return this.symbolLibraryPath;
        }
        File path = new File(spath);
        if (!path.exists()) {
            return this.symbolLibraryPath;
        }
        return spath;
    }

    public void setSymbolLibraryPath(String symbolLibraryPath) {
        this.values.setDynValue(SYMBOL_LIBRARY_PATH, (Object)symbolLibraryPath);
        PluginServices.getPluginServices((Object)this).savePluginProperties();
    }

    public Color getDefaultSymbolColor() {
        return (Color)this.values.getDynValue(SYMBOL_COLOR);
    }

    public void setDefaultSymbolColor(Color symbolColor) {
        this.values.setDynValue(SYMBOL_COLOR, (Object)symbolColor);
        PluginServices.getPluginServices((Object)this).savePluginProperties();
    }

    public Color getDefaultSymbolFillColor() {
        return (Color)this.values.getDynValue(SYMBOL_FILL_COLOR);
    }

    public void setDefaultSymbolFillColor(Color symbolFillColor) {
        this.values.setDynValue(SYMBOL_FILL_COLOR, (Object)symbolFillColor);
        PluginServices.getPluginServices((Object)this).savePluginProperties();
    }

    public boolean isDefaultSymbolFillColorAleatory() {
        if (this.values.getDynValue(SYMBOL_FILL_COLOR_ALEATORY) == null) {
            this.setDefaultSymbolFillColorAleatory(this.defaultSymbolFillColorAleatory);
        }
        return (Boolean)this.values.getDynValue(SYMBOL_FILL_COLOR_ALEATORY);
    }

    public void setDefaultSymbolFillColorAleatory(boolean defaultSymbolFillColorAleatory) {
        this.values.setDynValue(SYMBOL_FILL_COLOR_ALEATORY, (Object)defaultSymbolFillColorAleatory);
        PluginServices.getPluginServices((Object)this).savePluginProperties();
    }

    public Font getDefaultSymbolFont() {
        return (Font)this.values.getDynValue(SYMBOL_FONT);
    }

    public void setDefaultSymbolFont(Font defaultSymbolFont) {
        this.values.setDynValue(SYMBOL_FONT, (Object)defaultSymbolFont);
        PluginServices.getPluginServices((Object)this).savePluginProperties();
    }

    public int getDefaultCartographicSupportMeasureUnit() {
        return this.defaultCartographicSupportMeasureUnit;
    }

    public void setDefaultCartographicSupportMeasureUnit(int defaultCartographicSupportMeasureUnit) {
        this.defaultCartographicSupportMeasureUnit = defaultCartographicSupportMeasureUnit;
    }

    public int getDefaultCartographicSupportReferenceSystem() {
        return this.defaultCartographicSupportReferenceSystem;
    }

    public void setDefaultCartographicSupportReferenceSystem(int defaultCartographicSupportReferenceSystem) {
        this.defaultCartographicSupportReferenceSystem = defaultCartographicSupportReferenceSystem;
    }

    public void resetDefaultSymbolColor() {
        this.defaultSymbolColor = Color.DARK_GRAY;
    }

    public void resetDefaultSymbolFillColor() {
        this.defaultSymbolFillColor = new Color(60, 235, 235);
    }

    public void resetDefaultSymbolFillColorAleatory() {
        this.defaultSymbolFillColorAleatory = true;
    }

    public void resetDefaultSymbolFont() {
        this.defaultSymbolFont = new Font("SansSerif", 0, 14);
    }

    public void resetSymbolLibraryPath() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin(InitializeApplicationExtension.class);
        this.symbolLibraryPath = new File(plugin.getPluginHomeFolder(), "Symbols").getAbsolutePath();
    }
}

