/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.gui.preferencespage.ViewPageView;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.ColorPickerController;

public class ViewPage
extends ViewPageView
implements ChangeListener,
ItemListener,
IPreference {
    private static final long serialVersionUID = 1204688910771374514L;
    public static String id = ViewPage.class.getName();
    private static final IProjection FACTORY_DEFAULT_PROJECTION = MapContextLocator.getMapContextManager().getDefaultCRS();
    private static String[] unitsNames = null;
    private static String[] areaUnitsNames = null;
    private static final double DEFAULT_ZOOM_IN_FACTOR = 2.0;
    private static final double DEFAULT_ZOOM_OUT_FACTOR = 1.5;
    private static final Color FACTORY_DEFAULT_SELECTION_COLOR = Color.YELLOW;
    private static final Color FACTORY_DEFAULT_VIEW_BACK_COLOR = Color.WHITE;
    private static int FACTORY_DEFAULT_MAP_UNITS;
    private static int FACTORY_DEFAULT_DISTANCE_UNITS;
    private static int FACTORY_DEFAULT_DISTANCE_AREA;
    private ImageIcon icon;
    private ProjectionPickerController defaultProjection;
    private ColorPickerController defaultViewBackColor = null;
    private ColorPickerController defaultSelectionColor = null;
    private boolean hasChanges = false;

    public ViewPage() {
        this.initUnitsNames();
        this.initComponents();
        this.translateAll();
        this.initializeValues();
    }

    private void initComponents() {
        this.chkKeepScaleOnResizing.setEnabled(false);
        this.defaultProjection = DALSwingLocator.getDataSwingManager().createProjectionPickerController(this.txtDefaultProjection, this.btnChangeProjection);
        this.defaultProjection.addChangeListener((ChangeListener)this);
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.defaultSelectionColor = toolsSwingManager.createColorPickerController((JTextComponent)this.txtDefaultSelectionColor, this.btnDefaultSelectionColor, this.sldDefaultSelectionColor);
        this.defaultSelectionColor.addChangeListener((ChangeListener)this);
        this.defaultViewBackColor = toolsSwingManager.createColorPickerController((JTextComponent)this.txtDefaultViewBackColor, this.btnDefaultViewBackColor);
        this.defaultViewBackColor.addChangeListener((ChangeListener)this);
        this.chkInvisibleNewLayers.addChangeListener(this);
        this.chkKeepScaleOnResizing.addChangeListener(this);
        this.jCmbDistanceArea.addItemListener(this);
        this.jCmbDistanceUnits.addItemListener(this);
        this.jCmbMapUnits.addItemListener(this);
    }

    private void translateAll() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.lblDefaultProjection.setText(i18n.getTranslation("default_projection"));
        this.chkInvisibleNewLayers.setText(i18n.getTranslation("options.view.invisible_new_layers"));
        this.chkKeepScaleOnResizing.setText(i18n.getTranslation("options.view.keep_scale_on_resizing"));
        this.lblZoomInFactor.setText(i18n.getTranslation("zoom_in_factor"));
        this.lblZoomOutFactor.setText(i18n.getTranslation("zoom_out_factor"));
        this.lblDefaultViewBackColor.setText(i18n.getTranslation("options.view.default_view_back_color"));
        this.lblDefaultSelectionColor.setText(i18n.getTranslation("options.view.default_selection_color"));
        this.lblMapUnits.setText(i18n.getTranslation("map_units"));
        this.lblDistanceUnits.setText(i18n.getTranslation("distance_units"));
        this.lblDistanceArea.setText(i18n.getTranslation("distance_area"));
        this.chkHideLegendOfNonVisibleLayers.setText(i18n.getTranslation("_Hide_legend_of_non_visible_layers"));
        this.chkOpenWithANewMaximizedView.setText(i18n.getTranslation("_Open_with_a_new_maximized_view"));
        this.btnChangeProjection.setText(i18n.getTranslation("_Change"));
        this.lblAlpha.setText(i18n.getTranslation("Alpha"));
    }

    public boolean isResizeable() {
        return true;
    }

    public void initializeValues() {
        ProjectPreferences projectPreferences = ApplicationLocator.getProjectManager().getProjectPreferences();
        this.defaultProjection.set((Object)projectPreferences.getDefaultProjection());
        this.chkInvisibleNewLayers.setSelected(projectPreferences.getAddNewLayersInInvisibleMode());
        this.chkKeepScaleOnResizing.setSelected(projectPreferences.getKeepScaleOnResizing());
        this.chkOpenWithANewMaximizedView.setSelected(projectPreferences.getOpenWithANewMaximizedView());
        this.chkHideLegendOfNonVisibleLayers.setSelected(projectPreferences.getHideLegendInToCOfNonVisibleLayers());
        this.txtZoomInFactor.setModel(new SpinnerNumberModel(projectPreferences.getZoomInFactor(), 0.01, 1000.0, 0.25));
        this.txtZoomOutFactor.setModel(new SpinnerNumberModel(projectPreferences.getZoomOutFactor(), 0.01, 1000.0, 0.25));
        MapContext.ZOOMINFACTOR = projectPreferences.getZoomInFactor();
        MapContext.ZOOMOUTFACTOR = projectPreferences.getZoomOutFactor();
        this.defaultViewBackColor.set((Object)projectPreferences.getDefaultViewBackColor());
        this.defaultSelectionColor.set((Object)projectPreferences.getDefaultSelectionColor());
        this.jCmbMapUnits.setModel(new DefaultComboBoxModel<String>(unitsNames));
        this.jCmbMapUnits.setSelectedIndex(projectPreferences.getDefaultMapUnits());
        this.jCmbDistanceUnits.setModel(new DefaultComboBoxModel<String>(unitsNames));
        this.jCmbDistanceUnits.setSelectedIndex(projectPreferences.getDefaultDistanceUnits());
        this.jCmbDistanceArea.setModel(new DefaultComboBoxModel<String>(areaUnitsNames));
        this.jCmbDistanceArea.setSelectedIndex(projectPreferences.getDefaultDistanceArea());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.hasChanges = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.hasChanges = true;
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("Vista");
    }

    public JPanel getPanel() {
        return this;
    }

    public void storeValues() throws StoreException {
        ProjectPreferences projectPreferences = ApplicationLocator.getProjectManager().getProjectPreferences();
        try {
            double zif = (Double)this.txtZoomInFactor.getValue();
            double zof = (Double)this.txtZoomOutFactor.getValue();
            if (zif == 0.0 || zof == 0.0) {
                throw new NumberFormatException();
            }
            projectPreferences.setZoomInFactor(zif);
            projectPreferences.setZoomOutFactor(zof);
            MapContext.ZOOMINFACTOR = zif;
            MapContext.ZOOMOUTFACTOR = zof;
            projectPreferences.setDefaultProjection((IProjection)this.defaultProjection.get());
            projectPreferences.setDefaultSelectionColor((Color)this.defaultSelectionColor.get());
            projectPreferences.setDefaultViewBackColor((Color)this.defaultViewBackColor.get());
            projectPreferences.setDefaultOverviewBackColor((Color)this.defaultViewBackColor.get());
            projectPreferences.setDefaultMapUnits(this.jCmbMapUnits.getSelectedIndex());
            projectPreferences.setDefaultDistanceUnits(this.jCmbDistanceUnits.getSelectedIndex());
            projectPreferences.setDefaultDistanceArea(this.jCmbDistanceArea.getSelectedIndex());
            projectPreferences.setAddNewLayersInInvisibleMode(this.chkInvisibleNewLayers.isSelected());
            projectPreferences.setKeepScaleOnResizing(this.chkKeepScaleOnResizing.isSelected());
            projectPreferences.setOpenWithANewMaximizedView(this.chkOpenWithANewMaximizedView.isSelected());
            projectPreferences.setHideLegendInToCOfNonVisibleLayers(this.chkHideLegendOfNonVisibleLayers.isSelected());
        }
        catch (Exception e) {
            throw new StoreException(PluginServices.getText((Object)this, (String)"factor_zoom_incorrecto"));
        }
    }

    public void initializeDefaults() {
        this.defaultProjection.set((Object)FACTORY_DEFAULT_PROJECTION);
        this.txtZoomInFactor.setModel(new SpinnerNumberModel(2.0, 1.0, 1000.0, 0.25));
        this.txtZoomOutFactor.setModel(new SpinnerNumberModel(1.5, 1.0, 1000.0, 0.25));
        this.chkInvisibleNewLayers.setSelected(false);
        this.chkKeepScaleOnResizing.setSelected(false);
        this.chkHideLegendOfNonVisibleLayers.setSelected(true);
        try {
            this.defaultViewBackColor.set((Object)((Color)UIManager.getLookAndFeel().getDefaults().get("TextField.background")));
        }
        catch (Exception es) {
            this.defaultViewBackColor.set((Object)FACTORY_DEFAULT_VIEW_BACK_COLOR);
        }
        this.defaultSelectionColor.set((Object)FACTORY_DEFAULT_SELECTION_COLOR);
        this.jCmbMapUnits.setSelectedIndex(FACTORY_DEFAULT_MAP_UNITS);
        this.jCmbDistanceUnits.setSelectedIndex(FACTORY_DEFAULT_DISTANCE_UNITS);
        this.jCmbDistanceArea.setSelectedIndex(FACTORY_DEFAULT_DISTANCE_AREA);
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = IconThemeHelper.getImageIcon((String)"document-view-icon");
        }
        return this.icon;
    }

    public boolean isValueChanged() {
        return this.hasChanges;
    }

    public void setChangesApplied() {
        this.hasChanges = false;
    }

    private void initUnitsNames() {
        int i;
        String[] names;
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (unitsNames == null) {
            names = MapContext.getDistanceNames();
            unitsNames = new String[names.length];
            for (i = 0; i < names.length; ++i) {
                ViewPage.unitsNames[i] = i18n.getTranslation(names[i]);
                if (!names[i].equals("Metros")) continue;
                FACTORY_DEFAULT_DISTANCE_UNITS = i;
                FACTORY_DEFAULT_DISTANCE_AREA = i;
                FACTORY_DEFAULT_MAP_UNITS = i;
            }
        }
        if (areaUnitsNames == null) {
            names = MapContext.getAreaNames();
            areaUnitsNames = new String[names.length];
            for (i = 0; i < names.length; ++i) {
                ViewPage.areaUnitsNames[i] = i18n.getTranslation(names[i]) + MapContext.getOfLinear((int)i);
            }
        }
    }
}

