/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage.databaseworkspace;

import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.app.gui.preferencespage.databaseworkspace.DatabaseWorkspacePageView;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;

public class DatabaseWorkspacePage
extends DatabaseWorkspacePageView
implements IPreference {
    private final ImageIcon icon;
    public static String id = DatabaseWorkspacePage.class.getName();
    private TaskStatusController statusController;

    public DatabaseWorkspacePage() {
        this.setParentID("org.gvsig.coreplugin.preferences.general.GeneralPage");
        this.icon = IconThemeHelper.getImageIcon((String)"databaseworkspace-preferences");
        this.initComponents();
    }

    public boolean isResizeable() {
        return true;
    }

    private void initComponents() {
        this.translateAll();
        this.btnRefreshWorkspaces.addActionListener(e -> this.fillWorkspacesTask());
        this.statusController = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(null, this.lblStatusLabel, this.lblStatusMessage, this.pbStatus, this.btnStatusStop, null);
        this.statusController.setVisible(false);
    }

    private void translateAll() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        manager.translate(this.lblSelectWorkspace);
        manager.translate((AbstractButton)this.chkConnectAutomatically);
        manager.translate((AbstractButton)this.btnRefreshWorkspaces);
    }

    public void storeValues() throws StoreException {
        PluginsManager pluginManager = PluginsLocator.getPluginsManager();
        PluginServices plugin = pluginManager.getPlugin((Object)this);
        DynObject preferences = plugin.getPluginProperties();
        preferences.setDynValue("connectAutomaticallyToDatabaseWorkspace", (Object)this.chkConnectAutomatically.isSelected());
        if (this.chkConnectAutomatically.isSelected() && this.lstSelectWorkspace.getSelectedValue() != null) {
            preferences.setDynValue("databaseWorkspaceToConnect", this.lstSelectWorkspace.getSelectedValue());
        }
    }

    public void setChangesApplied() {
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Database_repositories");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        PluginsManager pluginManager = PluginsLocator.getPluginsManager();
        PluginServices plugin = pluginManager.getPlugin((Object)this);
        DynObject preferences = plugin.getPluginProperties();
        this.lstSelectWorkspace.setSelectedIndex(-1);
        this.chkConnectAutomatically.setSelected((Boolean)preferences.getDynValue("connectAutomaticallyToDatabaseWorkspace"));
        this.lstSelectWorkspace.setSelectedValue(preferences.getDynValue("databaseWorkspaceToConnect"), true);
    }

    private void fillWorkspacesTask() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Searching_workspaces"));
        this.statusController.bind((TaskStatus)status);
        Thread task = new Thread(() -> this.fillWorkspaces(status), "PreferencesDatabaseWorkspaceFillWorkspaces");
        task.start();
    }

    private void fillWorkspaces(SimpleTaskStatus status) {
        DefaultListModel<String> connectionsModel = new DefaultListModel<String>();
        try {
            if (status == null) {
                status = SimpleTaskStatus.FAKE_STATUS;
            }
            status.add();
            SwingUtilities.invokeLater(() -> {
                this.lstSelectWorkspace.setEnabled(false);
                this.btnRefreshWorkspaces.setEnabled(false);
                this.statusController.setVisible(true);
            });
            DataManager dataManager = DALLocator.getDataManager();
            DataServerExplorerPool connections = dataManager.getDataServerExplorerPool();
            status.setAutoremove(true);
            status.setRangeOfValues(1L, (long)connections.size());
            for (DataServerExplorerPoolEntry connectionEntry : connections) {
                if (status.isCancellationRequested()) break;
                status.message(connectionEntry.getName());
                DataServerExplorerParameters connection = connectionEntry.getExplorerParameters();
                DatabaseWorkspaceManager workspaceManager = dataManager.createDatabaseWorkspaceManager(connection);
                if (workspaceManager.isValid()) {
                    connectionsModel.addElement(connectionEntry.getName());
                }
                status.incrementCurrentValue();
            }
            status.terminate();
        }
        catch (Exception ex) {
            status.abort();
            throw ex;
        }
        finally {
            SwingUtilities.invokeLater(() -> {
                this.lstSelectWorkspace.setEnabled(true);
                this.btnRefreshWorkspaces.setEnabled(true);
                this.statusController.setVisible(false);
                this.lstSelectWorkspace.setModel(connectionsModel);
                this.initializeValues();
            });
        }
    }

    public void initializeDefaults() {
        this.initializeValues();
        this.chkConnectAutomatically.setSelected(false);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return true;
    }
}

