/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.selectionByTheme;

import org.cresques.cts.IProjection;
import org.gvsig.app.gui.selectionByTheme.SelectionByThemeListener;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.evaluator.EvaluatorFieldsInfo;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySelectionByThemeListener
implements SelectionByThemeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySelectionByThemeListener.class);
    private final SimpleTaskStatus status;

    public MySelectionByThemeListener(SimpleTaskStatus status) {
        this.status = status;
    }

    private String getLayersNames(FLayer[] layers) {
        String layersStr = null;
        for (FLayer layer : layers) {
            if (!(layer instanceof FLyrVect)) continue;
            layersStr = layersStr == null ? layer.getName() : layersStr + ", " + layer.getName();
        }
        return layersStr;
    }

    @Override
    public void newSet(FLayer[] layersToSelect, FLayer selectionLayer, int action) {
        if (selectionLayer instanceof FLyrVect) {
            Thread task = new Thread(() -> {
                try {
                    FeatureSelection selection = ((FLyrVect)selectionLayer).getFeatureStore().getFeatureSelection();
                    SelectByTheme filter = new SelectByTheme(selection, selectionLayer.getMapContext().getProjection(), action);
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    String title = i18n.getTranslation("_Selecting") + " " + this.getLayersNames(layersToSelect);
                    this.status.setTitle(title);
                    this.status.restart();
                    this.status.add();
                    this.status.setAutoremove(true);
                    for (FLayer layerToSelect : layersToSelect) {
                        if (!(layerToSelect instanceof FLyrVect)) continue;
                        if (this.status.isCancellationRequested()) {
                            throw new UserCancelTaskException();
                        }
                        FeatureStore storeToQuery = ((FLyrVect)layerToSelect).getFeatureStore();
                        FeatureQuery fQuery = storeToQuery.createFeatureQuery();
                        filter.setData(storeToQuery, null);
                        long size = storeToQuery.getFeatureCount();
                        this.status.restart();
                        this.status.message(layerToSelect.getName());
                        this.status.setRangeOfValues(1L, size);
                        fQuery.setFilter((Evaluator)filter);
                        FeatureSet featureSet = null;
                        try {
                            featureSet = storeToQuery.getFeatureSet(fQuery);
                            storeToQuery.getFeatureSelection().deselectAll();
                            storeToQuery.setSelection(featureSet);
                        }
                        finally {
                            DisposeUtils.disposeQuietly((Disposable)featureSet);
                        }
                    }
                    this.status.terminate();
                }
                catch (UserCancelTaskException e) {
                    LOGGER.info("Cancelled by user");
                    this.status.cancel();
                }
                catch (Exception e) {
                    LOGGER.warn("error_selection_by_theme", (Throwable)e);
                    this.status.abort();
                }
                finally {
                    this.status.setTitle("");
                }
            }, "SelectByThemeNewSet");
            task.start();
        }
    }

    @Override
    public void addToSet(FLayer[] layersToSelect, FLayer selectionLayer, int action) {
        if (selectionLayer instanceof FLyrVect) {
            Thread task = new Thread(() -> {
                try {
                    FeatureSelection selection = ((FLyrVect)selectionLayer).getFeatureStore().getFeatureSelection();
                    SelectByTheme filter = new SelectByTheme(selection, selectionLayer.getMapContext().getProjection(), action);
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    String title = i18n.getTranslation("_Selecting") + " " + this.getLayersNames(layersToSelect);
                    this.status.setTitle(title);
                    this.status.restart();
                    this.status.add();
                    this.status.setAutoremove(true);
                    for (FLayer layerToSelect : layersToSelect) {
                        if (!(layerToSelect instanceof FLyrVect)) continue;
                        if (this.status.isCancellationRequested()) {
                            throw new UserCancelTaskException();
                        }
                        if (!selectionLayer.getFullEnvelope().intersects(layerToSelect.getFullEnvelope())) continue;
                        FeatureStore storeToQuery = ((FLyrVect)layerToSelect).getFeatureStore();
                        FeatureQuery fQuery = storeToQuery.createFeatureQuery();
                        filter.setData(storeToQuery, null);
                        long size = storeToQuery.getFeatureCount();
                        this.status.restart();
                        this.status.message(layerToSelect.getName());
                        this.status.setRangeOfValues(1L, size);
                        fQuery.setFilter((Evaluator)filter);
                        FeatureSet newFeatureSet = null;
                        FeatureSelection previousFeatureSet = null;
                        try {
                            newFeatureSet = storeToQuery.getFeatureSet(fQuery);
                            previousFeatureSet = storeToQuery.getFeatureSelection();
                            previousFeatureSet.select(newFeatureSet);
                            storeToQuery.setSelection((FeatureSet)previousFeatureSet);
                        }
                        catch (Throwable throwable) {
                            DisposeUtils.disposeQuietly((Disposable)newFeatureSet);
                            DisposeUtils.disposeQuietly(previousFeatureSet);
                            throw throwable;
                        }
                        DisposeUtils.disposeQuietly((Disposable)newFeatureSet);
                        DisposeUtils.disposeQuietly((Disposable)previousFeatureSet);
                    }
                    this.status.terminate();
                }
                catch (UserCancelTaskException e) {
                    LOGGER.info("Cancelled by user");
                    this.status.cancel();
                }
                catch (Exception e) {
                    LOGGER.warn("error_selection_by_theme", (Throwable)e);
                    this.status.abort();
                }
                finally {
                    this.status.setTitle("");
                }
            }, "SelectByThemeAddToSet");
            task.start();
        }
    }

    @Override
    public void fromSet(FLayer[] layersToSelect, FLayer selectionLayer, int action) {
        if (selectionLayer instanceof FLyrVect) {
            Thread task = new Thread(() -> {
                try {
                    FeatureSelection selection = ((FLyrVect)selectionLayer).getFeatureStore().getFeatureSelection();
                    SelectByTheme filter = new SelectByTheme(selection, selectionLayer.getMapContext().getProjection(), action);
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    String title = i18n.getTranslation("_Selecting") + " " + this.getLayersNames(layersToSelect);
                    this.status.setTitle(title);
                    this.status.restart();
                    this.status.add();
                    this.status.setAutoremove(true);
                    for (FLayer layerToSelect : layersToSelect) {
                        if (!(layerToSelect instanceof FLyrVect)) continue;
                        if (this.status.isCancellationRequested()) {
                            throw new UserCancelTaskException();
                        }
                        if (!selectionLayer.getFullEnvelope().intersects(layerToSelect.getFullEnvelope())) continue;
                        FeatureStore storeToQuery = ((FLyrVect)layerToSelect).getFeatureStore();
                        FeatureQuery fQuery = storeToQuery.createFeatureQuery();
                        filter.setData(storeToQuery, (FeatureSelection)storeToQuery.getSelection());
                        long size = storeToQuery.getFeatureCount();
                        this.status.restart();
                        this.status.message(layerToSelect.getName());
                        this.status.setRangeOfValues(1L, size);
                        fQuery.setFilter((Evaluator)filter);
                        FeatureSet featureSet = null;
                        try {
                            featureSet = storeToQuery.getFeatureSet(fQuery);
                            storeToQuery.getFeatureSelection().deselectAll();
                            storeToQuery.setSelection(featureSet);
                        }
                        finally {
                            DisposeUtils.disposeQuietly((Disposable)featureSet);
                        }
                    }
                    this.status.terminate();
                }
                catch (UserCancelTaskException e) {
                    LOGGER.info("Cancelled by user");
                    this.status.cancel();
                }
                catch (Exception e) {
                    LOGGER.warn("error_selection_by_theme", (Throwable)e);
                    this.status.abort();
                }
                finally {
                    this.status.setTitle("");
                }
            }, "SelectByThemeFromSet");
            task.start();
        }
    }

    class SelectByTheme
    implements Evaluator {
        private FeatureSelection selection = null;
        private final IProjection projection;
        private FeatureStore store;
        private String geomName;
        private EvaluatorFieldsInfo info;
        private FeatureSelection featureSelection;
        private final int action;

        public SelectByTheme(FeatureSelection selection, IProjection projection, int action) {
            this.selection = selection;
            this.projection = projection;
            this.action = action;
        }

        public void setData(FeatureStore store, FeatureSelection featureSelection) throws DataException {
            this.store = store;
            this.geomName = store.getDefaultFeatureType().getDefaultGeometryAttributeName();
            this.featureSelection = featureSelection;
            this.info = new EvaluatorFieldsInfo();
            this.info.addFieldValue(this.geomName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object evaluate(EvaluatorData data) throws EvaluatorException {
            if (this.featureSelection != null && !this.featureSelection.isSelected((Feature)data.getContextValue("feature"))) {
                return false;
            }
            DisposableIterator features = null;
            try {
                features = this.selection.fastIterator();
                while (features.hasNext()) {
                    Evaluator eval;
                    if (MySelectionByThemeListener.this.status.isCancellationRequested()) {
                        MySelectionByThemeListener.this.status.cancel();
                        throw new UserCancelTaskException();
                    }
                    Feature feature = (Feature)features.next();
                    Geometry geometry = feature.getDefaultGeometry();
                    switch (this.action) {
                        case 2: {
                            eval = SpatialEvaluatorsFactory.getInstance().intersects(geometry, this.projection, this.store);
                            break;
                        }
                        case 6: {
                            eval = SpatialEvaluatorsFactory.getInstance().contains(geometry, this.projection, this.store);
                            break;
                        }
                        case 4: {
                            eval = SpatialEvaluatorsFactory.getInstance().crosses(geometry, this.projection, this.store);
                            break;
                        }
                        case 1: {
                            eval = SpatialEvaluatorsFactory.getInstance().disjoint(geometry, this.projection, this.store);
                            break;
                        }
                        case 0: {
                            eval = SpatialEvaluatorsFactory.getInstance().equals(geometry, this.projection, this.store);
                            break;
                        }
                        case 7: {
                            eval = SpatialEvaluatorsFactory.getInstance().overlaps(geometry, this.projection, this.store);
                            break;
                        }
                        case 3: {
                            eval = SpatialEvaluatorsFactory.getInstance().touches(geometry, this.projection, this.store);
                            break;
                        }
                        case 5: {
                            eval = SpatialEvaluatorsFactory.getInstance().within(geometry, this.projection, this.store);
                            break;
                        }
                        default: {
                            eval = SpatialEvaluatorsFactory.getInstance().intersects(geometry, this.projection, this.store);
                        }
                    }
                    Boolean evaluate = (Boolean)eval.evaluate(data);
                    if (!evaluate.booleanValue()) continue;
                    Boolean bl = evaluate;
                    return bl;
                }
            }
            catch (DataException e) {
                LOGGER.warn("error_selection_by_theme", (Throwable)e);
            }
            finally {
                DisposeUtils.dispose((Disposable)features);
                MySelectionByThemeListener.this.status.incrementCurrentValue();
            }
            return false;
        }

        public String getName() {
            return "select by theme";
        }

        public String getSQL() {
            return null;
        }

        public String getDescription() {
            return this.getName();
        }

        public EvaluatorFieldsInfo getFieldsInfo() {
            return this.info;
        }
    }
}

