/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.panelGroup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.buttonspanel.IButtonsPanel;
import org.gvsig.gui.beans.defaultbuttonspanel.DefaultButtonsPanel;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.gui.beans.panelGroup.IPanelGroup;
import org.gvsig.gui.beans.panelGroup.exceptions.EmptyPanelGroupException;
import org.gvsig.gui.beans.panelGroup.exceptions.EmptyPanelGroupGUIException;
import org.gvsig.gui.beans.panelGroup.exceptions.ListCouldntAddPanelException;
import org.gvsig.gui.beans.panelGroup.loaders.IPanelGroupLoader;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;
import org.gvsig.tools.exception.BaseException;

public class PanelGroupDialog
extends DefaultButtonsPanel
implements ButtonsPanelListener,
IWindow,
IWindowListener,
IPanelGroup,
IButtonsPanel,
Serializable {
    private static final long serialVersionUID = 6267404338808012765L;
    protected static int defaultWidth = 530;
    protected static int defaultHeight = 432;
    protected IPanelGroup panelGroup;
    private WindowInfo windowInfo;

    public PanelGroupDialog(String windowTitle, IPanelGroup panelGroup) {
        super(3);
        this.windowInfo = new WindowInfo();
        this.windowInfo.setTitle(PluginServices.getText((Object)this, (String)windowTitle));
        this.windowInfo.setWidth(defaultWidth);
        this.windowInfo.setHeight(defaultHeight);
        this.panelGroup = panelGroup;
        this.initialize();
    }

    public PanelGroupDialog(String additionalInfo, String windowTitle, int width, int height, byte windowInfoProperties, IPanelGroup panelGroup) {
        super(3);
        this.windowInfo = new WindowInfo((int)windowInfoProperties);
        this.windowInfo.setAdditionalInfo(additionalInfo);
        this.windowInfo.setTitle(PluginServices.getText((Object)this, (String)windowTitle));
        this.windowInfo.setWidth(width);
        this.windowInfo.setHeight(height);
        this.panelGroup = panelGroup;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.addButtonPressedListener(this);
        this.panelGroup.setParentPanelGroup((IPanelGroup)this);
        if (this.panelGroup != null) {
            this.add((Component)((AbstractPanelGroup)this.panelGroup), "Center");
            if (this.windowInfo.getWidth() > this.getPreferredSize().width || this.windowInfo.getHeight() > this.getPreferredSize().height) {
                this.setPreferredSize(new Dimension(Math.max(this.windowInfo.getWidth(), this.getWidth()), Math.max(this.windowInfo.getHeight(), this.getHeight())));
            }
        }
    }

    public boolean isResizable() {
        return this.windowInfo.isResizable();
    }

    public void close() {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public WindowInfo getWindowInfo() {
        return this.windowInfo;
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (this.panelGroup != null) {
            switch (e.getButton()) {
                case 1: {
                    this.accept();
                    this.close();
                    break;
                }
                case 3: {
                    this.apply();
                    break;
                }
                case 2: {
                    this.cancel();
                    this.close();
                }
            }
        }
    }

    public void windowActivated() {
    }

    public void windowClosed() {
        if (this.panelGroup != null && !this.panelGroup.isAccepted()) {
            this.panelGroup.cancel();
        }
    }

    public void accept() {
        this.panelGroup.accept();
    }

    public void addPanel(IPanel panel) throws BaseException {
        this.panelGroup.addPanel(panel);
    }

    public void apply() {
        this.panelGroup.apply();
    }

    public void cancel() {
        this.panelGroup.cancel();
    }

    public IPanel getActivePanel() {
        return this.panelGroup.getActivePanel();
    }

    public Hashtable getProperties() {
        return this.panelGroup.getProperties();
    }

    public Object getReference() {
        return this.panelGroup.getReference();
    }

    public void updateReference(Object reference) {
        this.panelGroup.updateReference(reference);
    }

    public boolean isAccepted() {
        return this.panelGroup.isAccepted();
    }

    public void loadPanels(IPanelGroupLoader loader) throws ListCouldntAddPanelException, EmptyPanelGroupException, EmptyPanelGroupGUIException {
        block5: {
            try {
                this.panelGroup.loadPanels(loader);
                if (this.panelGroup.getPanelInGUICount() == 0) {
                    this.close();
                }
            }
            catch (BaseException be) {
                BaseException.setTranslator((Object)new Messages());
                JOptionPane.showMessageDialog((Component)((Object)this), be.getLocalizedMessageStack());
                if (this.panelGroup.getPanelInGUICount() == 0) {
                    this.close();
                }
            }
            catch (Exception e) {
                NotificationManager.showMessageError((String)e.getMessage(), (Exception)e);
                if (this.panelGroup.getPanelInGUICount() != 0) break block5;
                this.close();
            }
        }
    }

    public void removePanel(IPanel panel) {
        this.panelGroup.removePanel(panel);
    }

    public boolean isPanelInGUI(IPanel panel) {
        return this.panelGroup.isPanelInGUI(panel);
    }

    public void setPanelInGUI(IPanel panel, boolean b) {
        this.panelGroup.setPanelInGUI(panel, b);
    }

    public int getPanelCount() {
        return this.panelGroup.getPanelCount();
    }

    public int getPanelInGUICount() {
        return this.panelGroup.getPanelInGUICount();
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.windowInfo.setWidth(preferredSize.width);
        this.windowInfo.setHeight(preferredSize.height);
    }

    public void setParentPanelGroup(IPanelGroup parent) {
        this.panelGroup.setParentPanelGroup(parent);
    }

    public boolean isEnabledAcceptButton() {
        return this.getButtonsPanel().getButton(1).isEnabled();
    }

    public boolean isEnabledApplyButton() {
        return this.getButtonsPanel().getButton(3).isEnabled();
    }

    public boolean isEnabledCancelButton() {
        return this.getButtonsPanel().getButton(2).isEnabled();
    }

    public boolean isEnabledCloseButton() {
        return false;
    }

    public boolean isEnabledExitButton() {
        return false;
    }

    public boolean isEnabledHideDetailsButton() {
        return false;
    }

    public boolean isEnabledNoButton() {
        return false;
    }

    public boolean isEnabledPauseButton() {
        return false;
    }

    public boolean isEnabledRestartButton() {
        return false;
    }

    public boolean isEnabledSaveButton() {
        return false;
    }

    public boolean isEnabledSeeDetailsButton() {
        return false;
    }

    public boolean isEnabledYesButton() {
        return false;
    }

    public void setEnabledAcceptButton(boolean b) {
        this.getButtonsPanel().getButton(1).setEnabled(b);
    }

    public void setEnabledApplyButton(boolean b) {
        this.getButtonsPanel().getButton(3).setEnabled(b);
    }

    public void setEnabledCancelButton(boolean b) {
        this.getButtonsPanel().getButton(2).setEnabled(b);
    }

    public void setEnabledCloseButton(boolean b) {
    }

    public void setEnabledExitButton(boolean b) {
    }

    public void setEnabledHideDetailsButton(boolean b) {
    }

    public void setEnabledNoButton(boolean b) {
    }

    public void setEnabledPauseButton(boolean b) {
    }

    public void setEnabledRestartButton(boolean b) {
    }

    public void setEnabledSaveButton(boolean b) {
    }

    public void setEnabledSeeDetailsButton(boolean b) {
    }

    public void setEnabledYesButton(boolean b) {
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }
}

