/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.DocumentsContainer;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.gui.IDocumentWindow;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.fmap.mapcontext.layers.ExtendedPropertiesHelper;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.identitymanagement.UnauthorizedException;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentManager
implements DocumentManager,
Observer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDocumentManager.class);
    private Map<String, JComponent> mainComponents = new HashMap<String, JComponent>();
    private DelegateWeakReferencingObservable observableHelper = null;
    private ExtendedPropertiesHelper propertiesHelper = new ExtendedPropertiesHelper();

    protected AbstractDocumentManager() {
        this.observableHelper = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public ImageIcon getIcon() {
        return PluginServices.getIconTheme().get("document-icon-sel");
    }

    @Override
    public ImageIcon getIconSelected() {
        return PluginServices.getIconTheme().get("document-icon");
    }

    @Override
    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"documento");
    }

    @Override
    public AbstractDocument createDocumentByUser() {
        return this.createDocument();
    }

    @Override
    public Iterator<? extends Document> createDocumentsByUser() {
        HashSet<AbstractDocument> doc = new HashSet<AbstractDocument>(1);
        doc.add(this.createDocumentByUser());
        return doc.iterator();
    }

    @Override
    public Iterator<? extends Document> createDocumentsByUser(Invocable whenDocumentsLoaded) {
        HashSet<AbstractDocument> docs = new HashSet<AbstractDocument>(1);
        docs.add(this.createDocumentByUser());
        return docs.iterator();
    }

    public Object create() {
        return this;
    }

    public Object create(Object[] args) {
        return this;
    }

    public Object create(Map args) {
        return this;
    }

    @Override
    public IWindow getMainWindow(Document doc) {
        return this.getMainWindow(doc, null);
    }

    @Override
    public IWindow getMainWindow(Document doc, WindowLayout layout) {
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        if (!identityManager.getCurrentIdentity().isAuthorized("project-document-access", (Object)this, this.getTypeName())) {
            throw new UnauthorizedException("project-document-access", (Object)this, this.getTypeName());
        }
        IDocumentWindow win = (IDocumentWindow)PluginServices.getMDIManager().getSingletonWindow(this.getMainWindowClass(), (Object)doc);
        return win;
    }

    @Override
    public boolean hasMainWindow(Document doc) {
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        if (!identityManager.getCurrentIdentity().isAuthorized("project-document-access", (Object)this, this.getTypeName())) {
            throw new UnauthorizedException("project-document-access", (Object)this, this.getTypeName());
        }
        IDocumentWindow win = (IDocumentWindow)PluginServices.getMDIManager().getSingletonWindow(this.getMainWindowClass(), (Object)doc);
        return win != null;
    }

    @Override
    public IWindow getPropertiesWindow(Document doc) {
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        if (!identityManager.getCurrentIdentity().isAuthorized("project-document-access", (Object)this, this.getTypeName())) {
            throw new UnauthorizedException("project-document-access", (Object)this, this.getTypeName());
        }
        return null;
    }

    @Override
    public JComponent getMainComponent(Document doc) {
        ApplicationManager application = ApplicationLocator.getManager();
        Document activeDoc = application.getActiveDocument(this.getDocumentClass());
        if (activeDoc == doc) {
            IWindow win = this.getMainWindow(doc);
            if (win instanceof Component) {
                return ((Component)win).asJComponent();
            }
            return (JComponent)win;
        }
        if (activeDoc instanceof DocumentsContainer) {
            DocumentsContainer container = (DocumentsContainer)((Object)activeDoc);
            return this.getMainComponent(container, doc);
        }
        return null;
    }

    @Override
    public JComponent getMainComponent(DocumentsContainer container, Document doc) {
        Formatter f = new Formatter();
        f.format("08X", container.hashCode());
        f.format("08X", doc.hashCode());
        String key = f.toString();
        f.close();
        return this.mainComponents.get(key);
    }

    @Override
    public void unregisterMainComponent(DocumentsContainer container, Document doc) {
        Formatter f = new Formatter();
        f.format("08X", container.hashCode());
        f.format("08X", doc.hashCode());
        String key = f.toString();
        f.close();
        this.mainComponents.remove(key);
    }

    @Override
    public void registerMainComponent(DocumentsContainer container, Document doc, JComponent component) {
        Formatter f = new Formatter();
        f.format("08X", container.hashCode());
        f.format("08X", doc.hashCode());
        String key = f.toString();
        f.close();
        this.mainComponents.put(key, component);
    }

    @Override
    public boolean existName(Project project, String documentName) {
        return project.getDocument(documentName, this.getTypeName()) != null;
    }

    protected abstract Class getDocumentClass();

    @Override
    public Class getClassOfDocument() {
        return this.getDocumentClass();
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        AbstractDocument doc = this.createDocument();
        return doc;
    }

    public void loadFromState(PersistentState state, Object object) throws PersistenceException {
        Document doc = (Document)object;
        doc.loadFromState(state);
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        Document doc = (Document)obj;
        doc.saveToState(state);
    }

    public boolean manages(Class theClass) {
        return this.getDocumentClass().isAssignableFrom(theClass);
    }

    public boolean manages(PersistentState state) {
        try {
            Class<?> theClass = Class.forName(state.getTheClassName());
            return this.manages(theClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public List<DynStruct> getDefinitions() {
        DynStruct definition = this.getDefinition(this.getDocumentClass().getName());
        ArrayList<DynStruct> definitions = new ArrayList<DynStruct>();
        definitions.add(definition);
        return definitions;
    }

    public String getDomainName() {
        return "gvsig";
    }

    public String getDomainURL() {
        return "http://www.gvsig.org";
    }

    public List getManagedClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(this.getDocumentClass());
        return classes;
    }

    public Class getManagedClass(Object object) {
        return this.getDocumentClass();
    }

    public Class getManagedClass(PersistentState state) {
        return this.getDocumentClass();
    }

    public Class getManagedClass(String name) {
        return this.getDocumentClass();
    }

    public String getManagedClassName(Object object) {
        Class clazz = this.getManagedClass(object);
        if (clazz != null) {
            return clazz.getName();
        }
        return null;
    }

    protected IDocumentWindow createDocumentWindow(Document document) {
        IDocumentWindow documentWindow = null;
        Class<? extends IDocumentWindow> windowClass = this.getMainWindowClass();
        try {
            try {
                Constructor<? extends IDocumentWindow> constructor = windowClass.getConstructor(Document.class);
                documentWindow = constructor.newInstance(document);
            }
            catch (NoSuchMethodException e1) {
                documentWindow = windowClass.newInstance();
                documentWindow.setDocument(document);
            }
        }
        catch (Exception e) {
            logger.warn("Can't create the document window.", (Throwable)e);
            return null;
        }
        return documentWindow;
    }

    public void update(Observable observable, Object notification) {
    }

    public void addObserver(Observer o) {
        this.observableHelper.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observableHelper.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    protected Notification notifyObservers(String type, Document doc) {
        BaseNotification notification = new BaseNotification(type, new Object[]{doc});
        this.observableHelper.notifyObservers((Object)notification);
        return notification;
    }

    protected Notification notifyObservers(String type, IWindow doc) {
        BaseNotification notification = new BaseNotification(type, new Object[]{doc});
        this.observableHelper.notifyObservers((Object)notification);
        return notification;
    }

    public Object getProperty(Object key) {
        return this.propertiesHelper.getProperty(key);
    }

    public void setProperty(Object key, Object obj) {
        this.propertiesHelper.setProperty(key, obj);
    }

    public Map getExtendedProperties() {
        return this.propertiesHelper.getExtendedProperties();
    }
}

