/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.actions;

import java.util.List;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocumentAction;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.actions.CopyPasteDocsUtils;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteDocumentAction
extends AbstractDocumentAction {
    private static Logger logger = LoggerFactory.getLogger(PasteDocumentAction.class);

    public PasteDocumentAction() {
        super("paste");
        this.order = 0;
        this.title = PluginServices.getText((Object)this, (String)"pegar");
        this.group = ProjectManager.getInstance().addDocumentActionGroup("ClipboardActions", "Clipboard actions", null, 0);
    }

    @Override
    public void execute(Document document, List<Document> documents) {
        List<Document> docs = null;
        try {
            docs = CopyPasteDocsUtils.getClipboardDocuments(null);
        }
        catch (Exception e) {
            logger.info("While getting docs from clipboard.", (Throwable)e);
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Clipboard_error") + ":\n" + CopyPasteDocsUtils.getLastMessage(e), this.title, 0);
            return;
        }
        if (docs.size() == 0) {
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_There_are_no_documents_to_paste"), this.title, 1);
            return;
        }
        Project project = ProjectManager.getInstance().getCurrentProject();
        for (int i = 0; i < docs.size(); ++i) {
            project.add(docs.get(i));
        }
    }

    @Override
    public boolean isAvailable(Document document, List<Document> documents) {
        return CopyPasteDocsUtils.getClipboardFiles(null).size() > 0;
    }

    @Override
    public boolean isVisible(Document document, List<Document> documents) {
        return true;
    }
}

