/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentAction;
import org.gvsig.app.project.documents.DocumentActionGroup;

public class DocumentContextMenu
extends JPopupMenu {
    private static final long serialVersionUID = -8153469580038240864L;
    private Document item;
    private List<Document> seleteds;
    private List<DocumentAction> actions = null;

    public DocumentContextMenu(String doctype, Document document, Document[] seletedDocuments) {
        List<DocumentAction> allActions = ProjectManager.getInstance().getDocumentActions(doctype);
        ArrayList<DocumentAction> actions = new ArrayList<DocumentAction>();
        DocumentActionGroup group = null;
        this.item = document;
        this.seleteds = Arrays.asList(seletedDocuments);
        if (allActions != null) {
            for (DocumentAction action : allActions) {
                if (!action.isVisible(document, this.seleteds)) continue;
                actions.add(action);
                MenuItem item = new MenuItem(action.getTitle(), action);
                item.setEnabled(action.isAvailable(this.item, this.seleteds));
                if (!action.getGroup().equals(group)) {
                    if (group != null) {
                        this.addSeparator();
                    }
                    group = action.getGroup();
                }
                this.add(item);
            }
        }
        this.actions = actions;
    }

    public boolean hasActions() {
        return this.actions != null || this.actions.size() > 0;
    }

    private class MenuItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = -752624469241001299L;
        private DocumentAction action;

        public MenuItem(String text, DocumentAction action) {
            super(text);
            this.action = action;
            String tip = this.action.getDescription();
            if (tip != null && tip.length() > 0) {
                this.setToolTipText(tip);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.execute(DocumentContextMenu.this.item, DocumentContextMenu.this.seleteds);
        }
    }
}

