/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.gui.projectpanel.ProjectPanelPage;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.propertypage.PropertiesPageManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.util.ToolsUtilLocator;

public class ProjectWindow
extends JPanel
implements SingletonWindow {
    private Project project;
    private WindowInfo viewInfo;
    private final List<PropertiesPage> pages;

    public ProjectWindow() {
        PropertiesPageManager manager = ToolsUtilLocator.getPropertiesPageManager();
        this.pages = manager.getPages("ProyectPanel", (Object)this, null);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        Component contents = this.createPagesPanel();
        this.add(contents, "Center");
    }

    protected Component createPagesPanel() {
        if (this.pages.size() == 1 && !this.useTabsAlwais()) {
            PropertiesPage page = this.pages.get(0);
            return page.asJComponent();
        }
        JTabbedPane theTabbedPane = new JTabbedPane();
        for (int i = 0; i < this.pages.size(); ++i) {
            PropertiesPage page = this.pages.get(i);
            theTabbedPane.addTab(page.getTitle(), page.asJComponent());
        }
        return theTabbedPane;
    }

    protected boolean useTabsAlwais() {
        return false;
    }

    public Object getWindowModel() {
        return this.project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
        for (PropertiesPage page : this.pages) {
            if (!(page instanceof ProjectPanelPage)) continue;
            ((ProjectPanelPage)page).setProject(project);
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.PROJECT_PROFILE;
    }

    public WindowInfo getWindowInfo() {
        if (this.viewInfo == null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.viewInfo = new WindowInfo(3);
            this.viewInfo.setWidth(this.getWidth());
            this.viewInfo.setHeight(this.getHeight());
            Dimension dim = ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)25, (int)65);
            this.viewInfo.setNormalWidth(dim.width);
            this.viewInfo.setNormalHeight(dim.height);
            this.viewInfo.setMinimumSize(this.getPreferredSize());
            this.viewInfo.setTitle(i18n.getTranslation("_Project_manager"));
        }
        return this.viewInfo;
    }
}

