/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.gui;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.legend.gui.PanelEditSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;

public class SymbolCellEditor
extends JButton
implements TableCellEditor {
    private static final long serialVersionUID = -913612642474934455L;
    private ArrayList listeners = new ArrayList();
    private ISymbol symbol;
    private int shapeType;
    private PanelEditSymbol symbolPanel;

    public SymbolCellEditor(int shapeType) {
        this.shapeType = shapeType;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SymbolCellEditor.this.symbolPanel.setSymbol(SymbolCellEditor.this.symbol);
                SymbolCellEditor.this.symbolPanel.setShapeType(SymbolCellEditor.this.symbol.getSymbolType());
                PluginServices.getMDIManager().addWindow((IWindow)SymbolCellEditor.this.symbolPanel);
                if (SymbolCellEditor.this.symbolPanel.isOK()) {
                    SymbolCellEditor.this.symbol = SymbolCellEditor.this.symbolPanel.getSymbol();
                    SymbolCellEditor.this.stopCellEditing();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SymbolCellEditor.this.stopCellEditing();
                } else if (e.getKeyCode() == 27) {
                    SymbolCellEditor.this.cancelCellEditing();
                }
            }
        });
        this.symbolPanel = new PanelEditSymbol();
    }

    @Override
    public Object getCellEditorValue() {
        return this.symbol;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.symbol = (ISymbol)value;
        return this;
    }

    @Override
    public void cancelCellEditing() {
        if (this.symbol != null) {
            // empty if block
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingCanceled(evt);
        }
    }

    @Override
    public boolean stopCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingStopped(evt);
        }
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }
}

