/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.info.gui.HTMLInfoToolPanel;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.ErrorEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ErrorListener;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.ExtendedPropertiesHelper;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseViewDocument
extends AbstractDocument
implements ErrorListener,
ViewDocument {
    private static final long serialVersionUID = -2621709089720665902L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseViewDocument.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "BaseViewDocument";
    protected MapContext mapOverViewContext;
    protected MapContext mapContext;
    private ExtendedPropertiesHelper propertiesHelper = new ExtendedPropertiesHelper();

    public BaseViewDocument() {
    }

    public BaseViewDocument(DocumentManager factory) {
        super(factory);
    }

    @Override
    public void setProject(Project project) {
        super.setProject(project);
        if (this.mapContext != null) {
            this.mapContext.setSelectionColor(project.getSelectionColor());
        }
    }

    @Override
    public MapContext getMapContext() {
        if (this.mapContext != null && DisposeUtils.isNullOrDisposed((Disposable)this.mapContext)) {
            try {
                throw new RuntimeException();
            }
            catch (Exception ex) {
                LOGGER.info("MapContext of view '" + Objects.toString(this.getName()) + "' is disposed", (Throwable)ex);
            }
        }
        return this.mapContext;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.mapContext.getLayers().setName(name);
    }

    @Override
    public MapContext getMapOverViewContext() {
        return this.mapOverViewContext;
    }

    @Override
    public void setMapContext(MapContext fmap) {
        this.mapContext = fmap;
        Project p = this.getProject();
        if (p != null) {
            this.mapContext.setSelectionColor(p.getSelectionColor());
        }
        fmap.addErrorListener((ErrorListener)this);
    }

    @Override
    public void setMapOverViewContext(MapContext fmap) {
        this.mapOverViewContext = fmap;
        this.mapOverViewContext.setProjection(this.mapContext.getProjection());
    }

    public void showErrors() {
        if (!this.mapContext.getLayersError().isEmpty()) {
            String layersError = "";
            for (int i = 0; i < this.mapContext.getLayersError().size(); ++i) {
                layersError = layersError + "\n" + (String)this.mapContext.getLayersError().get(i);
            }
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"fallo_capas") + " : \n" + layersError);
        }
    }

    public void reportDriverExceptions(String introductoryText, List driverExceptions) {
        HtmlWindow htmlPanel = new HtmlWindow(570, 600, PluginServices.getText((Object)this, (String)"driver_error"));
        String htmlText = "";
        htmlText = introductoryText == null ? htmlText + "<h2 text=\"#000080\">" + PluginServices.getText((Object)this, (String)"se_han_producido_los_siguientes_errores_durante_la_carga_de_las_capas") + "</h2>" : htmlText + introductoryText;
        int numErrors = driverExceptions.size();
        for (int i = 0; i < numErrors; ++i) {
            BaseException exception = (BaseException)((Object)driverExceptions.get(i));
            htmlText = htmlText + "<p text=\"#550080\">_________________________________________________________________________________________</p>";
            htmlText = htmlText + "<h3>" + PluginServices.getText((Object)this, (String)exception.getMessageKey()) + "</h3>";
            htmlText = htmlText + "<p>" + exception.getMessage() + "</p>";
            htmlText = htmlText + "<p text=\"#550080\">_________________________________________________________________________________________</p>";
        }
        System.out.println(htmlText);
        htmlPanel.show(htmlText);
        PluginServices.getMDIManager().addCentredWindow((IWindow)htmlPanel);
    }

    @Override
    public IProjection getProjection() {
        if (this.mapContext == null) {
            return null;
        }
        return this.mapContext.getProjection();
    }

    @Override
    public void setProjection(IProjection proj) {
        this.mapContext.setProjection(proj);
        this.mapOverViewContext.setProjection(proj);
    }

    public IProjection getOverViewProjection() {
        return this.mapOverViewContext.getProjection();
    }

    @Override
    public void afterRemove() {
        FLayers layers = this.getMapContext().getLayers();
        for (int i = layers.getLayersCount() - 1; i >= 0; --i) {
            try {
                layers.getLayer(i).getParentLayer().removeLayer(layers.getLayer(i));
                continue;
            }
            catch (CancelationException e1) {
                LOGGER.warn("Can't remove layer");
            }
        }
        this.getMapContext().dispose();
        this.getMapOverViewContext().dispose();
    }

    @Override
    public void afterAdd() {
    }

    @Override
    public void setBackColor(Color c) {
        this.getMapContext().getViewPort().setBackColor(c);
    }

    public void errorThrown(ErrorEvent e) {
        JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"fallo_capas") + " : \n" + e.getMessage());
    }

    @Override
    public boolean isLocked() {
        if (super.isLocked()) {
            return true;
        }
        FLayers layers = this.getMapContext().getLayers();
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            FLayer layer = layers.getLayer(i);
            if (!layer.isEditing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("mainMapContext", (Persistent)this.getMapContext());
        if (this.getMapOverViewContext() != null) {
            state.set("useMapOverview", true);
        } else {
            state.set("useMapOverview", false);
        }
        state.set("overviewMapContext", (Persistent)this.getMapOverViewContext());
        state.set("propertiesHelper", (Persistent)this.propertiesHelper);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.mapContext = (MapContext)state.get("mainMapContext");
        this.mapOverViewContext = state.getBoolean("useMapOverview") ? (MapContext)state.get("overviewMapContext") : null;
        this.propertiesHelper = (ExtendedPropertiesHelper)state.get("propertiesHelper");
        IProjection proj = ApplicationLocator.getProjectManager().getProjectPreferences().getDefaultProjection();
        if (this.mapContext != null && this.mapContext.getProjection() == null) {
            try {
                this.mapContext.setProjection(proj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (FLayer layer : this.mapContext) {
            if (layer.getProjection() != null) continue;
            try {
                layer.setProjection(proj);
            }
            catch (Throwable throwable) {}
        }
        for (FLayer layer : this.mapOverViewContext) {
            if (layer.getProjection() != null) continue;
            try {
                layer.setProjection(proj);
            }
            catch (Throwable throwable) {}
        }
    }

    public Object getProperty(Object key) {
        return this.propertiesHelper.getProperty(key);
    }

    public void setProperty(Object key, Object obj) {
        this.propertiesHelper.setProperty(key, obj);
    }

    public Map getExtendedProperties() {
        return this.propertiesHelper.getExtendedProperties();
    }

    @Override
    public FLayer getLayer(String name) {
        FLayer layer = this.getMapContext().getLayers().getLayer(name);
        return layer;
    }

    @Override
    public Iterator<FLayer> iterator() {
        return this.mapContext.iterator();
    }

    @Override
    public Iterator<FLayer> deepiterator() {
        return this.mapContext.deepiterator();
    }

    @Override
    public Iterable<FLayer> layers() {
        return () -> this.deepiterator();
    }

    @Override
    public boolean contains(FLayer layer) {
        if (!(layer instanceof SingleLayer)) {
            return false;
        }
        return this.isInLayers(this.getMapContext().getLayers(), ((SingleLayer)layer).getDataStore());
    }

    @Override
    public boolean contains(DataStore store) {
        return this.isInLayers(this.getMapContext().getLayers(), store);
    }

    private boolean isInLayers(FLayers layers, DataStore store) {
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            if (layers.getLayer(i) instanceof FLayers && this.isInLayers((FLayers)layers.getLayer(i), store)) {
                return true;
            }
            FLayer layer = layers.getLayer(i);
            if (!(layer instanceof SingleLayer) || ((SingleLayer)layer).getDataStore() != store) continue;
            return true;
        }
        return false;
    }

    @Override
    public void center(Envelope envelope) {
        ViewPort viewPort = this.getMapContext().getViewPort();
        try {
            Envelope oldExtent = viewPort.getAdjustedEnvelope();
            double oldCenterX = oldExtent.getCenter(0);
            double oldCenterY = oldExtent.getCenter(1);
            double centerX = envelope.getCenter(0);
            double centerY = envelope.getCenter(1);
            Point2D.Double center = new Point2D.Double(centerX, centerY);
            double movX = centerX - oldCenterX;
            double movY = centerY - oldCenterY;
            double minx = oldExtent.getMinimum(0) + movX;
            double miny = oldExtent.getMinimum(1) + movY;
            double maxX = oldExtent.getMaximum(0) + movX;
            double maxY = oldExtent.getMaximum(1) + movY;
            Envelope extent = GeometryLocator.getGeometryManager().createEnvelope(minx, miny, maxX, maxY, 0);
            viewPort.setEnvelope(extent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean contains(Object value) {
        DataStoreParameters params;
        if (value == null) {
            return false;
        }
        if (value instanceof FeatureStore) {
            params = ((FeatureStore)value).getParameters();
        } else if (value instanceof DataStoreParameters) {
            params = (DataStoreParameters)value;
        } else {
            return false;
        }
        Iterator<FLayer> it = this.deepiterator();
        while (it.hasNext()) {
            FeatureStore store;
            FLayer layer = it.next();
            if (!(layer instanceof FLyrVect) || (store = ((FLyrVect)layer).getFeatureStore()) == null || !store.getParameters().isTheSameStore(params)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void refresh() {
        this.getMapContext().invalidate();
    }

    class HtmlWindow
    extends JPanel
    implements IWindow {
        private static final long serialVersionUID = 1151465547277478664L;
        private HTMLInfoToolPanel htmlPanel = new HTMLInfoToolPanel();
        WindowInfo viewInfo = null;

        public HtmlWindow(int width, int height, String windowTitle) {
            this.htmlPanel.setBackground(Color.white);
            JScrollPane scrollPane = new JScrollPane(this.htmlPanel);
            scrollPane.setPreferredSize(new Dimension(width - 30, height - 30));
            this.add(scrollPane);
            this.viewInfo = new WindowInfo(16);
            this.viewInfo.setTitle(windowTitle);
            this.viewInfo.setWidth(width);
            this.viewInfo.setHeight(height);
        }

        public void show(String htmlText) {
            this.htmlPanel.show(htmlText);
        }

        public WindowInfo getWindowInfo() {
            return this.viewInfo;
        }

        public Object getWindowProfile() {
            return WindowInfo.PROPERTIES_PROFILE;
        }
    }
}

