/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.cresques.cts.IProjection;
import org.gvsig.app.project.documents.view.toolListeners.MapOverviewChangeZoomListener;
import org.gvsig.app.project.documents.view.toolListeners.MapOverviewListener;
import org.gvsig.app.project.documents.view.toolListeners.MapOverviewPanListener;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.DraggerBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;

public class MapOverview
extends MapControl
implements ViewPortListener {
    private static final long serialVersionUID = -2849739771493279542L;
    private MapControl m_MapAssoc;
    boolean first = true;
    private MapOverviewListener movl;
    private MapOverviewPanListener movpl;
    private MapOverviewChangeZoomListener movczl;
    private Envelope extent;
    private BufferedImage image;

    public MapOverview(MapControl mapAssoc) {
        this.setName("MapOverview");
        this.m_MapAssoc = mapAssoc;
        this.movl = new MapOverviewListener(this);
        this.movpl = new MapOverviewPanListener(this);
        this.movczl = new MapOverviewChangeZoomListener(this);
        this.addBehavior("zoomtopoint", new Behavior[]{new PointBehavior((PointListener)this.movl), new RectangleBehavior((RectangleListener)this.movczl), new DraggerBehavior((PanListener)this.movczl), new DraggerBehavior((PanListener)this.movpl)});
        this.setDefaultMouseWheelEnabled(false);
        this.setTool("zoomtopoint");
        this.getGrid().setShowGrid(false);
        this.getGrid().setAdjustGrid(false);
    }

    public MapContext getAssociatedMapContext() {
        return this.m_MapAssoc.getMapContext();
    }

    public MapControl getAssociatedMapControl() {
        return this.m_MapAssoc;
    }

    public void extentChanged(ExtentEvent evExtent) {
        this.repaint();
    }

    public void refreshExtent() {
        try {
            if (this.getMapContext().getFullEnvelope() != null) {
                this.getMapContext().getViewPort().setEnvelope(this.getMapContext().getFullEnvelope());
            }
        }
        catch (ReadException e1) {
            e1.printStackTrace();
        }
    }

    public void refreshOverView(Envelope r) {
        this.extent = r;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        this.getGrid().setShowGrid(false);
        this.getGrid().setAdjustGrid(false);
        super.paintComponent(g);
        if (this.m_MapAssoc.getMapContext().getViewPort().getEnvelope() != null && this.getMapContext().getViewPort().getEnvelope() != null && this.getMapContext().getLayers().getLayersCount() > 0) {
            if (this.first) {
                this.first = false;
                this.repaint();
                return;
            }
            this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            ViewPort vp = this.getMapContext().getViewPort();
            Envelope extentView = vp.getAdjustedEnvelope();
            ViewPort vpOrig = this.m_MapAssoc.getMapContext().getViewPort();
            if (this.extent == null) {
                this.extent = vpOrig.getAdjustedEnvelope();
            }
            Graphics2D g2 = (Graphics2D)this.image.getGraphics();
            g2.setTransform(vp.getAffineTransform());
            g2.setStroke(new BasicStroke((float)vp.getDist1pixel()));
            g2.setColor(Color.red);
            Rectangle2D.Double extentToDraw = new Rectangle2D.Double(this.extent.getMinimum(0), this.extent.getMinimum(1), this.extent.getLength(0), this.extent.getLength(1));
            g2.draw(extentToDraw);
            g2.setColor(new Color(100, 100, 100, 100));
            g2.fill(extentToDraw);
            Point2D pRightUp = vp.toMapPoint(this.getWidth(), 0);
            Line2D.Double linVert = new Line2D.Double(extentToDraw.getCenterX(), extentView.getMinimum(1), extentToDraw.getCenterX(), pRightUp.getY());
            Line2D.Double linHoriz = new Line2D.Double(extentView.getMinimum(0), extentToDraw.getCenterY(), pRightUp.getX(), extentToDraw.getCenterY());
            g2.setColor(Color.darkGray);
            g2.draw(linVert);
            g2.draw(linHoriz);
            g.drawImage(this.image, 0, 0, (ImageObserver)((Object)this));
            g2.setTransform(new AffineTransform());
            this.extent = null;
        }
    }

    public void setModel(MapContext model) {
        this.setMapContext(model);
        model.setProjection(this.m_MapAssoc.getMapContext().getProjection());
        this.m_MapAssoc.getMapContext().getViewPort().addViewPortListener((ViewPortListener)this);
        this.getMapContext().getViewPort().addViewPortListener((ViewPortListener)this);
    }

    public void backColorChanged(ColorEvent e) {
    }

    public void projectionChanged(ProjectionEvent e) {
        super.setProjection(e.getNewProjection());
    }

    public void setProjection(IProjection proj) {
    }

    public void calculateSnapPoint(Point point) {
        this.adjustedPoint = point;
        this.mapAdjustedPoint = null;
    }
}

