/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.AbstractDocumentManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.actions.CopyDocumentAction;
import org.gvsig.app.project.documents.actions.CutDocumentAction;
import org.gvsig.app.project.documents.actions.PasteDocumentAction;
import org.gvsig.app.project.documents.gui.IDocumentWindow;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.app.project.documents.view.IContextMenuAction;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewsDocumentStoresRepository;
import org.gvsig.app.project.documents.view.dalactions.AddFilterToLayerAction;
import org.gvsig.app.project.documents.view.dalactions.CreateTemporalLayerAction;
import org.gvsig.app.project.documents.view.dalactions.ViewZoomAction;
import org.gvsig.app.project.documents.view.gui.DefaultViewPanel;
import org.gvsig.app.project.documents.view.gui.ViewProperties;
import org.gvsig.app.project.documents.view.toc.AbstractActionInfoAdapterToTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.TocItemBranch;
import org.gvsig.app.project.documents.view.toc.actions.OldTocContextMenuAction;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.ExtendedPropertiesHelper;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewManager
extends AbstractDocumentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewManager.class);
    private static final String PERSISTENCE_VIEW_DOCUMENT_DEFINITION_NAME = "DefaultViewDocument";
    public static String TYPENAME = "project.document.view2d";
    private DynStruct persistenceDefinition;
    private static int countSeparators = 0;

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public ImageIcon getIcon() {
        return PluginServices.getIconTheme().get("document-view-icon");
    }

    @Override
    public ImageIcon getIconSelected() {
        return PluginServices.getIconTheme().get("document-view-icon-sel");
    }

    @Override
    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"Vista");
    }

    @Override
    public String getTypeName() {
        return TYPENAME;
    }

    public Class getMainWindowClass() {
        return DefaultViewPanel.class;
    }

    @Override
    public AbstractDocument createDocument() {
        DefaultViewDocument doc = new DefaultViewDocument(this);
        if (this.notifyObservers("DocumentManager.CreateDocument", doc).isCanceled()) {
            return null;
        }
        return doc;
    }

    @Override
    public IWindow getMainWindow(Document doc, WindowLayout layout) {
        IDocumentWindow win = (IDocumentWindow)super.getMainWindow(doc, layout);
        if (win == null) {
            win = this.createDocumentWindow(doc);
            if (layout != null && win != null) {
                win.setWindowLayout(layout);
            }
            if (this.notifyObservers("DocumentManager.createMainWindow", win).isCanceled()) {
                return null;
            }
        }
        if (this.notifyObservers("DocumentManager.getMainWindow", win).isCanceled()) {
            return null;
        }
        ((AbstractDocument)doc).raiseEventCreateWindow(win);
        return win;
    }

    @Override
    public IWindow getPropertiesWindow(Document doc) {
        Object win = super.getPropertiesWindow(doc);
        if (win == null && this.notifyObservers("DocumentManager.createPropertiesWindow", (IWindow)(win = new ViewProperties((DefaultViewDocument)doc))).isCanceled()) {
            return null;
        }
        if (this.notifyObservers("DocumentManager.getPropertiesWindow", (IWindow)win).isCanceled()) {
            return null;
        }
        return win;
    }

    public void addTOCContextAction(String theAction) {
        ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
        ActionInfo action = actionManager.getAction(theAction);
        if (action == null) {
            String errmsg = "Action '" + theAction + "' not found";
            LOGGER.info(errmsg);
            throw new RuntimeException(errmsg);
        }
        this.addTOCContextAction(action);
    }

    public void addTOCContextAction(String theAction, String group, int groupOrder, int order) {
        ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
        ActionInfo action = actionManager.getAction(theAction);
        if (action == null) {
            String errmsg = "Action '" + theAction + "' not found";
            LOGGER.info(errmsg);
            throw new RuntimeException(errmsg);
        }
        this.addTOCContextAction(action.getName(), new ActionInfoAdapterToContextMenuAction(action, group, groupOrder, order));
    }

    public void addTOCContextAction(ActionInfo action) {
        this.addTOCContextAction(action.getName(), new ActionInfoAdapterToContextMenuAction(action, "default", 9000));
    }

    public void addTOCContextAction(ActionInfo action, String group, int groupOrder) {
        this.addTOCContextAction(action.getName(), new ActionInfoAdapterToContextMenuAction(action, group, groupOrder));
    }

    public void addTOCSeparator(String group, final int groupOrder, final int order) {
        final String effectiveGroup = group + "/-" + countSeparators++ + "-";
        this.addTOCContextAction(effectiveGroup, new IContextMenuAction(){

            @Override
            public boolean isVisible(Object item, Object[] selectedItems) {
                return true;
            }

            @Override
            public boolean isEnabled(Object item, Object[] selectedItems) {
                return true;
            }

            @Override
            public void execute(Object item, Object[] selectedItems) {
            }

            @Override
            public String getGroup() {
                return effectiveGroup;
            }

            @Override
            public int getGroupOrder() {
                return groupOrder;
            }

            @Override
            public int getOrder() {
                return order;
            }

            @Override
            public String getText() {
                return "-";
            }

            @Override
            public String getDescription() {
                return "";
            }
        });
    }

    public void addTOCContextAction(String id, IContextMenuAction action) {
        ViewManager.initializeRegisterTOCActions();
        ExtensionPoint exPoint = ToolsLocator.getExtensionPointManager().add("View_TocActions", "");
        if (action instanceof ExtensionBuilder) {
            exPoint.append(id, "", (ExtensionBuilder)action);
            return;
        }
        exPoint.append(id, "", (ExtensionBuilder)new ContextMenuActionAdapterToExtensionBuilder(action));
    }

    private static void initializeRegisterTOCActions() {
        ExtensionPointManager epManager = ToolsLocator.getExtensionPointManager();
        if (!epManager.has("View_TocActions")) {
            epManager.add("View_TocActions", "Context menu options of the TOC  in the view window (register instances of org.gvsig.app.gui.toc.AbstractTocContextMenuAction)");
        }
    }

    public static void register() {
        ViewManager factory = new ViewManager();
        ProjectManager.getInstance().registerDocumentFactory(factory);
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        manager.registerFactory((PersistenceFactory)factory);
        ViewManager.initializeRegisterTOCActions();
        ProjectManager.getInstance().registerDocumentAction(TYPENAME, new CopyDocumentAction());
        ProjectManager.getInstance().registerDocumentAction(TYPENAME, new CutDocumentAction());
        ProjectManager.getInstance().registerDocumentAction(TYPENAME, new PasteDocumentAction());
        IconThemeHelper.registerIcon((String)"document", (String)"document-view-icon", ViewManager.class);
        IconThemeHelper.registerIcon((String)"document", (String)"document-view-icon-sel", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-busy", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-crux", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-info-by-point", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-pan", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-query-area", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-select-by-point", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-select-by-polygon", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-select-by-rectangle", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-zoom-in", ViewManager.class);
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-zoom-out", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-group", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-vectorial", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-csv", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-dgn", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-dxf", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-postgresql", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-mysql", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-icon-jdbc", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-chk-unavailable", ViewManager.class);
        IconThemeHelper.registerIcon((String)"layer", (String)"layer-chk-temporary", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"active-layer-bring-front", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"active-layer-move-ahead", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"active-layer-move-behind", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"active-layer-send-back", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"active-layer-set-hide", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"active-layer-set-visible", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"layer-set-visible", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"layer-set-hide", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"layer-set-inactive", ViewManager.class);
        IconThemeHelper.registerIcon((String)"action", (String)"layer-set-active", ViewManager.class);
        IconThemeHelper.registerIcon((String)"legend", (String)"legend-overview-single-symbol", ViewManager.class);
        IconThemeHelper.registerIcon((String)"legend", (String)"legend-overview-vectorial-interval", ViewManager.class);
        IconThemeHelper.registerIcon((String)"legend", (String)"legend-overview-vectorial-unique-value", ViewManager.class);
        MapContextManager mapContextMgr = MapContextLocator.getMapContextManager();
        mapContextMgr.registerIconLayer("CSV", "layer-icon-csv");
        mapContextMgr.registerIconLayer("DGN", "layer-icon-dgn");
        mapContextMgr.registerIconLayer("DXF", "layer-icon-dxf");
        mapContextMgr.registerIconLayer("jdbc", "layer-icon-jdbc");
        mapContextMgr.registerIconLayer("PostgreSQL", "layer-icon-postgresql");
        mapContextMgr.registerIconLayer("MySQL", "layer-icon-mysql");
        if (factory.persistenceDefinition == null) {
            factory.persistenceDefinition = manager.addDefinition(ViewDocument.class, PERSISTENCE_VIEW_DOCUMENT_DEFINITION_NAME, "Default view document persistence definition", null, null);
            factory.persistenceDefinition.extend(manager.getDefinition("AbstractDocument"));
            factory.persistenceDefinition.addDynFieldBoolean("useMapOverview").setMandatory(true);
            factory.persistenceDefinition.addDynFieldObject("mainMapContext").setClassOfValue(MapContext.class).setMandatory(true);
            factory.persistenceDefinition.addDynFieldObject("overviewMapContext").setClassOfValue(MapContext.class).setMandatory(false);
            factory.persistenceDefinition.addDynFieldObject("propertiesHelper").setClassOfValue(ExtendedPropertiesHelper.class).setMandatory(false);
        }
        ViewsDocumentStoresRepository.selfRegister();
        ViewZoomAction.ViewZoomActionFactory.selfRegister();
        AddFilterToLayerAction.AddFilterToLayerActionFactory.selfRegister();
        CreateTemporalLayerAction.CreateTemporalLayerActionFactory.selfRegister();
    }

    public DynStruct getDefinition(String className) {
        if (this.persistenceDefinition.getName().equalsIgnoreCase(className)) {
            return this.persistenceDefinition;
        }
        if (this.persistenceDefinition.getFullName().equalsIgnoreCase(className)) {
            return this.persistenceDefinition;
        }
        if (this.getDocumentClass().getName().equals(className)) {
            return this.persistenceDefinition;
        }
        return null;
    }

    @Override
    protected Class getDocumentClass() {
        return DefaultViewDocument.class;
    }

    public boolean manages(Object object) {
        return object instanceof ViewDocument;
    }

    public List<IContextMenuAction> getTOCContextMenuActions(MapContext mapContext, FLayer[] selecteds, ITocItem nodeUserObject) {
        ArrayList<IContextMenuAction> actions = new ArrayList<IContextMenuAction>();
        ExtensionPoint exPoint = ToolsLocator.getExtensionPointManager().add("View_TocActions", "");
        Iterator iter = exPoint.iterator();
        boolean contains = false;
        ITocItem tocItem = nodeUserObject;
        if (tocItem instanceof TocItemBranch) {
            for (int i = 0; i < selecteds.length; ++i) {
                if (!selecteds[i].equals(((TocItemBranch)tocItem).getLayer())) continue;
                contains = true;
                break;
            }
        } else {
            contains = true;
        }
        if (contains) {
            while (iter.hasNext()) {
                IContextMenuAction action = null;
                try {
                    action = (IContextMenuAction)((ExtensionPoint.Extension)iter.next()).create();
                }
                catch (Exception e) {
                    NotificationManager.addError((Throwable)e);
                }
                if (action == null) continue;
                if (action instanceof AbstractTocContextMenuAction && !(action instanceof OldTocContextMenuAction)) {
                    ((AbstractTocContextMenuAction)action).setMapContext(mapContext);
                }
                if (!action.isVisible(nodeUserObject, selecteds)) continue;
                actions.add(action);
            }
            Collections.sort(actions, new CompareAction());
            return actions;
        }
        return null;
    }

    public boolean existsTOCContextMenuActions(String name) {
        ExtensionPoint exPoint = ToolsLocator.getExtensionPointManager().add("View_TocActions", "");
        for (ExtensionPoint.Extension action : exPoint) {
            if (action == null || !StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)action.getName())) continue;
            return true;
        }
        return false;
    }

    private class CompareAction
    implements Comparator<IContextMenuAction> {
        private CompareAction() {
        }

        @Override
        public int compare(IContextMenuAction o1, IContextMenuAction o2) {
            NumberFormat formater = NumberFormat.getInstance();
            formater.setMinimumIntegerDigits(6);
            String key1 = "" + formater.format(o1.getGroupOrder()) + formater.format(o1.getOrder()) + o1.getGroup();
            String key2 = "" + formater.format(o2.getGroupOrder()) + formater.format(o2.getOrder()) + o2.getGroup();
            return key1.compareTo(key2);
        }
    }

    class ContextMenuActionAdapterToExtensionBuilder
    implements ExtensionBuilder {
        IContextMenuAction menuAction = null;

        ContextMenuActionAdapterToExtensionBuilder(IContextMenuAction menuAction) {
            this.menuAction = menuAction;
        }

        public Object create() {
            return this.menuAction;
        }

        public Object create(Object[] args) {
            return this.menuAction;
        }

        public Object create(Map args) {
            return this.menuAction;
        }
    }

    class ActionInfoAdapterToContextMenuAction
    extends AbstractActionInfoAdapterToTocContextMenuAction {
        ActionInfoAdapterToContextMenuAction(ActionInfo action, String group, int groupOrder) {
            super(action, group, groupOrder);
        }

        ActionInfoAdapterToContextMenuAction(ActionInfo action, String group, int groupOrder, int order) {
            super(action, group, groupOrder, order);
        }
    }
}

