/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewDocumentStoresRepository;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.AbstractStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.util.UnmodifiableBasicSet;

class ViewsDocumentStoresRepository
extends AbstractStoresRepository {
    public ViewsDocumentStoresRepository(String name) {
        super(name);
    }

    public Collection<StoresRepository> getSubrepositories() {
        this.subrepositories = new ArrayList();
        Map<String, ViewDocumentStoresRepository> subrepos = this.getAll();
        if (subrepos != null) {
            for (ViewDocumentStoresRepository repo : subrepos.values()) {
                this.subrepositories.add(repo);
            }
        }
        return this.subrepositories;
    }

    private List<ViewDocument> getOrderedViews() {
        Project project = ProjectManager.getInstance().getCurrentProject();
        if (project == null) {
            return null;
        }
        List<Document> allViews = project.getDocuments(ViewManager.TYPENAME);
        List<Document> openViews = project.getOpenDocuments(ViewManager.TYPENAME);
        ArrayList<ViewDocument> views = new ArrayList<ViewDocument>();
        for (Document view : openViews) {
            views.add((ViewDocument)view);
        }
        for (Document view : allViews) {
            if (openViews.contains(view)) continue;
            views.add((ViewDocument)view);
        }
        return views;
    }

    private Map<String, ViewDocumentStoresRepository> getAll() {
        HashMap<String, ViewDocumentStoresRepository> all = new HashMap<String, ViewDocumentStoresRepository>();
        List<ViewDocument> views = this.getOrderedViews();
        if (views == null) {
            return null;
        }
        for (ViewDocument view : views) {
            String theName = view.getName();
            if (all.containsKey(theName)) {
                theName = theName + "$" + view.getName();
                int counter = 1;
                while (all.containsKey(theName + counter)) {
                    ++counter;
                }
                theName = theName + counter;
            }
            all.put(theName, new ViewDocumentStoresRepository(theName, view));
        }
        if (all.isEmpty()) {
            return null;
        }
        return all;
    }

    protected DataStoreParameters getMyParameters(String name) {
        return null;
    }

    protected FeatureType getMyFeatureType(String name) {
        return null;
    }

    protected UnmodifiableBasicSet<String> getMyKeySet() {
        return null;
    }

    protected boolean isEmptyMyRepository() {
        return true;
    }

    protected int getMySize() {
        return 0;
    }

    public static void selfRegister() {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.getStoresRepository().addRepository((StoresRepository)new ViewsDocumentStoresRepository("Project Views"));
    }
}

