/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.dalactions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddFilterToLayerAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddFilterToLayerAction.class);
    private final DALActionFactory.DALActionContext context;

    public AddFilterToLayerAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "AddFilterToLayerAction");
        this.putValue("ShortDescription", i18n.getTranslation("_Add_filter_to_layer"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("filter-by-attributes-layer"));
    }

    private FLyrVect getFLyrVect(FeatureStore store) {
        ApplicationManager aplication = ApplicationLocator.getApplicationManager();
        FLayer layer = aplication.getCurrentLayer();
        if (layer instanceof FLyrVect && ((FLyrVect)layer).getFeatureStore() == store) {
            return (FLyrVect)layer;
        }
        ViewDocument viewDoc = (ViewDocument)aplication.getActiveDocument(ViewDocument.class);
        if (viewDoc == null) {
            return null;
        }
        for (FLayer layer1 : viewDoc.getMapContext().getLayers().getLayers(null)) {
            if (!(layer1 instanceof FLyrVect) || ((FLyrVect)layer1).getFeatureStore() != store) continue;
            return (FLyrVect)layer1;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            FLyrVect layer = this.getFLyrVect(featureStore);
            FeatureQuery query = this.context.getQuery();
            FeatureQuery layerQuery = null;
            if (query != null) {
                Expression expFilter = query.getExpressionFilter();
                if (expFilter != null && !expFilter.isEmpty()) {
                    if (layerQuery == null) {
                        layerQuery = featureStore.createFeatureQuery();
                    }
                    layerQuery.addFilter(expFilter);
                    layerQuery.retrievesAllAttributes();
                }
                if (query.hasOrder()) {
                    if (layerQuery == null) {
                        layerQuery = featureStore.createFeatureQuery();
                    }
                    layerQuery.getOrder().copyFrom(query.getOrder());
                }
                if (layerQuery == null) {
                    layer.setBaseQuery(null);
                } else {
                    layer.setBaseQuery(layerQuery);
                }
                layer.getMapContext().invalidate();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build selecction.", (Throwable)ex);
        }
    }

    public static class AddFilterToLayerActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "AddFilterToLayerAction";

        public AddFilterToLayerActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new AddFilterToLayerAction(context);
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new AddFilterToLayerActionFactory());
        }
    }
}

