/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.gui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ProjectionContainerManager;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowTransform;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.app.project.documents.view.MapOverview;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.gui.MapOverViewPalette;
import org.gvsig.app.project.documents.view.gui.ViewInformationArea;
import org.gvsig.app.project.documents.view.toc.gui.TOC;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.utils.exceptionHandling.ExceptionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractViewPanel
extends JPanel
implements IView,
IWindowTransform,
PropertyChangeListener,
Component {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractViewPanel.class);
    private static final long serialVersionUID = -259620280790490262L;
    private static final int DEFAULT_HEIGHT = 450;
    private static final int DEFAULT_WIDTH = 700;
    protected MapControl m_MapControl;
    protected MapOverview m_MapLoc;
    protected WindowInfo m_viewInfo = null;
    protected WindowLayout windowLayout = null;
    protected TOC m_TOC;
    protected ViewDocument modelo;
    protected ViewExceptionListener mapControlExceptionListener = new ViewExceptionListener();
    protected boolean isPalette = false;
    protected MapOverViewPalette movp;
    protected ViewSplitPane tempMainSplit = null;
    protected JSplitPane tempSplitToc = null;
    protected ViewInformationArea viewInformationArea;
    private ViewProjectionContainer viewProjectionContainer = new ViewProjectionContainer();

    public void windowActivated() {
        this.viewProjectionContainer.set();
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ViewInformationArea getViewInformationArea() {
        return this.viewInformationArea;
    }

    public void toPalette() {
    }

    public void restore() {
    }

    public AbstractViewPanel() {
        ProjectManager.getInstance().getCurrentProject().addPropertyChangeListener(this);
    }

    protected void initialize() {
    }

    public WindowInfo getWindowInfo() {
        if (this.m_viewInfo == null) {
            this.m_viewInfo = new WindowInfo(7);
            this.m_viewInfo.setWidth(700);
            this.m_viewInfo.setHeight(450);
            this.m_viewInfo.setTitle(PluginServices.getText((Object)this, (String)"Vista") + ": " + this.modelo.getName());
        }
        return this.m_viewInfo;
    }

    public void windowClosed() {
        this.viewProjectionContainer.unset();
        if (this.movp != null) {
            PluginServices.getMDIManager().closeWindow((IWindow)this.movp);
        }
        if (this.modelo != null) {
            this.modelo.setWindowLayout(this.getWindowLayout());
        }
    }

    public ViewDocument getModel() {
        return this.modelo;
    }

    @Override
    public ViewDocument getViewDocument() {
        return this.modelo;
    }

    @Override
    public MapOverview getMapOverview() {
        return this.m_MapLoc;
    }

    @Override
    public MapControl getMapControl() {
        return this.m_MapControl;
    }

    @Override
    public TOC getTOC() {
        return this.m_TOC;
    }

    public Object getWindowModel() {
        return this.modelo;
    }

    public boolean isPalette() {
        return this.isPalette;
    }

    public void repaintMap() {
        this.m_MapControl.drawMap(false);
    }

    public BufferedImage getImage() {
        return this.m_MapControl.getImage();
    }

    public void setProjection(IProjection proj) {
        this.getMapControl().setProjection(proj);
    }

    public IProjection getProjection() {
        return this.getMapControl().getProjection();
    }

    @Override
    public WindowLayout getWindowLayout() {
        if (this.windowLayout == null) {
            this.windowLayout = new WindowLayout();
            this.windowLayout.set("MainDivider.Location", "300");
            this.windowLayout.set("TOCDivider.Location", "500");
        } else {
            this.windowLayout.set("MainDivider.Location", Integer.toString(this.tempMainSplit.getDividerLocation()));
            if (this.tempSplitToc != null) {
                this.windowLayout.set("TOCDivider.Location", Integer.toString(this.tempSplitToc.getDividerLocation()));
            }
        }
        this.windowLayout.set("MainWindow.X", Integer.toString(this.getX()));
        this.windowLayout.set("MainWindow.Y", Integer.toString(this.getY()));
        this.windowLayout.set("MainWindow.Width", Integer.toString(this.getWidth()));
        this.windowLayout.set("MainWindow.Height", Integer.toString(this.getHeight()));
        this.windowLayout.set("MainDivider.X", Integer.toString(this.tempMainSplit.getX()));
        this.windowLayout.set("MainDivider.Y", Integer.toString(this.tempMainSplit.getY()));
        this.windowLayout.set("MainDivider.Width", Integer.toString(this.tempMainSplit.getWidth()));
        this.windowLayout.set("MainDivider.Height", Integer.toString(this.tempMainSplit.getHeight()));
        if (this.isPalette()) {
            this.windowLayout.set("GraphicLocator.isPalette", "true");
        } else {
            this.windowLayout.set("GraphicLocator.isPalette", "false");
            if (this.tempSplitToc != null) {
                this.windowLayout.set("TOCDivider.X", Integer.toString(this.tempSplitToc.getX()));
                this.windowLayout.set("TOCDivider.Y", Integer.toString(this.tempSplitToc.getY()));
                this.windowLayout.set("TOCDivider.Width", Integer.toString(this.tempSplitToc.getWidth()));
                this.windowLayout.set("TOCDivider.Height", Integer.toString(this.tempSplitToc.getHeight()));
            }
        }
        if (this.m_TOC != null) {
            this.windowLayout.set("TOC.Width", Integer.toString(this.m_TOC.getWidth()));
            this.windowLayout.set("TOC.Height", Integer.toString(this.m_TOC.getHeight()));
        }
        if (this.m_MapControl != null) {
            this.windowLayout.set("MapControl.Width", Integer.toString(this.m_MapControl.getWidth()));
            this.windowLayout.set("MapControl.Height", Integer.toString(this.m_MapControl.getHeight()));
        }
        if (this.m_MapLoc != null) {
            this.windowLayout.set("GraphicLocator.Width", Integer.toString(this.m_MapLoc.getWidth()));
            this.windowLayout.set("GraphicLocator.Height", Integer.toString(this.m_MapLoc.getHeight()));
        }
        return this.windowLayout;
    }

    @Override
    public void setWindowLayout(WindowLayout data) {
        this.windowLayout = data;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("delDocument".equals(evt.getPropertyName()) && evt.getOldValue() != null && evt.getOldValue() instanceof ViewDocument) {
            ViewDocument viewDocument = (ViewDocument)evt.getOldValue();
            ViewDocument myViewDocument = this.getViewDocument();
            if (myViewDocument != null && myViewDocument.equals(viewDocument)) {
                this.m_MapControl.dispose();
                this.m_MapLoc.dispose();
            }
        }
    }

    public class ViewExceptionListener
    implements ExceptionListener {
        public void exceptionThrown(Throwable t) {
            NotificationManager.addError((String)this.getMessages(t), (Throwable)t);
        }

        private String getMessages(Throwable ex) {
            StringBuilder msg = new StringBuilder();
            boolean firstline = true;
            ExceptionIterator exceptions = new ExceptionIterator(ex);
            String lastmsg = "";
            while (exceptions.hasNext()) {
                Throwable ex1 = (Throwable)exceptions.next();
                String message = ex1.getMessage();
                if (StringUtils.isEmpty((CharSequence)message)) continue;
                if (firstline) {
                    msg.append(message);
                    msg.append("\n\n");
                    firstline = false;
                } else if (!message.equalsIgnoreCase(lastmsg)) {
                    msg.append("- ");
                    msg.append(message.replace("\n", "\n  "));
                    msg.append("\n");
                }
                lastmsg = message;
            }
            return msg.toString();
        }

        private class ExceptionIterator
        implements Iterator {
            Throwable exception;

            ExceptionIterator(Throwable exception) {
                this.exception = exception;
            }

            @Override
            public boolean hasNext() {
                return this.exception != null;
            }

            public Object next() {
                Throwable exception = this.exception;
                this.exception = exception.getCause();
                return exception;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected class ViewSplitPane
    extends JSplitPane {
        private static final long serialVersionUID = -7506953938664812652L;
        private int lastDivider;

        public ViewSplitPane(int horizontal_split) {
            super(horizontal_split);
            this.lastDivider = 0;
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (this.lastDivider != this.lastDividerLocation) {
                logger.debug("paintChildren = " + this.lastDividerLocation);
                this.lastDivider = this.lastDividerLocation;
            }
            super.paintChildren(g);
        }
    }

    private class ViewProjectionContainer
    implements ProjectionContainerManager.ProjectionContainer {
        private ViewProjectionContainer() {
        }

        public Object getCurrentProjection() {
            return AbstractViewPanel.this.getProjection();
        }

        public void set() {
            ProjectionContainerManager.set((ProjectionContainerManager.ProjectionContainer)this);
        }

        public void unset() {
            ProjectionContainerManager.unset((ProjectionContainerManager.ProjectionContainer)this);
        }
    }
}

