/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.extension.AddLayer;
import org.gvsig.app.project.documents.view.MapOverview;
import org.gvsig.app.project.documents.view.gui.LayerListItem;
import org.gvsig.app.project.documents.view.gui.LayerProperties;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.operations.Classifiable;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FPanelLocConfig
extends JPanel
implements ActionListener,
IWindow {
    private static Logger logger = LoggerFactory.getLogger(FPanelLocConfig.class);
    private static final long serialVersionUID = -3331364698732098356L;
    private JLabel jLabel = null;
    private JList jList = null;
    private JButton jBtnAddLayer = null;
    private JButton jBtnRemoveLayer = null;
    private JButton jBtnEditLegend = null;
    private JButton jBtnCancel = null;
    private MapControl mapCtrl;
    private WindowInfo m_viewinfo = null;
    private JPanel pnlButtons = null;
    private BasicArrowButton jBtnUp;
    private BasicArrowButton jBtnDown;

    public FPanelLocConfig(MapControl mc) {
        this.mapCtrl = mc;
        this.initialize();
        this.refreshList();
        this.updateControls(null);
    }

    private void refreshList() {
        DefaultListModel listModel = (DefaultListModel)this.getJList().getModel();
        listModel.removeAllElements();
        int index = 0;
        for (int i = this.mapCtrl.getMapContext().getLayers().getLayersCount() - 1; i >= 0; --i) {
            FLayer lyr = this.mapCtrl.getMapContext().getLayers().getLayer(i);
            listModel.add(index++, new LayerListItem(lyr));
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJLabel(), "North");
        this.add((Component)this.getJList(), "Center");
        JPanel eastp = new JPanel(new BorderLayout());
        eastp.add((Component)this.getJBtnUp(), "North");
        eastp.add((Component)this.getJBtnDown(), "South");
        this.add((Component)eastp, "East");
        this.add((Component)this.getJPanel(), "South");
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBorder(BorderFactory.createEmptyBorder(8, 4, 8, 8));
            this.jLabel.setText(PluginServices.getText((Object)this, (String)"Capas_del_localizador") + ":");
        }
        return this.jLabel;
    }

    public JList getJList() {
        if (this.jList == null) {
            this.jList = new JList(new DefaultListModel());
            this.jList.setSelectionMode(0);
            this.jList.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    FPanelLocConfig.this.updateControls(e);
                }
            });
        }
        return this.jList;
    }

    private void updateControls(ListSelectionEvent e) {
        DefaultListModel lstModel = (DefaultListModel)this.getJList().getModel();
        int selIndex = this.jList.getSelectedIndex();
        this.jBtnDown.setEnabled(false);
        this.jBtnUp.setEnabled(false);
        if (selIndex != -1 && lstModel.getSize() > 1) {
            if (selIndex < lstModel.getSize() - 1) {
                this.jBtnDown.setEnabled(true);
            }
            if (selIndex > 0) {
                this.jBtnUp.setEnabled(true);
            }
        }
        this.jBtnRemoveLayer.setEnabled(selIndex != -1);
        this.jBtnEditLegend.setEnabled(selIndex != -1);
    }

    private BasicArrowButton getJBtnUp() {
        if (this.jBtnUp == null) {
            this.jBtnUp = new BasicArrowButton(1);
            this.jBtnUp.setToolTipText(PluginServices.getText((Object)this, (String)"Subir_capa"));
            this.jBtnUp.addActionListener(this);
            this.jBtnUp.setActionCommand("UP");
        }
        return this.jBtnUp;
    }

    private BasicArrowButton getJBtnDown() {
        if (this.jBtnDown == null) {
            this.jBtnDown = new BasicArrowButton(5);
            this.jBtnDown.setToolTipText(PluginServices.getText((Object)this, (String)"Bajar_capa"));
            this.jBtnDown.setActionCommand("DOWN");
            this.jBtnDown.addActionListener(this);
        }
        return this.jBtnDown;
    }

    private JButton getJBtnAddLayer() {
        if (this.jBtnAddLayer == null) {
            this.jBtnAddLayer = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnAddLayer.setText(PluginServices.getText((Object)this, (String)"Anadir_capa") + "...");
            this.jBtnAddLayer.addActionListener(this);
            this.jBtnAddLayer.setActionCommand("ADD_LAYER");
        }
        return this.jBtnAddLayer;
    }

    private JButton getJBtnRemoveLayer() {
        if (this.jBtnRemoveLayer == null) {
            this.jBtnRemoveLayer = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnRemoveLayer.setText(PluginServices.getText((Object)this, (String)"Quitar_capa"));
            this.jBtnRemoveLayer.addActionListener(this);
            this.jBtnRemoveLayer.setActionCommand("REMOVE_LAYER");
        }
        return this.jBtnRemoveLayer;
    }

    private JButton getJBtnEditLegend() {
        if (this.jBtnEditLegend == null) {
            this.jBtnEditLegend = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnEditLegend.setText(PluginServices.getText((Object)this, (String)"Editar_leyenda") + "...");
            this.jBtnEditLegend.addActionListener(this);
            this.jBtnEditLegend.setActionCommand("EDIT_LEGEND");
        }
        return this.jBtnEditLegend;
    }

    private JButton getJBtnCancel() {
        if (this.jBtnCancel == null) {
            this.jBtnCancel = ToolsSwingLocator.getUsabilitySwingManager().createJButton();
            this.jBtnCancel.setText(PluginServices.getText((Object)this, (String)"Cerrar"));
            this.jBtnCancel.setActionCommand("CANCEL");
            this.jBtnCancel.addActionListener(this);
        }
        return this.jBtnCancel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LayerListItem lli;
        int idSelec;
        DefaultListModel lstModel = (DefaultListModel)this.getJList().getModel();
        FLayers theLayers = this.mapCtrl.getMapContext().getLayers();
        int numLayers = theLayers.getLayersCount() - 1;
        if (e.getActionCommand() == "CANCEL") {
            if (PluginServices.getMainFrame() != null) {
                PluginServices.getMDIManager().closeWindow((IWindow)this);
            } else {
                ((JDialog)this.getParent().getParent().getParent().getParent()).dispose();
            }
        }
        if (e.getActionCommand() == "ADD_LAYER") {
            AddLayer addLayer = (AddLayer)PluginServices.getExtension(AddLayer.class);
            addLayer.addLayers(this.mapCtrl, true);
            try {
                this.refreshList();
                this.updateControls(null);
            }
            catch (Exception exc) {
                logger.info("Error while refreshing components.", (Throwable)exc);
            }
            if (this.mapCtrl instanceof MapOverview) {
                ((MapOverview)this.mapCtrl).refreshExtent();
            }
        }
        if (e.getActionCommand() == "REMOVE_LAYER" && this.jList.getSelectedIndex() != -1) {
            LayerListItem lli2 = (LayerListItem)lstModel.get(this.jList.getSelectedIndex());
            theLayers.removeLayer(lli2.getLayer());
            lstModel.remove(this.jList.getSelectedIndex());
            this.updateControls(null);
            if (this.mapCtrl instanceof MapOverview) {
                ((MapOverview)this.mapCtrl).refreshExtent();
            }
        }
        if (e.getActionCommand() == "EDIT_LEGEND" && (idSelec = this.jList.getSelectedIndex()) != -1) {
            LayerListItem lli3 = (LayerListItem)lstModel.get(idSelec);
            FLayer lyr = lli3.getLayer();
            if (lyr instanceof Classifiable) {
                LayerProperties dlg = new LayerProperties(lyr);
                WindowManager wm = ToolsSwingLocator.getWindowManager();
                wm.showWindow(dlg.asJComponent(), ToolsLocator.getI18nManager().getTranslation("propiedades_de_la_capa"), WindowManager.MODE.DIALOG);
            } else {
                JOptionPane.showMessageDialog(null, PluginServices.getText((Object)this, (String)"Solo_para_capas_vectoriales") + ".");
            }
        }
        if (e.getActionCommand() == "UP") {
            int fromIndex = idSelec = this.jList.getSelectedIndex();
            int toIndex = idSelec - 1;
            lli = (LayerListItem)lstModel.get(fromIndex);
            try {
                theLayers.moveTo(numLayers - fromIndex, numLayers - toIndex);
            }
            catch (CancelationException e1) {
                e1.printStackTrace();
            }
            lstModel.remove(fromIndex);
            lstModel.add(toIndex, lli);
            this.jList.setSelectedIndex(toIndex);
        }
        if (e.getActionCommand() == "DOWN") {
            int fromIndex = idSelec = this.jList.getSelectedIndex();
            int toIndex = idSelec + 1;
            lli = (LayerListItem)lstModel.get(fromIndex);
            try {
                theLayers.moveTo(numLayers - fromIndex, numLayers - toIndex);
            }
            catch (CancelationException e1) {
                e1.printStackTrace();
            }
            lstModel.remove(fromIndex);
            lstModel.add(toIndex, lli);
            this.jList.setSelectedIndex(toIndex);
        }
    }

    public WindowInfo getWindowInfo() {
        if (this.m_viewinfo == null) {
            this.m_viewinfo = new WindowInfo(16);
            this.m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"Configurar_localizador"));
            this.m_viewinfo.setWidth(400);
            this.m_viewinfo.setHeight(200);
        }
        return this.m_viewinfo;
    }

    public void viewActivated() {
    }

    private JPanel getJPanel() {
        if (this.pnlButtons == null) {
            this.pnlButtons = new JPanel(new GridLayout(2, 3, 8, 4));
            this.pnlButtons.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.pnlButtons.add(this.getJBtnAddLayer());
            this.pnlButtons.add(new JLabel());
            this.pnlButtons.add(new JLabel());
            this.pnlButtons.add(this.getJBtnRemoveLayer());
            this.pnlButtons.add(this.getJBtnEditLegend());
            this.pnlButtons.add(this.getJBtnCancel());
        }
        return this.pnlButtons;
    }

    public MapControl getMapCtrl() {
        return this.mapCtrl;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    class RefreshThread
    extends Thread {
        private int waitt = 0;

        public RefreshThread(int t) {
            this.waitt = t;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.waitt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FPanelLocConfig.this.refreshList();
                        FPanelLocConfig.this.updateControls(null);
                    }
                    catch (Exception exc) {
                        logger.info("Error while refreshing components.", (Throwable)exc);
                    }
                }
            });
        }
    }
}

