/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.info.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.gvsig.app.gui.wizards.FormatListModel;
import org.gvsig.app.project.documents.view.info.gui.FInfoDialogXML;
import org.gvsig.app.project.documents.view.info.gui.HTMLInfoToolPanel;
import org.gvsig.app.project.documents.view.info.gui.IInfoToolPanel;
import org.gvsig.app.project.documents.view.info.gui.IXULInfoToolSupport;
import org.gvsig.app.project.documents.view.info.gui.XMLItem;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.fmap.mapcontext.layers.operations.InfoByPoint;
import org.gvsig.utils.xmlViewer.XMLContent;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class InfoToolViewer
extends JPanel {
    public static Class XULPanelClass = null;
    private JScrollPane jScrollPane = null;
    private JList layerList = null;
    private JSplitPane jSplitPane1 = null;
    private JPanel layerListPanel = null;
    private JPanel infoViewerPanel;
    private XMLItem[] m_layers;
    IInfoToolPanel infoPanel = null;

    public InfoToolViewer() {
        this.initialize();
        this.addComponentListener(new componentListener());
    }

    public InfoToolViewer(XMLItem[] layers) {
        this.initialize();
        this.setLayers(layers);
    }

    public void setLayers(XMLItem[] layers) {
        this.m_layers = layers;
        this.initilizeLayerListModel();
        this.updateViewer(0);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJSplitPane1(), "Center");
        this.setSize(600, 600);
        this.setPreferredSize(new Dimension(600, 600));
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setSize(new Dimension(600, 600));
            this.jScrollPane.setPreferredSize(new Dimension(600, 600));
            this.jScrollPane.setViewportView(this.getLayerListPanel());
        }
        return this.jScrollPane;
    }

    private void initilizeLayerListModel() {
        Vector<String> layerNames = new Vector<String>();
        if (this.m_layers != null) {
            for (int i = 0; i < this.m_layers.length; ++i) {
                layerNames.add(this.m_layers[i].getLayer().getName());
            }
        }
        FormatListModel model = new FormatListModel(layerNames.toArray(new String[0]));
        this.getJList().setModel(model);
    }

    public JList getJList() {
        if (this.layerList == null) {
            this.layerList = new JList();
            this.initilizeLayerListModel();
            this.layerList.setSelectionMode(0);
        }
        this.layerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int changedIdx = InfoToolViewer.this.layerList.getSelectedIndex();
                if (changedIdx == -1) {
                    return;
                }
                InfoToolViewer.this.updateViewer(changedIdx);
            }
        });
        return this.layerList;
    }

    private JSplitPane getJSplitPane1() {
        if (this.jSplitPane1 == null) {
            this.jSplitPane1 = new JSplitPane();
            this.jSplitPane1.setLeftComponent(this.getJScrollPane());
            this.jSplitPane1.setRightComponent(this.getInfoViewerPanel());
            this.jSplitPane1.setDividerSize(4);
            this.jSplitPane1.setDividerLocation(100);
            this.jSplitPane1.setSize(new Dimension(600, 600));
            this.jSplitPane1.setPreferredSize(new Dimension(600, 600));
        }
        return this.jSplitPane1;
    }

    private JPanel getLayerListPanel() {
        if (this.layerListPanel == null) {
            this.layerListPanel = new JPanel();
            this.layerListPanel.setLayout(new BorderLayout());
            this.layerListPanel.add((Component)this.getJList(), "Center");
        }
        return this.layerListPanel;
    }

    private JPanel getInfoViewerPanel() {
        if (this.infoViewerPanel == null) {
            this.infoViewerPanel = new JPanel();
            this.infoViewerPanel.setLayout(new BorderLayout());
        }
        this.validate();
        return this.infoViewerPanel;
    }

    private void updateViewer(int changedIdx) {
        if (this.m_layers == null || this.m_layers.length == 0) {
            return;
        }
        final XMLItem item = this.m_layers[changedIdx];
        FLayer layer = item.getLayer();
        if (layer instanceof InfoByPoint) {
            FLyrDefault defaultLayer = (FLyrDefault)layer;
            if (XULPanelClass != null && defaultLayer.getProperty((Object)"infoTool.XULFile") != null) {
                try {
                    IXULInfoToolSupport infoPanel = (IXULInfoToolSupport)XULPanelClass.newInstance();
                    infoPanel.setXULFile((String)defaultLayer.getProperty((Object)"infoTool.XULFile"));
                    this.infoViewerPanel.removeAll();
                    this.infoViewerPanel.add((JPanel)((Object)infoPanel));
                    infoPanel.show(item);
                    this.infoViewerPanel.setVisible(true);
                    this.revalidate();
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (defaultLayer.getProperty((Object)"customPanel") != null) {
                Object o = defaultLayer.getProperty((Object)"customPanel");
                if (o instanceof IInfoToolPanel) {
                    this.infoPanel = (IInfoToolPanel)o;
                } else {
                    try {
                        Class c = (Class)o;
                        this.infoPanel = (IInfoToolPanel)c.newInstance();
                    }
                    catch (InstantiationException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                }
                this.infoViewerPanel.removeAll();
                this.infoViewerPanel.add((JPanel)((Object)this.infoPanel));
                this.infoPanel.show(item);
                this.infoViewerPanel.setVisible(true);
                this.revalidate();
            } else if (item.toString().toLowerCase().endsWith("</html>")) {
                HTMLInfoToolPanel htmlPanel = new HTMLInfoToolPanel();
                int idx = item.toString().toLowerCase().indexOf("<html");
                if (idx != -1) {
                    htmlPanel.show(item.toString().substring(idx));
                } else {
                    htmlPanel.show(item.toString());
                }
                this.infoViewerPanel.removeAll();
                this.infoViewerPanel.add(htmlPanel);
                this.infoViewerPanel.setVisible(true);
                this.revalidate();
            } else {
                FInfoDialogXML dlgXML = new FInfoDialogXML();
                try {
                    dlgXML.setModel(new XMLContent(){
                        private ContentHandler handler;

                        public void setContentHandler(ContentHandler arg0) {
                            this.handler = arg0;
                        }

                        public void parse() throws SAXException {
                            this.handler.startDocument();
                            item.parse(this.handler);
                            this.handler.endDocument();
                        }
                    });
                    dlgXML.getXmlTree().setRootVisible(false);
                    DefaultTreeModel treeModel = (DefaultTreeModel)dlgXML.getXmlTree().getModel();
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)dlgXML.getXmlTree().getModel().getRoot();
                    DefaultMutableTreeNode n = root.getFirstLeaf();
                    TreePath path = new TreePath(treeModel.getPathToRoot(n));
                    dlgXML.getXmlTree().expandPath(path);
                    dlgXML.getXmlTree().setSelectionPath(path);
                    this.infoViewerPanel.removeAll();
                    this.infoViewerPanel.add((Component)((Object)dlgXML));
                    this.infoViewerPanel.setVisible(true);
                    this.validate();
                    this.doLayout();
                }
                catch (SAXException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    class componentListener
    implements ComponentListener {
        componentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (InfoToolViewer.this.infoPanel != null) {
                InfoToolViewer.this.infoPanel.refreshSize();
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

