/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.gui.JComboBoxUnits;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.JComboBoxUnitsReferenceSystem;
import org.gvsig.app.project.documents.view.legend.gui.ILabelingStrategyPanel;
import org.gvsig.app.project.documents.view.legend.gui.LabelingManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingStrategy;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.JComboBoxFonts;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.AttrInTableLabelingStrategy;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.IAttrInTableLabelingStrategy;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.utils.swing.JComboBox;

public class AttrInTableLabeling
extends JPanel
implements ILabelingStrategyPanel {
    private static final long serialVersionUID = 8229927418031917075L;
    private static final String NO_FIELD_ITEM = "-- " + PluginServices.getText(LabelingManager.class, (String)"none") + " --";
    private String[] fieldNames;
    private String[] numericFieldNames;
    private String[] integerFieldNames;
    private JRadioButton rdBtnFixedHeight;
    private JRadioButton rdBtnHeightField;
    private JRadioButton rdBtnFixedColor;
    private JRadioButton rdBtnColorField;
    private JComboBox cmbTextField;
    private JComboBox cmbHeightField;
    private JComboBox cmbRotationField;
    private JComboBoxUnits cmbUnits;
    private JComboBoxUnitsReferenceSystem cmbReferenceSystem;
    private JFormattedTextField txtHeightField;
    private FLyrVect layer;
    private JCheckBox chkItalic;
    private ColorChooserPanel colorChooser;
    private JComboBox cmbColorField;
    private Font labelFont;
    private JCheckBox chkBold;
    private JComboBoxFonts cmbFontType;
    private I18nManager i18nManager = ToolsLocator.getI18nManager();
    private JPanel pnlAttributes;

    public AttrInTableLabeling() {
        this.labelFont = MapContextLocator.getSymbolManager().getSymbolPreferences().getDefaultSymbolFont();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new FlowLayout(0, 10, 10));
        GridBagLayoutPanel panel = new GridBagLayoutPanel();
        Insets ins = new Insets(3, 0, 3, 0);
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        aux.addComponent(PluginServices.getText((Object)this, (String)"_Field_to_use_in_label") + ":", (Component)this.getCmbTextField(), 1, ins);
        aux.addComponent(this.i18nManager.getTranslation("font_type_XcolonX"), (Component)this.getCmbFontType(), 1, ins);
        aux.addComponent((Component)this.getRdBtnHeightField(), (Component)this.getCmbHeightField(), 1, ins);
        aux.addComponent((Component)this.getRdBtnFixedHeight(), (Component)this.getTxtHeightField(), 1, ins);
        aux.addComponent(this.i18nManager.getTranslation("attributes_XcolonX"), (Component)this.getPanelAttributes(), 1, ins);
        aux.addComponent(PluginServices.getText((Object)this, (String)"rotation_height") + ":", (Component)this.getCmbRotationField(), 1, ins);
        aux.addComponent(PluginServices.getText((Object)this, (String)"units") + ":", (Component)this.getCmbUnits(), 1, ins);
        aux.addComponent(PluginServices.getText((Object)this, (String)"reference_system"), (Component)this.getCmbReferenceSystem(), 1, ins);
        panel.add((Component)aux);
        aux = new GridBagLayoutPanel();
        GridBagLayoutPanel colorPanel = new GridBagLayoutPanel();
        ins = new Insets(0, 3, 3, 3);
        Insets ins2 = new Insets(3, 3, 0, 3);
        colorPanel.setBorder((Border)BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"Color")));
        this.colorChooser = new ColorChooserPanel(true);
        colorPanel.addComponent((Component)this.getRdBtnFixedColor(), (Component)this.colorChooser, 2, ins2);
        colorPanel.addComponent((Component)this.getRdBtnColorField(), (Component)this.getCmbColorField(), 1, ins);
        aux.addComponent((Component)colorPanel);
        panel.add((Component)new JBlank(20, 0));
        panel.add((Component)aux);
        this.add((Component)panel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRdBtnFixedHeight());
        group.add(this.getRdBtnHeightField());
        ButtonGroup colorGroup = new ButtonGroup();
        colorGroup.add(this.getRdBtnFixedColor());
        colorGroup.add(this.getRdBtnColorField());
    }

    private JPanel getPanelAttributes() {
        if (this.pnlAttributes == null) {
            this.pnlAttributes = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.anchor = 17;
            c.insets = new Insets(3, 3, 3, 3);
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            this.pnlAttributes.add((Component)this.getChkBoxBold(), c);
            c.gridx = 1;
            this.pnlAttributes.add((Component)this.getChkItalic(), c);
        }
        return this.pnlAttributes;
    }

    private JCheckBox getChkItalic() {
        if (this.chkItalic == null) {
            this.chkItalic = new JCheckBox(this.i18nManager.getTranslation("Italic"));
            this.chkItalic.setSelected(false);
        }
        return this.chkItalic;
    }

    private JCheckBox getChkBoxBold() {
        if (this.chkBold == null) {
            this.chkBold = new JCheckBox(this.i18nManager.getTranslation("Bold"));
            this.chkBold.setSelected(false);
        }
        return this.chkBold;
    }

    private JComboBoxFonts getCmbFontType() {
        if (this.cmbFontType == null) {
            this.cmbFontType = new JComboBoxFonts();
        }
        return this.cmbFontType;
    }

    private JRadioButton getRdBtnFixedHeight() {
        if (this.rdBtnFixedHeight == null) {
            this.rdBtnFixedHeight = new JRadioButton(PluginServices.getText((Object)this, (String)"fixed_height") + ":");
            this.rdBtnFixedHeight.setSelected(true);
            this.rdBtnFixedHeight.setName("RDFIXEDHEIGHT");
        }
        return this.rdBtnFixedHeight;
    }

    private JRadioButton getRdBtnHeightField() {
        if (this.rdBtnHeightField == null) {
            this.rdBtnHeightField = new JRadioButton(PluginServices.getText((Object)this, (String)"text_height_field") + ":");
            this.rdBtnHeightField.setSelected(false);
            this.rdBtnHeightField.setName("RDHEIGHTFIELD");
        }
        return this.rdBtnHeightField;
    }

    private JRadioButton getRdBtnFixedColor() {
        if (this.rdBtnFixedColor == null) {
            this.rdBtnFixedColor = new JRadioButton(PluginServices.getText((Object)this, (String)"_Fixed_color") + ":");
            this.rdBtnFixedColor.setSelected(true);
            this.rdBtnFixedColor.setName("RDFIXEDCOLOR");
        }
        return this.rdBtnFixedColor;
    }

    private JRadioButton getRdBtnColorField() {
        if (this.rdBtnColorField == null) {
            this.rdBtnColorField = new JRadioButton(PluginServices.getText((Object)this, (String)"color_field") + ":");
            this.rdBtnColorField.setSelected(false);
            this.rdBtnColorField.setName("RDCOLORFIELD");
        }
        return this.rdBtnColorField;
    }

    private JComboBoxUnits getCmbUnits() {
        if (this.cmbUnits == null) {
            this.cmbUnits = new JComboBoxUnits(true);
            this.cmbUnits.setName("CMBUNITS");
        }
        return this.cmbUnits;
    }

    private JComboBoxUnitsReferenceSystem getCmbReferenceSystem() {
        if (this.cmbReferenceSystem == null) {
            this.cmbReferenceSystem = new JComboBoxUnitsReferenceSystem();
            this.cmbReferenceSystem.setSelectedIndex(0);
            this.cmbReferenceSystem.setName("CMBREFSYST");
        }
        return this.cmbReferenceSystem;
    }

    private JComboBox getCmbColorField() {
        if (this.cmbColorField == null) {
            this.cmbColorField = new JComboBox();
            this.cmbColorField.setName("CMBCOLOR");
        }
        return this.cmbColorField;
    }

    private void refreshControls() {
        this.refreshCmbTextField();
        this.refreshCmbRotationField();
        this.refreshTextHeight();
        this.refreshCmbUnits();
        this.refreshCmbRefSystem();
        this.refreshFont();
        this.refreshColorFont();
    }

    private JComboBox getCmbRotationField() {
        if (this.cmbRotationField == null) {
            this.cmbRotationField = new JComboBox();
            this.cmbRotationField.setPreferredSize(new Dimension(200, 20));
            this.cmbRotationField.setName("CMBROTATIONFIELD");
        }
        return this.cmbRotationField;
    }

    private JComboBox getCmbHeightField() {
        if (this.cmbHeightField == null) {
            this.cmbHeightField = new JComboBox();
            this.cmbHeightField.setPreferredSize(new Dimension(200, 20));
            this.cmbHeightField.setName("CMBHEIGHTFIELD");
        }
        return this.cmbHeightField;
    }

    private JComboBox getCmbTextField() {
        if (this.cmbTextField == null) {
            this.cmbTextField = new JComboBox();
            this.cmbTextField.setPreferredSize(new Dimension(200, 20));
            this.cmbTextField.setName("CMBTEXTFIELD");
        }
        return this.cmbTextField;
    }

    private JFormattedTextField getTxtHeightField() {
        if (this.txtHeightField == null) {
            NumberFormat integerInstance = NumberFormat.getIntegerInstance();
            integerInstance.setGroupingUsed(false);
            NumberFormatter numberFormatter = new NumberFormatter(integerInstance);
            numberFormatter.setMinimum(Integer.valueOf(0));
            numberFormatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
            DefaultFormatterFactory tf = new DefaultFormatterFactory(numberFormatter, numberFormatter, numberFormatter, numberFormatter);
            this.txtHeightField = new JFormattedTextField();
            this.txtHeightField.setFormatterFactory(tf);
            this.txtHeightField.setValue(10);
            this.txtHeightField.setName("TXTHEIGHTFIELD");
        }
        return this.txtHeightField;
    }

    public void actionPerformed(ActionEvent e) {
        throw new Error("Not yet implemented!");
    }

    private ColorChooserPanel getColorChooser() {
        if (this.colorChooser == null) {
            this.colorChooser = new ColorChooserPanel(true);
        }
        return this.colorChooser;
    }

    public ILabelingStrategy getLabelingStrategy() {
        double fixedSize;
        try {
            fixedSize = ((Number)this.getTxtHeightField().getValue()).doubleValue();
        }
        catch (Exception e) {
            fixedSize = 10.0;
        }
        AttrInTableLabelingStrategy strategy = new AttrInTableLabelingStrategy();
        strategy.setLayer((FLayer)this.layer);
        if (this.getCmbHeightField().getItemCount() > 0 && !this.rdBtnFixedHeight.isSelected()) {
            strategy.setHeightField((String)this.getCmbHeightField().getSelectedItem());
        }
        if (this.getCmbRotationField().getItemCount() > 0) {
            if (!this.getCmbRotationField().getSelectedItem().equals(NO_FIELD_ITEM)) {
                strategy.setRotationField((String)this.getCmbRotationField().getSelectedItem());
            } else {
                strategy.setRotationField(null);
            }
        }
        if (this.getCmbTextField().getItemCount() > 0) {
            strategy.setTextField((String)this.getCmbTextField().getSelectedItem());
        }
        strategy.setUsesFixedSize(this.getRdBtnFixedHeight().isSelected());
        strategy.setFixedSize(fixedSize);
        if (this.getCmbUnits().getItemCount() > 0) {
            strategy.setUnit(this.getCmbUnits().getSelectedUnitIndex());
        }
        if (this.getCmbReferenceSystem().getItemCount() > 0) {
            strategy.setReferenceSystem(this.getCmbReferenceSystem().getSelectedIndex());
        }
        strategy.setUsesFixedColor(this.getRdBtnFixedColor().isSelected());
        strategy.setFixedColor(this.getColorChooser().getColor());
        if (this.getCmbColorField().getItemCount() > 0 && !this.rdBtnFixedColor.isSelected()) {
            strategy.setColorField((String)this.getCmbColorField().getSelectedItem());
        }
        strategy.setFont(this.getSelectedFont());
        return strategy;
    }

    public void setModel(FLayer layer, ILabelingStrategy str) {
        this.layer = (FLyrVect)layer;
        if (layer instanceof FLyrVect) {
            FLyrVect lv = (FLyrVect)layer;
            try {
                FeatureType featureType = lv.getFeatureStore().getDefaultFeatureType();
                this.fieldNames = new String[featureType.size()];
                Iterator iterator = featureType.iterator();
                ArrayList<String> l = new ArrayList<String>();
                ArrayList<String> lColors = new ArrayList<String>();
                while (iterator.hasNext()) {
                    String name;
                    FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)iterator.next();
                    this.fieldNames[descriptor.getIndex()] = name = descriptor.getName();
                    if (descriptor.getDataType().isNumeric()) {
                        l.add(name);
                    }
                    switch (descriptor.getType()) {
                        case 4: 
                        case 5: {
                            lColors.add(name);
                        }
                    }
                }
                this.numericFieldNames = l.toArray(new String[l.size()]);
                this.integerFieldNames = lColors.toArray(new String[lColors.size()]);
            }
            catch (DataException e) {
                NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"accessing_file_structure"), (Throwable)e);
            }
            this.refreshControls();
        }
    }

    private void refreshColorFont() {
        this.getCmbColorField().removeAllItems();
        boolean enabled = this.integerFieldNames.length > 0;
        this.getCmbColorField().setEnabled(enabled);
        this.getRdBtnColorField().setEnabled(enabled);
        if (!enabled) {
            this.getRdBtnFixedColor().setSelected(true);
        }
        for (int i = 0; i < this.integerFieldNames.length; ++i) {
            this.getCmbColorField().addItem((Object)this.integerFieldNames[i]);
        }
        if (this.layer.getLabelingStrategy() instanceof AttrInTableLabelingStrategy) {
            IAttrInTableLabelingStrategy aux = (IAttrInTableLabelingStrategy)this.layer.getLabelingStrategy();
            this.getRdBtnFixedColor().setSelected(aux.usesFixedColor());
            this.getRdBtnColorField().setSelected(!aux.usesFixedColor());
            String item = aux.getColorField();
            this.getCmbColorField().setSelectedItem((Object)item);
            this.getColorChooser().setColor(aux.getFixedColor());
        }
    }

    private void refreshFont() {
        if (this.layer.getLabelingStrategy() instanceof AttrInTableLabelingStrategy) {
            IAttrInTableLabelingStrategy aux = (IAttrInTableLabelingStrategy)this.layer.getLabelingStrategy();
            this.labelFont = aux.getFont();
        }
    }

    private void refreshCmbUnits() {
        if (this.layer.getLabelingStrategy() instanceof AttrInTableLabelingStrategy) {
            AttrInTableLabelingStrategy aux = (AttrInTableLabelingStrategy)this.layer.getLabelingStrategy();
            this.getCmbUnits().setSelectedUnitIndex(aux.getUnit());
        }
    }

    private void refreshCmbRefSystem() {
        if (this.layer.getLabelingStrategy() instanceof AttrInTableLabelingStrategy) {
            AttrInTableLabelingStrategy aux = (AttrInTableLabelingStrategy)this.layer.getLabelingStrategy();
            this.getCmbReferenceSystem().setSelectedIndex(aux.getReferenceSystem());
        }
    }

    private void refreshTextHeight() {
        this.getCmbHeightField().removeAllItems();
        for (int i = 0; i < this.numericFieldNames.length; ++i) {
            this.getCmbHeightField().addItem((Object)this.numericFieldNames[i]);
        }
        if (this.layer.getLabelingStrategy() instanceof AttrInTableLabelingStrategy) {
            IAttrInTableLabelingStrategy aux = (IAttrInTableLabelingStrategy)this.layer.getLabelingStrategy();
            this.getTxtHeightField().setValue(aux.getFixedSize());
            this.getRdBtnFixedHeight().setSelected(aux.usesFixedSize());
            this.getRdBtnHeightField().setSelected(!aux.usesFixedSize());
            String item = aux.getHeightField();
            this.getCmbHeightField().setSelectedItem((Object)item);
        }
    }

    private void refreshCmbRotationField() {
        this.getCmbRotationField().removeAllItems();
        this.getCmbRotationField().addItem((Object)NO_FIELD_ITEM);
        for (int i = 0; i < this.numericFieldNames.length; ++i) {
            this.getCmbRotationField().addItem((Object)this.numericFieldNames[i]);
        }
        if (this.layer.getLabelingStrategy() instanceof AttrInTableLabelingStrategy) {
            IAttrInTableLabelingStrategy aux = (IAttrInTableLabelingStrategy)this.layer.getLabelingStrategy();
            String item = aux.getRotationField();
            this.getCmbRotationField().setSelectedItem((Object)(item != null ? item : NO_FIELD_ITEM));
        }
    }

    private void refreshCmbTextField() {
        this.getCmbTextField().removeAllItems();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            this.getCmbTextField().addItem((Object)this.fieldNames[i]);
        }
        if (this.layer.getLabelingStrategy() instanceof AttrInTableLabelingStrategy) {
            IAttrInTableLabelingStrategy aux = (IAttrInTableLabelingStrategy)this.layer.getLabelingStrategy();
            String item = aux.getTextField();
            this.getCmbTextField().setSelectedItem((Object)(item != null ? item : NO_FIELD_ITEM));
        }
    }

    public String getLabelingStrategyName() {
        return PluginServices.getText((Object)this, (String)"label_attributes_defined_in_table");
    }

    public Class getLabelingStrategyClass() {
        return AttrInTableLabelingStrategy.class;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getCmbColorField().setEnabled(enabled);
        this.getCmbHeightField().setEnabled(enabled);
        this.getCmbReferenceSystem().setEnabled(enabled);
        this.getCmbRotationField().setEnabled(enabled);
        this.getCmbTextField().setEnabled(enabled);
        this.getCmbUnits().setEnabled(enabled);
        this.getColorChooser().setEnabled(enabled);
        this.getRdBtnColorField().setEnabled(enabled);
        this.getRdBtnFixedColor().setEnabled(enabled);
        this.getRdBtnFixedHeight().setEnabled(enabled);
        this.getRdBtnHeightField().setEnabled(enabled);
        this.getTxtHeightField().setEnabled(enabled);
        this.getCmbFontType().setEnabled(enabled);
        this.getChkBoxBold().setEnabled(enabled);
        this.getChkItalic().setEnabled(enabled);
    }

    public int getSelectedStyle() {
        int result = 0;
        if (this.getChkBoxBold().isSelected()) {
            ++result;
        }
        if (this.getChkItalic().isSelected()) {
            result += 2;
        }
        return result;
    }

    public Font getSelectedFont() {
        return new Font((String)this.getCmbFontType().getSelectedItem(), this.getSelectedStyle(), ((Number)this.getTxtHeightField().getValue()).intValue());
    }
}

