/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.project.documents.view.legend.gui.GeneralLayerPropertiesPageView;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.propertypage.PropertiesPageFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralLayerPropertiesPage
extends GeneralLayerPropertiesPageView
implements PropertiesPage {
    private static final Logger logger = LoggerFactory.getLogger(GeneralLayerPropertiesPage.class);
    private FLayer layer = null;

    public GeneralLayerPropertiesPage(FLayer layer) {
        this.initComponents();
        this.setLayer(layer);
    }

    public void setData(Object data) {
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.rdoShowAlways.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GeneralLayerPropertiesPage.this.txtIsGreaterThan.setEnabled(false);
                GeneralLayerPropertiesPage.this.txtIsLessThan.setEnabled(false);
            }
        });
        this.rdoShowConditionedToTheScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GeneralLayerPropertiesPage.this.txtIsGreaterThan.setEnabled(true);
                GeneralLayerPropertiesPage.this.txtIsLessThan.setEnabled(true);
            }
        });
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtProperties);
        this.translate();
        ToolsSwingUtils.ensureRowsCols((JComponent)this.txtProperties, (int)10, (int)60, (int)15, (int)100);
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblName.setText(i18nManager.getTranslation("Nombre") + ":");
        this.lblRangeOfScales.setText(i18nManager.getTranslation("rango_de_escalas"));
        this.lblIsGreaterThan.setText(i18nManager.getTranslation("este_por_encima_de"));
        this.lblIsLessThan.setText(i18nManager.getTranslation("este_por_debajo_de_"));
        this.lblFullScale.setText(i18nManager.getTranslation("escala_maxima"));
        this.lblMinumunScale.setText(i18nManager.getTranslation("escala_minima"));
        this.lblProperties.setText(i18nManager.getTranslation("propiedades"));
        this.rdoShowAlways.setText(i18nManager.getTranslation("Mostrar_siempre"));
        this.rdoShowConditionedToTheScale.setText(i18nManager.getTranslation("No_mostrar_la_capa_cuando_la_escala") + ":");
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("General");
    }

    public int getPriority() {
        return 1000;
    }

    public boolean whenAccept() {
        this.whenApply();
        return true;
    }

    public boolean whenApply() {
        block10: {
            NumberFormat nf = NumberFormat.getInstance();
            if (this.rdoShowConditionedToTheScale.isSelected()) {
                String s;
                try {
                    s = this.txtIsGreaterThan.getText();
                    if (StringUtils.isEmpty((CharSequence)s)) {
                        this.layer.setMinScale(-1.0);
                    } else {
                        this.layer.setMinScale(nf.parse(s).doubleValue());
                    }
                }
                catch (ParseException ex) {
                    this.txtIsGreaterThan.setText("");
                }
                try {
                    s = this.txtIsLessThan.getText();
                    if (StringUtils.isEmpty((CharSequence)s)) {
                        this.layer.setMaxScale(-1.0);
                        break block10;
                    }
                    this.layer.setMaxScale(nf.parse(s).doubleValue());
                }
                catch (ParseException ex) {
                    this.txtIsLessThan.setText("");
                }
            } else {
                this.layer.setMinScale(-1.0);
                this.layer.setMaxScale(-1.0);
            }
        }
        if (!this.txtName.getText().equals(this.layer.getName())) {
            this.layer.setName(this.txtName.getText());
        }
        return true;
    }

    public boolean whenCancel() {
        return true;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setLayer(FLayer layer) {
        NumberFormat nf = NumberFormat.getInstance();
        this.layer = layer;
        this.txtName.setText(this.layer.getName());
        String info = this.getLayerInfo();
        if (info.startsWith("<html>")) {
            this.txtProperties.setContentType("text/html");
        }
        this.txtProperties.setText(info);
        this.txtProperties.setCaretPosition(0);
        if (layer.getMinScale() != -1.0) {
            this.txtIsGreaterThan.setText(nf.format(layer.getMinScale()));
        }
        if (layer.getMaxScale() != -1.0) {
            this.txtIsLessThan.setText(nf.format(layer.getMaxScale()));
        }
        if (layer.getMinScale() == -1.0 && layer.getMaxScale() == -1.0) {
            this.rdoShowConditionedToTheScale.setSelected(false);
        } else {
            this.rdoShowConditionedToTheScale.setSelected(true);
        }
    }

    private String getLayerInfo() {
        String info;
        StringBuilder buff = new StringBuilder();
        try {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            info = this.layer.getInfoString();
            if (info == null) {
                info = "";
            }
        }
        catch (Exception e) {
            logger.warn("Can't get layer information.", (Throwable)e);
            info = "";
        }
        return info;
    }

    public static class GeneralLayerPropertiesPageFactory
    implements PropertiesPageFactory {
        public String getGroupID() {
            return "LayerPropertiesPageGroup";
        }

        public String getName() {
            return "General";
        }

        public boolean isVisible(Object obj) {
            return obj instanceof FLayer;
        }

        public PropertiesPage create(Object container, Object obj) {
            return new GeneralLayerPropertiesPage((FLayer)obj);
        }
    }
}

