/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.legend.gui.AbstractThemeManagerPage;
import org.gvsig.app.project.documents.view.legend.gui.ILabelingStrategyPanel;
import org.gvsig.app.project.documents.view.legend.gui.LabelingPanel;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelable;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingStrategy;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.symbology.swing.SymbologySwingManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.utils.swing.JComboBox;

public class LabelingManager
extends AbstractThemeManagerPage
implements ActionListener,
LabelingPanel {
    private static final long serialVersionUID = 856162295985695717L;
    private Comparator<Class<?>> comparator = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    };
    private TreeMap<Class<?>, ILabelingStrategyPanel> strategyPanels = new TreeMap(this.comparator);
    private JCheckBox chkApplyLabels;
    private ILabelable layer;
    private JPanel content;
    private JPanel pnlNorth;
    private JComboBox cmbStrategy;

    public LabelingManager() {
        this.initialize();
    }

    @Override
    public boolean isLabelingEnabled() {
        return this.getChkApplyLabels().isSelected();
    }

    @Override
    public void setLabelingEnabled(boolean enabled) {
        this.getChkApplyLabels().setSelected(enabled);
        this.getCmbStrategy().setEnabled(enabled);
        ILabelingStrategyPanel panel = this.getCurrentLabelingStrategy();
        ((Component)panel).setEnabled(enabled);
    }

    @Override
    public void setCurrentLabelingStrategy(ILabelingStrategyPanel panel) {
        ComboBoxModel model = this.getCmbStrategy().getModel();
        model.setSelectedItem(panel);
    }

    @Override
    public ILabelingStrategyPanel getCurrentLabelingStrategy() {
        ILabelingStrategyPanel panel = ((LabelingStrategyItem)this.getCmbStrategy().getSelectedItem()).strategyPanel;
        return panel;
    }

    @Override
    public FLayer getLayer() {
        return (FLayer)this.layer;
    }

    @Override
    public void setLayer(FLayer layer) {
        this.setModel(layer);
    }

    @Override
    public ILabelingStrategy getLabelingStrategy() {
        ILabelingStrategyPanel panel = ((LabelingStrategyItem)this.getCmbStrategy().getSelectedItem()).strategyPanel;
        ILabelingStrategy strategy = panel.getLabelingStrategy();
        return strategy;
    }

    @Override
    public int getPriority() {
        return 600;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        SymbologySwingManager symbologySwingManager = SymbologySwingLocator.getSwingManager();
        for (ILabelingStrategyPanel pnl : symbologySwingManager.getLabelingEditors()) {
            this.strategyPanels.put(pnl.getLabelingStrategyClass(), pnl);
        }
        this.content = new JPanel(new BorderLayout());
        this.content.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.getPnlNorth(), "North");
        this.add((Component)this.content, "South");
    }

    private JPanel getPnlNorth() {
        if (this.pnlNorth == null) {
            this.pnlNorth = new JPanel(new BorderLayout(5, 5));
            JPanel aux = new JPanel(new BorderLayout());
            aux.add((Component)this.getChkApplyLabels(), "Before");
            ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
            JComponent c = cfgActionsManager.getConfigurableActionsComponent("labelingPropertiesPage", (Object)this);
            aux.add((Component)c, "After");
            this.pnlNorth.add((Component)aux, "North");
            aux = new JPanel(new FlowLayout(0));
            aux.add(new JLabel(PluginServices.getText((Object)this, (String)"general") + ":"));
            aux.add((Component)this.getCmbStrategy());
            this.pnlNorth.add((Component)aux, "Center");
        }
        return this.pnlNorth;
    }

    private JComboBox getCmbStrategy() {
        if (this.cmbStrategy == null) {
            Iterator<ILabelingStrategyPanel> it = this.strategyPanels.values().iterator();
            ArrayList<LabelingStrategyItem> aux = new ArrayList<LabelingStrategyItem>();
            while (it.hasNext()) {
                aux.add(new LabelingStrategyItem(it.next()));
            }
            Object[] items = aux.toArray(new LabelingStrategyItem[aux.size()]);
            this.cmbStrategy = new JComboBox(items){
                private static final long serialVersionUID = 7506754097091500846L;

                public void setSelectedItem(Object anObject) {
                    if (anObject == null) {
                        return;
                    }
                    if (anObject instanceof ILabelingStrategy) {
                        ILabelingStrategy st = (ILabelingStrategy)anObject;
                        for (ILabelingStrategyPanel pnl : LabelingManager.this.strategyPanels.values()) {
                            if (pnl.getLabelingStrategyClass() == null || !pnl.getLabelingStrategyClass().equals(st.getClass())) continue;
                            super.setSelectedItem((Object)new LabelingStrategyItem(pnl));
                            return;
                        }
                    } else {
                        super.setSelectedItem(anObject);
                    }
                }
            };
            this.cmbStrategy.setName("CMBMODE");
            this.cmbStrategy.addActionListener((ActionListener)this);
        }
        return this.cmbStrategy;
    }

    private JCheckBox getChkApplyLabels() {
        if (this.chkApplyLabels == null) {
            this.chkApplyLabels = new JCheckBox(PluginServices.getText((Object)this, (String)"enable_labeling"));
            this.chkApplyLabels.setName("CHKAPPLYLABELS");
            this.chkApplyLabels.addActionListener(this);
        }
        return this.chkApplyLabels;
    }

    public static void addLabelingStrategy(Class<? extends ILabelingStrategyPanel> iLabelingStrategyPanelClass) {
        SymbologySwingManager symbologySwingManager = SymbologySwingLocator.getSwingManager();
        symbologySwingManager.registerLabelingEditor(iLabelingStrategyPanelClass);
    }

    private void setComponentEnabled(Component c, boolean b) {
        c.setEnabled(b);
    }

    @Override
    public void setModel(FLayer layer) throws IllegalArgumentException {
        if (!layer.isAvailable()) {
            this.setComponentEnabled(this, false);
            this.getChkApplyLabels().setSelected(false);
            this.getChkApplyLabels().setEnabled(false);
            this.getCmbStrategy().setEnabled(false);
            return;
        }
        if (layer instanceof ILabelable) {
            this.layer = (ILabelable)layer;
            this.getChkApplyLabels().setEnabled(true);
            this.getCmbStrategy().setEnabled(true);
            this.setComponentEnabled(this, true);
            this.refreshControls();
            ActionEvent evt = new ActionEvent(this.chkApplyLabels, 0, null);
            evt.setSource(this.chkApplyLabels);
            this.actionPerformed(evt);
            this.getCmbStrategy().setSelectedItem((Object)this.layer.getLabelingStrategy());
            evt.setSource(this.getCmbStrategy());
            this.actionPerformed(evt);
        } else {
            this.setComponentEnabled(this, false);
        }
    }

    private void refreshControls() {
        if (this.layer == null) {
            return;
        }
        JCheckBox applyLabels = this.getChkApplyLabels();
        applyLabels.setSelected(this.layer.isLabeled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block4: {
            ILabelingStrategyPanel panel;
            JComponent c;
            block3: {
                c = (JComponent)e.getSource();
                if (!c.equals(this.chkApplyLabels)) break block3;
                boolean b = this.chkApplyLabels.isSelected();
                this.getCmbStrategy().setEnabled(b);
                for (int i = 0; i < this.content.getComponentCount(); ++i) {
                    Component c1 = this.content.getComponent(i);
                    if (c1.equals(c)) continue;
                    this.setComponentEnabled(c1, b);
                }
                break block4;
            }
            if (!c.equals(this.cmbStrategy) || !c.equals(this.cmbStrategy) || (panel = ((LabelingStrategyItem)this.cmbStrategy.getSelectedItem()).strategyPanel) == null) break block4;
            try {
                this.remove(this.content);
                panel.setModel((FLayer)this.layer, this.layer.getLabelingStrategy());
                this.content.removeAll();
                this.content.add((Component)panel);
                this.add((Component)this.content, "Center");
                this.actionPerformed(new ActionEvent(this.chkApplyLabels, 0, null));
                this.revalidate();
                this.paintImmediately(this.getBounds());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void acceptAction() {
        this.applyAction();
    }

    @Override
    public void cancelAction() {
    }

    @Override
    public void applyAction() {
        if (this.layer != null) {
            ILabelingStrategyPanel panel = ((LabelingStrategyItem)this.getCmbStrategy().getSelectedItem()).strategyPanel;
            ILabelingStrategy strategy = panel.getLabelingStrategy();
            this.layer.setLabelingStrategy(strategy);
            this.layer.setIsLabeled(this.getChkApplyLabels().isSelected());
        }
    }

    @Override
    public String getName() {
        return PluginServices.getText((Object)this, (String)"Etiquetados");
    }

    private class LabelingStrategyItem {
        private ILabelingStrategyPanel strategyPanel;

        private LabelingStrategyItem(ILabelingStrategyPanel strategyPanel) {
            this.strategyPanel = strategyPanel;
        }

        public String toString() {
            return this.strategyPanel.getLabelingStrategyName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LabelingStrategyItem) {
                LabelingStrategyItem item = (LabelingStrategyItem)obj;
                return this.strategyPanel.getClass().equals(item.strategyPanel.getClass());
            }
            return super.equals(obj);
        }
    }
}

