/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.project.documents.view.legend.gui.AbstractThemeManagerPage;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.LegendsPanel;
import org.gvsig.fmap.mapcontext.exceptions.LegendLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.operations.Classifiable;
import org.gvsig.fmap.mapcontext.layers.operations.ClassifiableVectorial;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.symbology.swing.SymbologySwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendManager
extends AbstractThemeManagerPage
implements LegendsPanel {
    private static final Logger logger = LoggerFactory.getLogger(LegendManager.class);
    private static final long serialVersionUID = 7989057553773181019L;
    private FLayer layer;
    private ILegend legend;
    private final Pages pages = new Pages();
    private JPanel topPanel = null;
    private JTextArea titleArea = null;
    private JPanel preview = null;
    private JScrollPane jTitleScrollPane = null;
    private JTree jTreeLegends;
    private ILegendPanel activePanel;
    private JScrollPane legendTreeScrollPane;
    private final DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    private DefaultTreeModel treeModel;
    private JScrollPane jPanelContainer;
    private JPanel jCentralPanel;
    private JSplitPane jSplitPane;
    private boolean isTreeListenerDisabled;
    private JButton btnOptionalActions;
    private JPopupMenu menuOptionalActions;
    private Hashtable<FLayer, ILegend> table = null;
    private boolean empty = true;
    private JLabel iconLabel;
    public static String defaultLegendFolderPath;

    public LegendManager() {
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        defaultLegendFolderPath = folderManager.getLastPath("LegendsFolder", folderManager.getHome()).getAbsolutePath();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)this.getSplitPane(), "Center");
        this.setSize(500, 360);
        this.treeModel = new DefaultTreeModel(this.root);
    }

    private JSplitPane getSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane(1);
            JPanel aux = new JPanel(new BorderLayout(0, 5));
            aux.add((Component)this.getLegendTreeScrollPane(), "Center");
            aux.add((Component)this.getPreviewPanel(), "South");
            this.jSplitPane.setLeftComponent(aux);
            this.jSplitPane.setRightComponent(this.getCentralPanel());
            this.jSplitPane.setDividerLocation(150);
        }
        return this.jSplitPane;
    }

    private JPanel getCentralPanel() {
        if (this.jCentralPanel == null) {
            this.jCentralPanel = new JPanel(new BorderLayout(0, 10));
            this.jCentralPanel.add((Component)this.getTitleScroll(), "North");
            this.jCentralPanel.add((Component)this.getJPanelContainer(), "Center");
        }
        return this.jCentralPanel;
    }

    private JScrollPane getJPanelContainer() {
        if (this.jPanelContainer == null) {
            this.jPanelContainer = new JScrollPane();
            this.jPanelContainer.setBorder(null);
        }
        return this.jPanelContainer;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel(new FlowLayout(2, 5, 0));
            this.topPanel.setPreferredSize(new Dimension(638, 31));
            this.topPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
            this.topPanel.add((Component)this.getBtnOptionalActions(), null);
        }
        return this.topPanel;
    }

    private JButton getBtnOptionalActions() {
        if (this.btnOptionalActions == null) {
            this.btnOptionalActions = new JButton(PluginServices.getText((Object)this, (String)"_Mas_opciones") + "...");
            this.btnOptionalActions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Point p = LegendManager.this.btnOptionalActions.getLocationOnScreen();
                    LegendManager.this.menuOptionalActions.show(LegendManager.this.asJComponent(), 0, 0);
                    LegendManager.this.menuOptionalActions.setLocation(p.x, p.y + LegendManager.this.btnOptionalActions.getHeight());
                }
            });
        }
        return this.btnOptionalActions;
    }

    private JTextArea getTitleArea() {
        if (this.titleArea == null) {
            this.titleArea = new JTextArea();
            this.titleArea.setBackground(SystemColor.control);
            this.titleArea.setLineWrap(true);
            this.titleArea.setRows(0);
            this.titleArea.setWrapStyleWord(false);
            this.titleArea.setEditable(false);
            this.titleArea.setPreferredSize(new Dimension(495, 40));
        }
        return this.titleArea;
    }

    private JPanel getPreviewPanel() {
        if (this.preview == null) {
            this.preview = new JPanel();
            this.preview.setBorder(BorderFactory.createBevelBorder(1));
            this.preview.setBackground(SystemColor.text);
            this.preview.setLayout(new BorderLayout(5, 5));
            this.preview.add(this.getIconLabel());
            this.preview.setPreferredSize(new Dimension(this.getSplitPane().getDividerLocation(), 130));
            this.preview.setBackground(Color.white);
        }
        return this.preview;
    }

    private JLabel getIconLabel() {
        if (this.iconLabel == null) {
            this.iconLabel = new JLabel();
            this.iconLabel.setVerticalAlignment(0);
            this.iconLabel.setHorizontalAlignment(0);
        }
        return this.iconLabel;
    }

    private JScrollPane getLegendTreeScrollPane() {
        if (this.legendTreeScrollPane == null) {
            this.legendTreeScrollPane = new JScrollPane();
            this.legendTreeScrollPane.setViewportView(this.getJTreeLegends());
        }
        return this.legendTreeScrollPane;
    }

    public static void addLegendPage(Class<? extends ILegendPanel> iLegendPanelClass) {
        SymbologySwingManager manager = SymbologySwingLocator.getSwingManager();
        manager.registerLegendEditor(iLegendPanelClass);
    }

    private void fillDialog() {
        if (this.empty) {
            SymbologySwingManager manager = SymbologySwingLocator.getSwingManager();
            this.pages.clear();
            this.treeModel = new DefaultTreeModel(this.root);
            try {
                for (ILegendPanel page : manager.getLegendEditors(this.layer)) {
                    this.pages.add(page);
                }
            }
            catch (Throwable th) {
                logger.warn("Problems loading legend editors.", th);
            }
            for (ILegendPanel page : this.pages) {
                try {
                    this.doInsertNode(this.treeModel, page);
                }
                catch (Throwable th) {
                    logger.warn("Problems adding legend editor (" + (page == null ? "NULL" : page.getTitle()) + ") to the GUI.", th);
                }
            }
            this.addOptionalActions();
            this.getJTreeLegends().setModel(this.treeModel);
            this.getJTreeLegends().repaint();
            this.empty = false;
        }
    }

    private void addOptionalActions() {
        this.menuOptionalActions = new JPopupMenu();
        Iterable actions = SymbologySwingLocator.getSwingManager().getOptionalActionOfLegendsPanel();
        for (Action action : actions) {
            JMenuItemForOptionalAction item = new JMenuItemForOptionalAction(action);
            this.menuOptionalActions.add(item);
        }
    }

    private DefaultMutableTreeNode findNode(Class searchID) {
        String title;
        try {
            title = ((ILegendPanel)Class.forName(searchID.getName()).newInstance()).getTitle();
        }
        catch (Exception e) {
            return null;
        }
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            ILegendPanel legend;
            DefaultMutableTreeNode nodeAux = (DefaultMutableTreeNode)e.nextElement();
            if (nodeAux == null || (legend = (ILegendPanel)nodeAux.getUserObject()) == null || !legend.getTitle().equals(title)) continue;
            return nodeAux;
        }
        return null;
    }

    private MutableTreeNode insertNodeHere(DefaultTreeModel tm, MutableTreeNode parent_node, ILegendPanel item) {
        MutableTreeNode pn = null;
        pn = parent_node == null ? this.root : parent_node;
        DefaultMutableTreeNode nodeValue = new DefaultMutableTreeNode(item);
        int children = pn.getChildCount();
        int pos = 0;
        String pTitle = null;
        for (int i = 0; i < children; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tm.getChild(pn, i);
            if (!(node.getUserObject() instanceof ILegendPanel) || (pTitle = ((ILegendPanel)node.getUserObject()).getTitle()).compareTo(item.getTitle()) >= 0) continue;
            ++pos;
        }
        tm.insertNodeInto(nodeValue, pn, pos);
        return nodeValue;
    }

    private MutableTreeNode doInsertNode(DefaultTreeModel tm, ILegendPanel page) {
        if (tm == null || page == null) {
            return null;
        }
        MutableTreeNode aux = this.findNode(page.getClass());
        if (aux != null) {
            return aux;
        }
        Class parent_class = page.getParentClass();
        if (parent_class != null) {
            if (this.pages.contains(parent_class)) {
                ILegendPanel parent = this.pages.get(parent_class);
                aux = this.doInsertNode(tm, parent);
                if (aux != null) {
                    return this.insertNodeHere(tm, aux, page);
                }
                return null;
            }
            return null;
        }
        return this.insertNodeHere(tm, null, page);
    }

    private JScrollPane getTitleScroll() {
        if (this.jTitleScrollPane == null) {
            this.jTitleScrollPane = new JScrollPane();
            this.jTitleScrollPane.setBounds(2, 2, 498, 42);
            this.jTitleScrollPane.setViewportView(this.getTitleArea());
            this.jTitleScrollPane.setBorder(null);
        }
        return this.jTitleScrollPane;
    }

    private JTree getJTreeLegends() {
        if (this.jTreeLegends == null) {
            this.jTreeLegends = new JTree();
            this.jTreeLegends.setRootVisible(false);
            MyTreeCellRenderer treeCellRenderer = new MyTreeCellRenderer();
            treeCellRenderer.setOpenIcon(null);
            treeCellRenderer.setClosedIcon(null);
            treeCellRenderer.setLeafIcon(null);
            this.jTreeLegends.setCellRenderer(treeCellRenderer);
            this.jTreeLegends.setShowsRootHandles(true);
            this.jTreeLegends.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    if (LegendManager.this.isTreeListenerDisabled) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)LegendManager.this.jTreeLegends.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    LegendManager.this.setActivePage((ILegendPanel)node.getUserObject());
                }
            });
            this.jTreeLegends.putClientProperty("JTree.linestyle", "Angled");
            this.jTreeLegends.getSelectionModel().setSelectionMode(1);
        }
        return this.jTreeLegends;
    }

    public void setActivePage(ILegendPanel page) {
        if (page.getPanel() == null) {
            DefaultMutableTreeNode node = this.findNode(page.getClass());
            if (this.treeModel.getChildCount(node) > 0) {
                DefaultMutableTreeNode dmn = (DefaultMutableTreeNode)this.treeModel.getChild(node, 0);
                page = (ILegendPanel)dmn.getUserObject();
                this.setActivePage(page);
                this.expandAndSelect(page);
            }
        } else {
            this.activePanel = page;
            this.setIcon(this.activePanel.getIcon());
            this.activePanel.setData(this.layer, this.legend);
            this.getTitleArea().setText(this.activePanel.getDescription());
            this.jPanelContainer.setViewportView(this.activePanel.getPanel());
        }
    }

    public ILegendPanel getActivePage() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void setIcon(ImageIcon icon) {
        this.getIconLabel().setIcon(icon);
    }

    private void expandAndSelect(Object node) {
        this.isTreeListenerDisabled = true;
        boolean exit = false;
        TreePath tp = null;
        for (int i = 0; i < this.jTreeLegends.getRowCount() && !exit; ++i) {
            tp = this.jTreeLegends.getPathForRow(i);
            Object[] obj = tp.getPath();
            for (int j = 0; j < obj.length && !exit; ++j) {
                Object o = ((DefaultMutableTreeNode)obj[j]).getUserObject();
                if (o == null || !o.getClass().equals(node.getClass()) || !o.equals(node)) continue;
                while (i >= 0) {
                    this.jTreeLegends.collapseRow(i);
                    --i;
                }
                exit = true;
            }
            this.jTreeLegends.expandRow(i);
        }
        if (tp != null) {
            this.jTreeLegends.expandPath(tp);
            this.jTreeLegends.setSelectionPath(tp);
        }
        this.isTreeListenerDisabled = false;
    }

    @Override
    public String getName() {
        return PluginServices.getText((Object)this, (String)"Simbologia");
    }

    @Override
    public void acceptAction() {
        this.applyAction();
    }

    @Override
    public void cancelAction() {
    }

    @Override
    public void applyAction() {
        FLayer laux;
        this.legend = this.activePanel.getLegend();
        if (this.table != null && this.table.size() > 1) {
            this.applyRestOfLegends(this.table, this.layer.getMapContext().getLayers());
        }
        if ((laux = this.getLayer()) instanceof ClassifiableVectorial) {
            ClassifiableVectorial aux2 = (ClassifiableVectorial)laux;
            try {
                if (this.legend instanceof IClassifiedVectorLegend) {
                    IClassifiedVectorLegend cl = (IClassifiedVectorLegend)this.legend;
                    if (aux2 instanceof FLyrVect) {
                        if (cl.getValues().length == 0) {
                            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_es_posible_aplicar_leyenda_vacia"));
                            return;
                        }
                        aux2.setLegend((IVectorLegend)this.legend);
                    }
                } else if (this.legend instanceof IVectorLegend) {
                    aux2.setLegend((IVectorLegend)this.legend);
                }
            }
            catch (LegendLayerException e) {
                NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"legend_exception"), (Throwable)e);
            }
        }
    }

    private void applyRestOfLegends(Hashtable<FLayer, ILegend> table2, FLayers layers) {
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            FLayer my_layer = layers.getLayer(i);
            if (!(my_layer instanceof FLayers)) {
                if (!(my_layer instanceof ClassifiableVectorial)) continue;
                try {
                    if (!this.table.containsKey(my_layer)) continue;
                    ClassifiableVectorial lyr = (ClassifiableVectorial)my_layer;
                    lyr.setLegend((IVectorLegend)this.table.get(my_layer));
                }
                catch (LegendLayerException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.applyRestOfLegends(this.table, (FLayers)my_layer);
        }
    }

    @Override
    public void setModel(FLayer layer) {
        this.layer = layer;
        this.applyLegend(((Classifiable)layer).getLegend());
    }

    private void applyLegend(ILegend aLegend) {
        this.legend = aLegend;
        this.fillDialog();
        for (ILegendPanel page : this.pages) {
            if (!this.legend.getClass().equals(page.getLegendClass())) continue;
            this.setActivePage(page);
            this.expandAndSelect(page);
            return;
        }
        NotificationManager.addWarning((String)PluginServices.getText((Object)this, (String)"caution_no_registered_panel_associated_to_loaded_legend_the_legend_wont_be_applied"));
    }

    @Override
    public int getPriority() {
        return 800;
    }

    public ILegend getLegend() {
        return this.legend;
    }

    public void setLegend(ILegend legend) {
        this.applyLegend(legend);
    }

    public FLayer getLayer() {
        return this.layer;
    }

    public void setLayer(FLayer layer) {
        this.layer = layer;
        this.applyLegend(((Classifiable)layer).getLegend());
    }

    public ILegendPanel getPage(Class<? extends ILegendPanel> pageClass) {
        return this.pages.get(pageClass);
    }

    public Collection<ILegendPanel> getPages() {
        return this.pages.asCollection();
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -6013698992263578041L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)value).getUserObject() instanceof ILegendPanel) {
                ILegendPanel legend = (ILegendPanel)node.getUserObject();
                this.setText(legend.getPanel() == null ? "<html><b>" + legend.getTitle() + "</b></html>" : legend.getTitle());
            }
            return this;
        }
    }

    private class JMenuItemForOptionalAction
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 1656264978338543368L;
        Action action;

        JMenuItemForOptionalAction(Action action) {
            this.action = action;
            this.configurePropertiesFromAction(action);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e.setSource(LegendManager.this);
            this.action.actionPerformed(e);
        }
    }

    public static class Pages
    implements Iterable<ILegendPanel> {
        private Map<Class<? extends ILegendPanel>, ILegendPanel> pages = new HashMap<Class<? extends ILegendPanel>, ILegendPanel>();

        public void add(ILegendPanel page) {
            this.pages.put(page.getClass(), page);
        }

        public void clear() {
            this.pages.clear();
        }

        @Override
        public Iterator<ILegendPanel> iterator() {
            return this.pages.values().iterator();
        }

        public boolean contains(Class<? extends ILegendPanel> pageClass) {
            return this.pages.containsKey(pageClass);
        }

        public ILegendPanel get(Class<? extends ILegendPanel> pageClass) {
            return this.pages.get(pageClass);
        }

        public Collection<ILegendPanel> asCollection() {
            return this.pages.values();
        }
    }
}

