/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.styling.SymbolLevelsWindow;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.documents.view.legend.gui.Features;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ZSort;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.SingleSymbolLegend;

public class SingleSymbol
extends JPanel
implements ILegendPanel,
ActionListener {
    private JPanel symbolPanel = null;
    private int shapeType;
    private GridBagLayoutPanel legendPanel = null;
    private SymbolPreviewer symbolPreviewComponent;
    private JButton btnOpenSymbolSelector;
    private JTextField txtLabel;
    private JButton btnOpenSymbolLevelsEditor;
    private SingleSymbolLegend legend;
    private ZSort zSort;
    private FeatureStore featureStore;
    private transient MutableObject<Feature> sampleFeature;
    private JCheckBox chkDrawSymbolInEachPrimitive;

    public SingleSymbol() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(320, 160));
        this.add((Component)this.getSymbolPanel(), "Center");
        this.add((Component)this.getLegendPanel(), "South");
    }

    public void setData(FLayer lyr, ILegend legend) {
        try {
            this.shapeType = ((FLyrVect)lyr).getShapeType();
        }
        catch (ReadException e) {
            NotificationManager.addError((String)"Could not find out the shape type", (Throwable)e);
        }
        if (lyr instanceof FLyrVect) {
            this.setFeatureStore(((FLyrVect)lyr).getFeatureStore());
        }
        if (legend instanceof SingleSymbolLegend) {
            this.setSymbol(legend.getDefaultSymbol());
            this.legend = (SingleSymbolLegend)legend;
        } else {
            this.legend = (SingleSymbolLegend)MapContextLocator.getMapContextManager().createLegend("SingleSymbol");
            this.legend.setShapeType(this.shapeType);
        }
        this.getSymbolPreviewPanel().setSymbol(this.legend.getDefaultSymbol());
        this.getBtnOpenSymbolLevelsEditor().setEnabled(legend != null);
        this.txtLabel.setText(legend.getDefaultSymbol().getDescription());
    }

    public ILegend getLegend() {
        ISymbol symbol = this.getSymbolPreviewPanel().getSymbol();
        symbol.setDescription(this.txtLabel.getText());
        SingleSymbolLegend leg = new SingleSymbolLegend();
        leg.setShapeType(this.shapeType);
        leg.setDefaultSymbol(symbol);
        leg.setZSort(this.zSort);
        leg.setDrawSymbolInEeachPrimitive(this.chkDrawSymbolInEachPrimitive.isSelected());
        return leg;
    }

    public String getDescription() {
        return PluginServices.getText((Object)this, (String)"Muestra_todos_s_elementos_de_una_capa_usando_el_mismo_simbolo");
    }

    public Class getParentClass() {
        return Features.class;
    }

    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"Simbolo_unico");
    }

    public JPanel getPanel() {
        return this;
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"legend-overview-single-symbol");
    }

    public Class getLegendClass() {
        return SingleSymbolLegend.class;
    }

    private JPanel getSymbolPanel() {
        if (this.symbolPanel == null) {
            this.symbolPanel = new JPanel(new BorderLayout());
            this.symbolPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"symbol"), 0, 0, null, null));
            this.symbolPanel.add((Component)this.putInPanel((JComponent)this.getSymbolPreviewPanel()), "Center");
            JPanel bp = new JPanel(new BorderLayout());
            bp.add((Component)this.putInPanel((JComponent)this.getBtnOpenSymbolSelector()), "Center");
            bp.add((Component)this.putInPanel((JComponent)this.getBtnOpenSymbolLevelsEditor()), "South");
            this.symbolPanel.add((Component)this.putInPanel(bp), "East");
        }
        return this.symbolPanel;
    }

    private JPanel putInPanel(JComponent comp) {
        JPanel resp = new JPanel();
        resp.add(comp);
        return resp;
    }

    private JButton getBtnOpenSymbolLevelsEditor() {
        if (this.btnOpenSymbolLevelsEditor == null) {
            this.btnOpenSymbolLevelsEditor = new JButton(PluginServices.getText((Object)this, (String)"symbol_levels"));
            this.btnOpenSymbolLevelsEditor.addActionListener((ActionListener)this);
            this.btnOpenSymbolLevelsEditor.setEnabled(this.legend != null);
        }
        return this.btnOpenSymbolLevelsEditor;
    }

    private JButton getBtnOpenSymbolSelector() {
        if (this.btnOpenSymbolSelector == null) {
            this.btnOpenSymbolSelector = new JButton();
            this.btnOpenSymbolSelector.setText(PluginServices.getText((Object)this, (String)"choose_symbol"));
            this.btnOpenSymbolSelector.addActionListener((ActionListener)this);
        }
        return this.btnOpenSymbolSelector;
    }

    private SymbolPreviewer getSymbolPreviewPanel() {
        if (this.symbolPreviewComponent == null) {
            this.symbolPreviewComponent = new SymbolPreviewer(this.getSampleFeature());
            this.symbolPreviewComponent.setBorder(BorderFactory.createBevelBorder(1));
            this.symbolPreviewComponent.setPreferredSize(new Dimension(150, 75));
        }
        return this.symbolPreviewComponent;
    }

    private GridBagLayoutPanel getLegendPanel() {
        if (this.legendPanel == null) {
            this.legendPanel = new GridBagLayoutPanel();
            this.legendPanel.setBorder((Border)BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"legend"), 0, 0, null, null));
            this.txtLabel = new JTextField(25);
            this.legendPanel.addComponent(PluginServices.getText((Object)this, (String)"label_text_in_the_TOC") + ":", (Component)this.txtLabel);
            this.txtLabel.addActionListener(this);
            this.chkDrawSymbolInEachPrimitive = new JCheckBox();
            this.legendPanel.addComponent(PluginServices.getText((Object)this, (String)"_Draw_symbol_for_each_primitive_geometry") + ":", (Component)this.chkDrawSymbolInEachPrimitive);
            this.chkDrawSymbolInEachPrimitive.setSelected(true);
            this.chkDrawSymbolInEachPrimitive.addActionListener(this);
        }
        return this.legendPanel;
    }

    public void setShapeType(int shapeType) {
        this.shapeType = shapeType;
    }

    public void setSymbol(ISymbol symbol) {
        this.getSymbolPreviewPanel().setSymbol(symbol);
        if (symbol.getDescription() != null) {
            this.txtLabel.setText(symbol.getDescription());
        }
        if (this.legend != null) {
            this.legend.setDefaultSymbol(symbol);
        }
    }

    private void setOnlySymbol(ISymbol symbol) {
        this.getSymbolPreviewPanel().setSymbol(symbol);
        if (this.legend != null) {
            this.legend.setDefaultSymbol(symbol);
        }
    }

    public ISymbol getSymbol() {
        ISymbol symbol = this.getSymbolPreviewPanel().getSymbol();
        symbol.setDescription(this.txtLabel.getText());
        return symbol;
    }

    public boolean isSuitableFor(FLayer layer) {
        return layer instanceof FLyrVect;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        if (c.equals(this.getBtnOpenSymbolSelector())) {
            ISymbolSelector se = SymbolSelector.createSymbolSelector((Object)this.getSymbol(), (int)this.shapeType);
            se.setFeatureStore(this.featureStore);
            PluginServices.getMDIManager().addWindow((IWindow)se);
            ISymbol sym = (ISymbol)se.getSelectedObject();
            if (sym != null) {
                this.setOnlySymbol(sym);
            }
        } else if (c.equals(this.getBtnOpenSymbolLevelsEditor())) {
            if (this.legend != null) {
                ZSort myZSort = this.legend.getZSort();
                if (myZSort == null) {
                    myZSort = new ZSort((ILegend)this.legend);
                }
                SymbolLevelsWindow sl = new SymbolLevelsWindow(myZSort);
                PluginServices.getMDIManager().addWindow((IWindow)sl);
                this.zSort = sl.getZSort();
            }
        } else if (c.equals(this.txtLabel)) {
            this.getSymbolPreviewPanel().getSymbol().setDescription(this.txtLabel.getText());
        } else if (c.equals(this.chkDrawSymbolInEachPrimitive)) {
            // empty if block
        }
    }

    public void setFeatureStore(FeatureStore store) {
        this.featureStore = store;
        if (this.featureStore != null) {
            this.sampleFeature.setValue((Object)this.featureStore.getSampleFeature());
        }
    }

    public MutableObject<Feature> getSampleFeature() {
        if (this.sampleFeature == null) {
            this.sampleFeature = new MutableObject();
            if (this.featureStore != null) {
                this.sampleFeature.setValue((Object)this.featureStore.getSampleFeature());
            }
        }
        return this.sampleFeature;
    }
}

