/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.gui.SymbolCellEditor;
import org.gvsig.app.project.documents.gui.TableSymbolCellRenderer;
import org.gvsig.app.project.documents.view.legend.edition.gui.IntervalCellEditor;
import org.gvsig.app.project.documents.view.legend.edition.gui.ValueCellEditor;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.utils.swing.jtable.JTable;
import org.gvsig.utils.swing.jtable.TextFieldCellEditor;

public class SymbolTable
extends JPanel {
    private static final long serialVersionUID = -8694846716328735113L;
    public static final String VALUES_TYPE = "values";
    public static final String INTERVALS_TYPE = "intervals";
    private static final Map<String, TableCellEditor> CELL_EDITORS = new HashMap<String, TableCellEditor>();
    private final javax.swing.JTable table;
    private final String type;
    private final int shapeType;

    public SymbolTable(Component ownerComponent, String type, int shapeType) {
        this((javax.swing.JTable)new JTable(), ownerComponent, type, shapeType);
    }

    public SymbolTable(javax.swing.JTable theTable, Component ownerComponent, String type, int shapeType) {
        super(new GridLayout(1, 0));
        this.type = type;
        this.shapeType = shapeType;
        this.table = theTable;
        this.table.setModel(new MyTableModel());
        this.table.setPreferredScrollableViewportSize(new Dimension(480, 110));
        this.initializeCellEditors();
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.setUpSymbolColumn(this.table, this.table.getColumnModel().getColumn(0));
        if (CELL_EDITORS.get(type) == null) {
            throw new Error("Symbol table type not set!");
        }
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(1), CELL_EDITORS.get(this.type));
        this.setUpLabelColumn(this.table, this.table.getColumnModel().getColumn(2));
        this.add(scrollPane);
        this.table.setRowSelectionAllowed(true);
        this.table.setRowHeight(24);
    }

    public void setCellEditor(TableCellEditor cellEditor) {
        TableColumn column = this.table.getColumnModel().getColumn(1);
        column.setCellEditor(cellEditor);
    }

    private void initializeCellEditors() {
        CELL_EDITORS.put(INTERVALS_TYPE, new IntervalCellEditor());
        CELL_EDITORS.put(VALUES_TYPE, new ValueCellEditor());
    }

    public static void addNewCellEditor(String key, TableCellEditor cellEditor) {
        CELL_EDITORS.put(key, cellEditor);
    }

    public Object[] getSelectedRowElements() {
        Object[] values = new Object[3];
        MyTableModel m = (MyTableModel)this.table.getModel();
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows.length != 1) {
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            values[i] = m.getValueAt(selectedRows[0], i);
        }
        return values;
    }

    public void addRow(Object[] vector) {
        MyTableModel m = (MyTableModel)this.table.getModel();
        m.addRow(vector);
    }

    public void removeRow(Object obj) {
        MyTableModel m = (MyTableModel)this.table.getModel();
        for (int i = 0; i < m.getRowCount(); ++i) {
            if (m.getValueAt(i, 1) != null) continue;
            m.removeRow(i);
        }
    }

    public void removeSelectedRows() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        MyTableModel m = (MyTableModel)this.table.getModel();
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            m.removeRow(selectedRows[i]);
        }
    }

    public void fillTableFromSymbolList(ISymbol[] symbols, Object[] values, String[] descriptions) {
        for (int i = 0; i < symbols.length; ++i) {
            ISymbol theSymbol = symbols[i];
            if (values[i] == null) continue;
            this.addTableRecord(theSymbol, values[i], descriptions[i]);
        }
    }

    public void addTableRecord(ISymbol symbol, Object value, String description) {
        Object[] theRow = new Object[]{symbol, value, description};
        this.addRow(theRow);
    }

    public Object getFieldValue(int row, int col) {
        MyTableModel m = (MyTableModel)this.table.getModel();
        return m.getValueAt(row, col);
    }

    public int getRowCount() {
        MyTableModel m = (MyTableModel)this.table.getModel();
        return m.getRowCount();
    }

    public void removeAllItems() {
        this.table.setModel(new MyTableModel());
        this.setUpSymbolColumn(this.table, this.table.getColumnModel().getColumn(0));
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(1), CELL_EDITORS.get(this.type));
        this.setUpLabelColumn(this.table, this.table.getColumnModel().getColumn(2));
    }

    public void setUpLabelColumn(javax.swing.JTable table2, TableColumn column) {
        TextFieldCellEditor labeleditor = new TextFieldCellEditor();
        column.setCellEditor((TableCellEditor)labeleditor);
    }

    public void setUpValueColumn(javax.swing.JTable table2, TableColumn column, TableCellEditor tableCellEditor) {
        column.setCellEditor(tableCellEditor);
    }

    public void setUpSymbolColumn(javax.swing.JTable table2, TableColumn column) {
        column.setMaxWidth(100);
        column.setWidth(60);
        column.setPreferredWidth(60);
        column.setMinWidth(50);
        SymbolCellEditor symboleditor = new SymbolCellEditor(this.shapeType);
        column.setCellEditor(symboleditor);
        TableSymbolCellRenderer renderer = new TableSymbolCellRenderer(true);
        column.setCellRenderer((TableCellRenderer)renderer);
    }

    public void moveDownRows(int startPos, int endPos, int numOfElements) {
        if (startPos > endPos) {
            return;
        }
        if (startPos >= this.getRowCount() - 1) {
            return;
        }
        if (startPos == this.getRowCount() - 1) {
            return;
        }
        Object[][] values = new Object[this.getRowCount()][3];
        for (int i = 0; i < this.getRowCount(); ++i) {
            values[i][0] = this.table.getModel().getValueAt(i, 0);
            values[i][1] = this.table.getModel().getValueAt(i, 1);
            values[i][2] = this.table.getModel().getValueAt(i, 2);
        }
        Object[][] aux = new Object[numOfElements][3];
        for (int i = 0; i < numOfElements; ++i) {
            aux[numOfElements - i - 1][0] = values[startPos - i][0];
            aux[numOfElements - i - 1][1] = values[startPos - i][1];
            aux[numOfElements - i - 1][2] = values[startPos - i][2];
        }
        Object[][] targetVal = new Object[][]{{values[endPos][0], values[endPos][1], values[endPos][2]}};
        values[startPos - numOfElements + 1][0] = targetVal[0][0];
        values[startPos - numOfElements + 1][1] = targetVal[0][1];
        values[startPos - numOfElements + 1][2] = targetVal[0][2];
        for (int i = 0; i < numOfElements; ++i) {
            values[endPos - i][0] = aux[numOfElements - i - 1][0];
            values[endPos - i][1] = aux[numOfElements - i - 1][1];
            values[endPos - i][2] = aux[numOfElements - i - 1][2];
        }
        ISymbol[] symbols = new ISymbol[this.getRowCount()];
        Object[] objects = new Object[this.getRowCount()];
        String[] cads = new String[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            symbols[i] = (ISymbol)values[i][0];
            objects[i] = values[i][1];
            cads[i] = (String)values[i][2];
        }
        this.removeAllItems();
        this.fillTableFromSymbolList(symbols, objects, cads);
        this.table.addRowSelectionInterval(endPos - numOfElements + 1, endPos);
    }

    public void moveUpRows(int startPos, int endPos, int numOfElements) {
        if (startPos == 0) {
            return;
        }
        if (endPos > startPos) {
            return;
        }
        Object[][] values = new Object[this.getRowCount()][3];
        for (int i = 0; i < this.getRowCount(); ++i) {
            values[i][0] = this.table.getModel().getValueAt(i, 0);
            values[i][1] = this.table.getModel().getValueAt(i, 1);
            values[i][2] = this.table.getModel().getValueAt(i, 2);
        }
        Object[][] aux = new Object[numOfElements][3];
        for (int i = 0; i < numOfElements; ++i) {
            aux[i][0] = values[startPos + i][0];
            aux[i][1] = values[startPos + i][1];
            aux[i][2] = values[startPos + i][2];
        }
        Object[][] targetVal = new Object[][]{{values[endPos][0], values[endPos][1], values[endPos][2]}};
        values[startPos + numOfElements - 1][0] = targetVal[0][0];
        values[startPos + numOfElements - 1][1] = targetVal[0][1];
        values[startPos + numOfElements - 1][2] = targetVal[0][2];
        for (int i = 0; i < numOfElements; ++i) {
            values[endPos + i][0] = aux[i][0];
            values[endPos + i][1] = aux[i][1];
            values[endPos + i][2] = aux[i][2];
        }
        ISymbol[] symbols = new ISymbol[this.getRowCount()];
        Object[] objects = new Object[this.getRowCount()];
        String[] cads = new String[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            symbols[i] = (ISymbol)values[i][0];
            objects[i] = values[i][1];
            cads[i] = (String)values[i][2];
        }
        this.removeAllItems();
        this.fillTableFromSymbolList(symbols, objects, cads);
        this.table.addRowSelectionInterval(endPos, endPos + numOfElements - 1);
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    class MyTableModel
    extends DefaultTableModel {
        private final String[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"Simbolo"), PluginServices.getText((Object)this, (String)"Valor"), PluginServices.getText((Object)this, (String)"Etiqueta")};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return ISymbol.class;
                }
                case 1: {
                    Object value = this.getValueAt(0, c);
                    return value == null ? Object.class : value.getClass();
                }
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 2) {
                return ((ISymbol)this.getValueAt(row, 0)).getDescription();
            }
            return super.getValueAt(row, column);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 2) {
                ISymbol symbol = (ISymbol)this.getValueAt(row, 0);
                symbol.setDescription((String)aValue);
                this.setValueAt(symbol, row, 0);
            }
            super.setValueAt(aValue, row, column);
        }
    }
}

