/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.styling.JComboBoxColorScheme;
import org.gvsig.app.gui.styling.SymbolLevelsWindow;
import org.gvsig.app.project.documents.view.legend.gui.Categories;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.JSymbolPreviewButton;
import org.gvsig.app.project.documents.view.legend.gui.SymbolTable;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.ClassifiableVectorial;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ZSort;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractClassifiedVectorLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.VectorialUniqueValueLegend;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorialUniqueValue
extends JPanel
implements ILegendPanel,
ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorialUniqueValue.class);
    protected VectorialUniqueValueLegend theLegend;
    private ClassifiableVectorial layer;
    private SymbolTable symbolTable;
    protected JComboBox cmbFields;
    private JButton btnRemoveAll;
    private JButton btnRemove;
    private JCheckBox chbUseDefault = null;
    private JSymbolPreviewButton defaultSymbolPrev;
    private VectorialUniqueValueLegend auxLegend;
    private JPanel pnlCenter;
    private JButton btnOpenSymbolLevelsEditor;
    private JComboBoxColorScheme cmbColorScheme;
    private final GridBagLayoutPanel defaultSymbolPanel = new GridBagLayoutPanel();
    private final MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
    private GridBagLayoutPanel legendPanel = null;
    private JCheckBox chkDrawSymbolInEachPrimitive;

    public VectorialUniqueValue() {
        this.initComponents();
    }

    private GridBagConstraints gbc(GridBagConstraints c, int x, int y, int colspan) {
        c.fill = 2;
        c.gridwidth = colspan;
        c.gridx = x;
        c.gridy = y;
        c.ipadx = 2;
        c.ipady = 2;
        return c;
    }

    protected void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JButton btnAddAll = new JButton(i18n.getTranslation("Anadir_todos"));
        btnAddAll.setActionCommand("ADD_ALL_VALUES");
        btnAddAll.addActionListener((ActionListener)this);
        pnlButtons.add((Component)btnAddAll, this.gbc(c, 0, 0, 1));
        JButton btnAdd = new JButton(i18n.getTranslation("Anadir"));
        btnAdd.setActionCommand("ADD_VALUE");
        btnAdd.addActionListener((ActionListener)this);
        pnlButtons.add((Component)btnAdd, this.gbc(c, 1, 0, 1));
        this.btnRemoveAll = new JButton(i18n.getTranslation("Quitar_todos"));
        this.btnRemoveAll.setActionCommand("REMOVE_ALL");
        this.btnRemoveAll.addActionListener((ActionListener)this);
        pnlButtons.add((Component)this.btnRemoveAll, this.gbc(c, 2, 0, 1));
        this.btnRemove = new JButton(i18n.getTranslation("Quitar"));
        this.btnRemove.setActionCommand("REMOVE");
        this.btnRemove.addActionListener((ActionListener)this);
        pnlButtons.add((Component)this.btnRemove, this.gbc(c, 3, 0, 1));
        this.btnOpenSymbolLevelsEditor = new JButton(i18n.getTranslation("symbol_levels"));
        this.btnOpenSymbolLevelsEditor.addActionListener((ActionListener)this);
        this.btnOpenSymbolLevelsEditor.setActionCommand("OPEN_SYMBOL_LEVEL_EDITOR");
        pnlButtons.add((Component)this.btnOpenSymbolLevelsEditor, this.gbc(c, 4, 0, 1));
        this.btnOpenSymbolLevelsEditor.setEnabled(this.symbolTable != null && this.symbolTable.getRowCount() > 0);
        this.chkDrawSymbolInEachPrimitive = new JCheckBox(i18n.getTranslation("_Draw_symbol_for_each_primitive_geometry"));
        this.chkDrawSymbolInEachPrimitive.setSelected(true);
        this.chkDrawSymbolInEachPrimitive.addActionListener(this);
        this.chkDrawSymbolInEachPrimitive.setActionCommand("DRAW_SYMBOL_FOR_EACH_PRIMITIVE");
        pnlButtons.add((Component)this.chkDrawSymbolInEachPrimitive, this.gbc(c, 0, 1, 5));
        this.pnlCenter = new JPanel();
        this.pnlCenter.setLayout(new BorderLayout());
        this.cmbFields = new JComboBox();
        this.cmbFields.setActionCommand("FIELD_SELECTED");
        this.cmbFields.addActionListener(this);
        this.cmbFields.setVisible(true);
        JPanel pnlNorth = new JPanel();
        pnlNorth.setLayout(new GridLayout(0, 2));
        GridBagLayoutPanel auxPanel = new GridBagLayoutPanel();
        JLabel lblFieldClassification = new JLabel(i18n.getTranslation("Campo_de_clasificacion") + ": ");
        auxPanel.add((Component)lblFieldClassification);
        auxPanel.add((Component)this.cmbFields);
        pnlNorth.add((Component)auxPanel);
        auxPanel = new GridBagLayoutPanel();
        auxPanel.add((Component)new JLabel(i18n.getTranslation("color_scheme") + ": "));
        this.cmbColorScheme = new JComboBoxColorScheme(false);
        this.cmbColorScheme.addActionListener((ActionListener)this);
        auxPanel.add((Component)this.cmbColorScheme);
        pnlNorth.add((Component)auxPanel);
        this.defaultSymbolPanel.add((Component)this.getChbUseDefault(), null);
        pnlNorth.add((Component)this.defaultSymbolPanel);
        pnlNorth.add((Component)new JBlank(0, 30));
        this.setLayout(new BorderLayout());
        this.add((Component)pnlNorth, "North");
        this.add((Component)this.pnlCenter, "Center");
        this.add((Component)pnlButtons, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillTableValues() {
        try {
            FeatureStore elRs = ((FLyrVect)this.layer).getFeatureStore();
            String fieldName = (String)this.cmbFields.getSelectedItem();
            if (fieldName == null) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), i18n.getTranslation("no_hay_campo_seleccionado"));
                return;
            }
            this.symbolTable.removeAllItems();
            boolean numSymbols = false;
            this.auxLegend = (VectorialUniqueValueLegend)MapContextLocator.getMapContextManager().createLegend("VectorialUniqueValue");
            this.auxLegend.setShapeType(this.layer.getShapeType());
            this.auxLegend.setClassifyingFieldNames(new String[]{fieldName});
            FeatureAttributeDescriptor attr = elRs.getDefaultFeatureTypeQuietly().getAttributeDescriptor(fieldName);
            int fieldType = attr.getDataType().getType();
            this.auxLegend.setClassifyingFieldTypes(new int[]{fieldType});
            if (this.chbUseDefault.isSelected()) {
                this.auxLegend.getDefaultSymbol().setDescription("Default");
                this.auxLegend.addSymbol(null, this.auxLegend.getDefaultSymbol());
            }
            Color[] colorScheme = this.cmbColorScheme.getSelectedColors();
            Color[] colors = new Color[colorScheme.length];
            System.arraycopy(colorScheme, 0, colors, 0, colorScheme.length);
            this.auxLegend.setColorScheme(colors);
            Random rand = new Random(System.currentTimeMillis());
            FeatureSet set = null;
            DisposableIterator iterator = null;
            try {
                set = elRs.getFeatureSet();
                int count = 0;
                iterator = set.fastIterator();
                while (iterator.hasNext()) {
                    I18nManager i18n;
                    int resp;
                    Feature feature = (Feature)iterator.next();
                    Object clave = feature.get(fieldName);
                    if (clave == null || this.auxLegend.getSymbolByValue(clave) != null) continue;
                    if (count != 100 || (resp = JOptionPane.showConfirmDialog(this, (i18n = ToolsLocator.getI18nManager()).getTranslation("mas_de_100_simbolos"), i18n.getTranslation("quiere_continuar"), 0, 2)) != 1 && resp != -1) {
                        ISymbol theSymbol = this.mapContextManager.getSymbolManager().createSymbol(this.layer.getShapeType(), colorScheme[rand.nextInt(colorScheme.length)]);
                        theSymbol.setDescription(clave.toString());
                        this.auxLegend.addSymbol(clave, theSymbol);
                        ++count;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(iterator);
                DisposeUtils.disposeQuietly((Disposable)set);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)iterator);
            DisposeUtils.disposeQuietly((Disposable)set);
            Object[] values = this.auxLegend.getValues();
            String[] descriptions = new String[values.length];
            ISymbol[] symbols = new ISymbol[values.length];
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                symbols[i] = this.auxLegend.getSymbolByValue(value);
                descriptions[i] = symbols[i].getDescription();
            }
            this.symbolTable.fillTableFromSymbolList(symbols, values, descriptions);
        }
        catch (DataException e) {
            LOGGER.warn("recovering_recordset", (Throwable)e);
        }
        this.btnRemoveAll.setEnabled(true);
        this.btnRemove.setEnabled(true);
    }

    private boolean compareClassifyingFieldNames(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    private boolean compareClassifyingFieldTypes(int[] a, int[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private void fillSymbolListFromTable() {
        ISymbol legendSymbol;
        ISymbol theSymbol;
        Object clave;
        ArrayList<Object> visitedKeys = new ArrayList<Object>();
        boolean changedLegend = false;
        String fieldName = (String)this.cmbFields.getSelectedItem();
        String[] classifyingFieldNames = new String[]{fieldName};
        if (this.auxLegend != null) {
            if (!this.compareClassifyingFieldNames(classifyingFieldNames, this.auxLegend.getClassifyingFieldNames())) {
                this.auxLegend.setClassifyingFieldNames(classifyingFieldNames);
                changedLegend = true;
            }
        } else {
            this.auxLegend.setClassifyingFieldNames(classifyingFieldNames);
            changedLegend = true;
        }
        FLyrVect m = (FLyrVect)this.layer;
        try {
            int fieldType = m.getFeatureStore().getDefaultFeatureType().getAttributeDescriptor(this.cmbFields.getSelectedIndex()).getType();
            int[] nArray = new int[]{fieldType};
            if (this.auxLegend != null) {
                if (!this.compareClassifyingFieldTypes(nArray, this.auxLegend.getClassifyingFieldTypes())) {
                    this.auxLegend.setClassifyingFieldTypes(nArray);
                    changedLegend = true;
                }
            } else {
                this.auxLegend.setClassifyingFieldTypes(nArray);
                changedLegend = true;
            }
        }
        catch (DataException e) {
            LOGGER.warn("could_not_setup_legend", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.warn("could_not_setup_legend", (Throwable)e);
        }
        if (changedLegend) {
            this.auxLegend.clear();
        }
        for (int row = 0; row < this.symbolTable.getRowCount(); ++row) {
            clave = this.symbolTable.getFieldValue(row, 1);
            theSymbol = (ISymbol)this.symbolTable.getFieldValue(row, 0);
            String string = (String)this.symbolTable.getFieldValue(row, 2);
            theSymbol.setDescription(string);
            ISymbol legendSymbol2 = null;
            if (this.auxLegend != null) {
                legendSymbol2 = this.auxLegend.getSymbolByValue(clave);
            }
            if (legendSymbol2 == null || this.auxLegend.isUseDefaultSymbol() && legendSymbol2 == this.auxLegend.getDefaultSymbol()) {
                if (this.auxLegend != null) {
                    this.auxLegend.addSymbol(clave, theSymbol);
                }
            } else if (legendSymbol2 != theSymbol) {
                this.auxLegend.replace(legendSymbol2, theSymbol);
            }
            visitedKeys.add(clave);
        }
        if (this.auxLegend != null) {
            Object[] keys;
            for (Object key : keys = this.auxLegend.getValues()) {
                if (visitedKeys.contains(key)) continue;
                this.auxLegend.delSymbol(key);
            }
        }
        clave = null;
        if (this.chbUseDefault.isSelected()) {
            theSymbol = this.defaultSymbolPrev.getSymbol();
            if (theSymbol != null) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                String string = i18n.getTranslation("default");
                theSymbol.setDescription(string);
                ISymbol legendSymbol3 = null;
                if (this.auxLegend != null) {
                    legendSymbol3 = this.auxLegend.getSymbolByValue(clave);
                }
                if (legendSymbol3 == null) {
                    this.auxLegend.addSymbol(clave, theSymbol);
                } else if (legendSymbol3 != theSymbol) {
                    this.auxLegend.replace(legendSymbol3, theSymbol);
                }
            }
        } else if (this.auxLegend != null && (legendSymbol = this.auxLegend.getSymbolByValue(clave)) != null) {
            this.auxLegend.replace(legendSymbol, null);
        }
    }

    private void fillFieldNames() {
        try {
            FeatureStore rs = ((FLyrVect)this.layer).getFeatureStore();
            ArrayList<String> names = new ArrayList<String>();
            for (FeatureAttributeDescriptor descriptor : rs.getDefaultFeatureType()) {
                Class fieldClass = descriptor.getDataType().getDefaultClass();
                if (!Comparable.class.isAssignableFrom(fieldClass)) continue;
                names.add(descriptor.getName());
            }
            DefaultComboBoxModel<String> cM = new DefaultComboBoxModel<String>(names.toArray(new String[0]));
            this.cmbFields.setModel(cM);
        }
        catch (DataException e) {
            LOGGER.warn("recovering_recordset", (Throwable)e);
        }
    }

    public void setData(FLayer layer, ILegend legend) {
        this.layer = (ClassifiableVectorial)layer;
        int shapeType = 0;
        try {
            shapeType = this.layer.getShapeType();
        }
        catch (ReadException e) {
            LOGGER.warn("generating_intervals", (Throwable)e);
        }
        this.getDefaultSymbolPrev(shapeType);
        if (this.symbolTable != null) {
            this.pnlCenter.remove(this.symbolTable);
        }
        this.symbolTable = new SymbolTable(this, "values", shapeType);
        this.pnlCenter.add((Component)this.symbolTable, "Center");
        this.fillFieldNames();
        this.symbolTable.removeAllItems();
        if (VectorialUniqueValueLegend.class.equals(legend.getClass())) {
            this.auxLegend = (VectorialUniqueValueLegend)legend.cloneLegend();
            this.getChbUseDefault().setSelected(this.auxLegend.isUseDefaultSymbol());
            this.cmbFields.getModel().setSelectedItem(this.auxLegend.getClassifyingFieldNames()[0]);
            this.setColorScheme();
            Object[] values = this.auxLegend.getValues();
            String[] descriptions = new String[values.length];
            ISymbol[] symbols = new ISymbol[values.length];
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                symbols[i] = this.auxLegend.getSymbolByValue(value);
                descriptions[i] = symbols[i].getDescription();
            }
            this.symbolTable.fillTableFromSymbolList(symbols, values, descriptions);
            this.chbUseDefault.setSelected(this.auxLegend.isUseDefaultSymbol());
        } else {
            this.auxLegend = new VectorialUniqueValueLegend(shapeType);
        }
        this.defaultSymbolPrev.setSymbol(this.auxLegend.getDefaultSymbol());
        this.btnOpenSymbolLevelsEditor.setEnabled(this.symbolTable != null && this.symbolTable.getRowCount() > 0);
    }

    private void setColorScheme() {
        if (this.auxLegend.getColorScheme() != null) {
            Color[] colorScheme = this.auxLegend.getColorScheme();
            this.cmbColorScheme.setSelectedColors(colorScheme);
        }
    }

    private void getDefaultSymbolPrev(int shapeType) {
        if (this.defaultSymbolPrev == null) {
            this.defaultSymbolPrev = new JSymbolPreviewButton(shapeType);
            this.defaultSymbolPrev.setPreferredSize(new Dimension(110, 20));
            this.defaultSymbolPrev.addActionListener((ActionListener)this);
            this.defaultSymbolPanel.add((Component)this.defaultSymbolPrev, null);
        }
    }

    public ILegend getLegend() {
        this.fillSymbolListFromTable();
        if (this.auxLegend != null) {
            ISymbol defaultSymbolLegend = this.auxLegend.getDefaultSymbol();
            ISymbol symbol = this.defaultSymbolPrev.getSymbol();
            if (symbol != null && symbol != defaultSymbolLegend) {
                this.auxLegend.setDefaultSymbol(symbol);
            }
            this.auxLegend.useDefaultSymbol(this.chbUseDefault.isSelected());
            this.auxLegend.setDrawSymbolInEeachPrimitive(this.chkDrawSymbolInEachPrimitive.isSelected());
            this.theLegend = (VectorialUniqueValueLegend)this.auxLegend.cloneLegend();
            this.theLegend.setZSort(this.auxLegend.getZSort());
        }
        return this.theLegend;
    }

    private JCheckBox getChbUseDefault() {
        if (this.chbUseDefault == null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.chbUseDefault = new JCheckBox();
            this.chbUseDefault.setSelected(false);
            this.chbUseDefault.addActionListener(e -> {
                if (this.chbUseDefault.isSelected()) {
                    this.auxLegend.useDefaultSymbol(true);
                } else {
                    this.auxLegend.useDefaultSymbol(false);
                }
            });
            this.chbUseDefault.setText(i18n.getTranslation("resto_valores") + ": ");
        }
        return this.chbUseDefault;
    }

    private void addDefault() {
        this.auxLegend.getDefaultSymbol().setDescription("Default");
        this.auxLegend.addSymbol(null, this.auxLegend.getDefaultSymbol());
        this.symbolTable.addTableRecord(this.auxLegend.getDefaultSymbol(), null, this.auxLegend.getDefaultSymbol().getDescription());
        this.symbolTable.repaint();
    }

    private void delDefault() {
        this.auxLegend.delSymbol(null);
        this.symbolTable.removeRow(null);
        this.symbolTable.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("FIELD_SELECTED".equals(e.getActionCommand())) {
            JComboBox cb = (JComboBox)e.getSource();
            String fieldName = (String)cb.getSelectedItem();
            this.symbolTable.removeAllItems();
            this.btnOpenSymbolLevelsEditor.setEnabled(false);
        }
        if ("ADD_ALL_VALUES".equals(e.getActionCommand())) {
            this.fillTableValues();
            this.btnOpenSymbolLevelsEditor.setEnabled(this.symbolTable != null && this.symbolTable.getRowCount() > 0);
        }
        if ("ADD_VALUE".equals(e.getActionCommand())) {
            try {
                ISymbol symbol = this.mapContextManager.getSymbolManager().createSymbol(this.layer.getShapeType());
                Double clave = 0.0;
                this.symbolTable.addTableRecord(symbol, clave, "0 - 0");
                this.btnOpenSymbolLevelsEditor.setEnabled(true);
            }
            catch (ReadException ex) {
                LOGGER.warn("getting_shape_type", (Throwable)ex);
            }
        }
        if ("REMOVE_ALL".equals(e.getActionCommand())) {
            this.symbolTable.removeAllItems();
            this.auxLegend.setZSort(null);
            this.btnOpenSymbolLevelsEditor.setEnabled(false);
        }
        if ("REMOVE".equals(e.getActionCommand())) {
            this.symbolTable.removeSelectedRows();
            this.btnOpenSymbolLevelsEditor.setEnabled(this.symbolTable.getRowCount() > 0);
        }
        if ("OPEN_SYMBOL_LEVEL_EDITOR".equals(e.getActionCommand())) {
            ZSort myZSort = null;
            if (this.auxLegend != null && (myZSort = ((AbstractClassifiedVectorLegend)this.getLegend()).getZSort()) == null) {
                myZSort = new ZSort((ILegend)this.auxLegend);
            }
            if (myZSort == null && this.theLegend != null) {
                myZSort = new ZSort((ILegend)this.theLegend);
            }
            SymbolLevelsWindow sl = new SymbolLevelsWindow(myZSort);
            PluginServices.getMDIManager().addWindow((IWindow)sl);
            this.auxLegend.setZSort(sl.getZSort());
        }
    }

    public String getDescription() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("Dado_un_campo_de_atributos") + "," + i18n.getTranslation("muestra_los_elementos_de_la_capa_usando_un_simbolo_por_cada_valor_unico") + ".";
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"legend-overview-vectorial-unique-value");
    }

    public Class getParentClass() {
        return Categories.class;
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("Valores_unicos");
    }

    public JPanel getPanel() {
        return this;
    }

    public Class getLegendClass() {
        return VectorialUniqueValueLegend.class;
    }

    public boolean isSuitableFor(FLayer layer) {
        return layer instanceof FLyrVect;
    }

    private GridBagLayoutPanel getLegendPanel() {
        if (this.legendPanel == null) {
            this.legendPanel = new GridBagLayoutPanel();
            this.legendPanel.setBorder((Border)BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"legend"), 0, 0, null, null));
            this.chkDrawSymbolInEachPrimitive = new JCheckBox();
            this.legendPanel.addComponent(PluginServices.getText((Object)this, (String)"_Draw_symbol_for_each_primitive_geometry") + ":", (Component)this.chkDrawSymbolInEachPrimitive);
            this.chkDrawSymbolInEachPrimitive.setSelected(true);
            this.chkDrawSymbolInEachPrimitive.addActionListener(this);
        }
        return this.legendPanel;
    }
}

