/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.actions;

import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.gui.ChangeName;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.operations.LayerCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayersGroupTocMenuEntry
extends AbstractTocContextMenuAction {
    private static Logger logger = LoggerFactory.getLogger(LayersGroupTocMenuEntry.class);

    @Override
    public String getGroup() {
        return "group4";
    }

    @Override
    public int getGroupOrder() {
        return 40;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public String getText() {
        return PluginServices.getText((Object)this, (String)"agrupar_capas");
    }

    @Override
    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        return selectedItems.length > 1;
    }

    @Override
    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems.length < 2) {
            return false;
        }
        FLayers parent = selectedItems[0].getParentLayer();
        for (int i = 1; i < selectedItems.length; ++i) {
            if (parent == selectedItems[i].getParentLayer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void execute(ITocItem item, FLayer[] selectedItems) {
        ChangeName changename = new ChangeName(null);
        PluginServices.getMDIManager().addWindow((IWindow)changename);
        if (!changename.isAccepted()) {
            return;
        }
        String nombre = changename.getName();
        if (nombre != null) {
            this.getMapContext().beginAtomicEvent();
            FLayers parent = selectedItems[0].getParentLayer();
            FLayers newGroup = this.getMapContext().getNewGroupLayer(parent);
            newGroup.setProjection(this.getMapContext().getProjection());
            newGroup.setName(nombre);
            int pos = 0;
            for (int i = 0; i < parent.getLayersCount(); ++i) {
                if (!parent.getLayer(i).equals(selectedItems[0])) continue;
                pos = i;
            }
            for (int j = 0; j < selectedItems.length; ++j) {
                FLayer layer = selectedItems[j];
                parent.join(layer, (LayerCollection)newGroup);
            }
            parent.addLayer(pos, (FLayer)newGroup);
            newGroup.dispose();
            this.getMapContext().endAtomicEvent();
            this.getMapContext().invalidate();
            Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
            project.setModified(true);
        }
    }
}

