/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.actions;

import org.gvsig.andami.PluginServices;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomAlTemaTocMenuEntry
extends AbstractTocContextMenuAction {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(ZoomAlTemaTocMenuEntry.class);

    @Override
    public String getGroup() {
        return "group2";
    }

    @Override
    public int getGroupOrder() {
        return 20;
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public String getText() {
        return PluginServices.getText((Object)this, (String)"Zoom_a_la_capa");
    }

    @Override
    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (this.isVisible(item, selectedItems)) {
            for (FLayer selectedItem : selectedItems) {
                if (selectedItem.isAvailable()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        return this.isTocItemBranch(item) && selectedItems != null && selectedItems.length > 0;
    }

    @Override
    public void execute(ITocItem ite, FLayer[] selectedItems) {
        if (selectedItems.length == 1) {
            try {
                if (!selectedItems[0].isAvailable()) {
                    return;
                }
                this.getMapContext().zoomToEnvelope(selectedItems[0].getFullEnvelope());
            }
            catch (ReadException e1) {
                logger.warn("Can't zoom to selected layer", (Throwable)e1);
            }
        } else {
            try {
                Envelope maxExtent = this.setMaxExtent(selectedItems);
                this.getMapContext().zoomToEnvelope(maxExtent);
            }
            catch (ReadException e1) {
                logger.warn("Can't zoom to selected layer", (Throwable)e1);
            }
        }
        Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
        project.setModified(true);
    }

    private Envelope setMaxExtent(FLayer[] actives) throws ReadException {
        Envelope extRef;
        try {
            extRef = geomManager.createEnvelope(0);
        }
        catch (Exception ex) {
            logger.warn("Can't create new envelope", (Throwable)ex);
            return null;
        }
        for (FLayer active : actives) {
            if (!active.isAvailable()) continue;
            Envelope extVar = active.getFullEnvelope();
            try {
                extRef.add(extVar);
            }
            catch (Exception e) {
                logger.warn("Error creating the envelope", (Throwable)e);
            }
        }
        return extRef;
    }
}

