/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.TocItemBranch;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOCRenderer
extends JPanel
implements TreeCellRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TOCRenderer.class);
    private static final long serialVersionUID = -6733445768959238193L;
    private JCheckBox check;
    private JLabel label;
    private static int MARGIN = 100;
    private final Color editingColor;
    private final Color tocBgColor;

    public TOCRenderer(Color tocBackground) {
        this(Color.RED, tocBackground);
    }

    public TOCRenderer(Color editingColor, Color tocBackground) {
        this.editingColor = editingColor;
        this.tocBgColor = tocBackground;
        this.check = new JCheckBox();
        this.label = new JLabel();
        SpringLayout theLayout = new SpringLayout();
        this.setLayout(theLayout);
        this.add(this.check);
        this.add(this.label);
        theLayout.putConstraint("West", (Component)this.label, 5, "East", (Component)this.check);
    }

    private Dimension getNodeDimension(ITocItem item, Font font) {
        int textWidth = 0;
        int textHeight = 0;
        if (font != null && item.getLabel() != null) {
            FontMetrics metrics = this.getFontMetrics(font);
            textWidth = metrics.stringWidth(item.getLabel());
            textHeight = metrics.getHeight();
        }
        Dimension itemSize = item.getSize();
        int w = (int)Math.max((double)textWidth, itemSize.getWidth());
        int h = (int)Math.max((double)textHeight, itemSize.getHeight());
        return new Dimension(w + MARGIN, h);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)value;
        Color foreground = tree.getForeground();
        this.label.setFont(tree.getFont());
        this.label.setBackground(this.tocBgColor);
        this.setBackground(this.tocBgColor);
        if (n.getUserObject() instanceof ITocItem) {
            ITocItem item = (ITocItem)n.getUserObject();
            this.label.setText(item.getLabel());
            Icon icono = item.getIcon();
            if (icono != null) {
                this.label.setIcon(icono);
            }
            this.validate();
            Dimension sizeNode = this.getNodeDimension(item, tree.getFont());
            this.setPreferredSize(sizeNode);
            if (item instanceof TocItemBranch) {
                TocItemBranch branch = (TocItemBranch)item;
                FLyrDefault lyr = (FLyrDefault)branch.getLayer();
                this.check.setVisible(true);
                this.check.setSelected(lyr.visibleRequired());
                this.check.setBackground(this.tocBgColor);
                if (!lyr.isAvailable()) {
                    this.check.setEnabled(false);
                } else {
                    this.check.setEnabled(true);
                    try {
                        if (!lyr.isWithinScale(lyr.getMapContext().getScaleView())) {
                            this.check.setEnabled(false);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't check scale of layer " + lyr.getName(), (Throwable)ex);
                    }
                    if (lyr.isEditing()) {
                        this.label.setForeground(this.editingColor);
                    } else {
                        this.label.setForeground(foreground);
                    }
                }
                if (lyr.isActive()) {
                    this.label.setFont(this.label.getFont().deriveFont(1));
                }
            } else {
                this.check.setVisible(false);
            }
        }
        if (leaf || expanded) {
            // empty if block
        }
        return this;
    }

    public Rectangle getCheckBoxBounds() {
        return this.check.getBounds();
    }
}

