/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AbstractCircleListener;

public class CircleMeasureListener
extends AbstractCircleListener {
    private final Image img = PluginServices.getIconTheme().get("cursor-query-distance").getImage();
    private MapControl mapCtrl;

    public CircleMeasureListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    public void circle(MeasureEvent event) throws BehaviorException {
        double dist = 0.0;
        double distAll = 0.0;
        ViewPort vp = this.mapCtrl.getMapContext().getViewPort();
        for (int i = 0; i < event.getXs().length - 1; ++i) {
            dist = 0.0;
            Point2D.Double p = new Point2D.Double(event.getXs()[i], event.getYs()[i]);
            Point2D.Double p2 = new Point2D.Double(event.getXs()[i + 1], event.getYs()[i + 1]);
            dist = vp.distanceWorld((Point2D)p, (Point2D)p2);
            distAll += dist;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        if (PluginServices.getMainFrame() != null) {
            double[] trans2Meter = MapContext.getDistanceTrans2Meter();
            PluginServices.getMainFrame().getStatusBar().setMessage("4", "Dist:" + nf.format(dist / trans2Meter[this.mapCtrl.getViewPort().getDistanceUnits()]) + "");
            PluginServices.getMainFrame().getStatusBar().setMessage("5", "Total:" + nf.format(distAll / trans2Meter[this.mapCtrl.getViewPort().getDistanceUnits()]) + "");
        }
    }

    public Image getImageCursor() {
        return this.img;
    }

    public boolean cancelDrawing() {
        return false;
    }
}

