/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.cresques.cts.IProjection;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AbstractPointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.tools.evaluator.Evaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifyLayerListener
extends AbstractPointListener
implements RectangleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifyLayerListener.class);
    private final MapControl mapControl;

    public IdentifyLayerListener(MapControl mapControl) {
        this.mapControl = mapControl;
    }

    public void point(PointEvent e) throws BehaviorException {
        MouseEvent mouseEvent = e.getEvent();
        if ((mouseEvent.getModifiersEx() & 0x23C0) != 0 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        try {
            ViewPort vp = this.mapControl.getViewPort();
            Point point = vp.convertToMapPoint(e.getPoint());
            List layers = this.mapControl.getMapContext().getLayers().getLayers(t -> t != null && t.isAvailable() && t.isVisible() && t instanceof FLyrVect && ((FLyrVect)t).getFeatureStore() != null);
            Collections.reverse(layers);
            for (FLayer layer : layers) {
                FeatureQuery query;
                double tolerance = vp.toMapDistance(layer.getDefaultTolerance());
                FeatureStore store = ((FLyrVect)layer).getFeatureStore();
                Feature f = store.findFirst(query = this.createQuery((FLyrVect)layer, (Geometry)point, tolerance));
                if (f == null) continue;
                layer.setActive(true);
                application.message(layer.getName(), 1);
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't identify layer", (Throwable)ex);
        }
    }

    public void rectangle(EnvelopeEvent e) throws BehaviorException {
        MouseEvent mouseEvent = e.getEvent();
        if ((mouseEvent.getModifiersEx() & 0x23C0) != 0 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        try {
            ViewPort vp = this.mapControl.getViewPort();
            List layers = this.mapControl.getMapContext().getLayers().getLayers(t -> t != null && t.isAvailable() && t.isVisible() && t instanceof FLyrVect && ((FLyrVect)t).getFeatureStore() != null);
            Collections.reverse(layers);
            for (FLayer layer : layers) {
                Geometry geom;
                FeatureQuery query;
                double tolerance = vp.toMapDistance(layer.getDefaultTolerance());
                FeatureStore store = ((FLyrVect)layer).getFeatureStore();
                Feature f = store.findFirst(query = this.createQuery((FLyrVect)layer, geom = e.getWorldCoordRect().getGeometry(), tolerance));
                if (f == null) continue;
                this.mapControl.getMapContext().getLayers().setActive(false, true);
                layer.setActive(true);
                application.message(layer.getName(), 1);
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't identify layer", (Throwable)ex);
        }
    }

    private FeatureQuery createQuery(FLyrVect layer, Geometry geom, double tol) throws CreateGeometryException, DataException {
        GeometryManager manager = GeometryLocator.getGeometryManager();
        if (geom instanceof Point) {
            Circle circle = (Circle)manager.create(11, 0);
            circle.setPoints((Point)geom, tol);
            geom = circle;
        }
        FeatureStore featureStore = layer.getFeatureStore();
        FeatureQuery featureQuery = featureStore.createFeatureQuery();
        FeatureType featureType = featureStore.getDefaultFeatureType();
        featureQuery.setFeatureType(featureType);
        Geometry query_geo = layer.transformToSourceCRS(geom, true);
        IProjection query_proj = layer.getMapContext().getProjection();
        if (layer.getCoordTrans() != null) {
            query_proj = layer.getCoordTrans().getPOrig();
        }
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(query_geo, query_proj, featureStore);
        featureQuery.setFilter(iee);
        featureQuery.retrievesAllAttributes();
        return featureQuery;
    }
}

