/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.text.NumberFormat;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.andami.ui.mdiFrame.NewStatusBar;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.PointSelectionListener;

public class PointSelectListener
extends PointSelectionListener {
    public PointSelectListener(MapControl mapCtrl) {
        super(mapCtrl);
    }

    public void point(PointEvent event) throws BehaviorException {
        super.point(event);
        MainFrame mainFrame = ApplicationLocator.getApplicationManager().getMainFrame();
        if (mainFrame != null) {
            NewStatusBar statusbar = mainFrame.getStatusBar();
            Geometry geom = this.getSelectedGeometry();
            if (geom != null) {
                double len = -1.0;
                double area = -1.0;
                try {
                    if (GeometryUtils.isSubtype((int)3, (int)geom.getType()) || GeometryUtils.isSubtype((int)9, (int)geom.getType())) {
                        len = geom.perimeter();
                        area = geom.area();
                    } else if (GeometryUtils.isSubtype((int)2, (int)geom.getType()) || GeometryUtils.isSubtype((int)8, (int)geom.getType())) {
                        len = geom.perimeter();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                int distanceUnits = this.mapCtrl.getViewPort().getDistanceUnits();
                double trans2Meter = MapContext.getDistanceTrans2Meter()[distanceUnits];
                String distanceAbbr = MapContext.getDistanceAbbr()[distanceUnits];
                if (len > 0.0) {
                    statusbar.setMessage("4", "L=" + nf.format(len / trans2Meter) + " " + distanceAbbr);
                } else {
                    statusbar.setMessage("4", "");
                }
                if (area > 0.0) {
                    statusbar.setMessage("5", "A=" + nf.format(area / trans2Meter) + " " + distanceAbbr);
                } else {
                    statusbar.setMessage("5", "");
                }
            } else {
                statusbar.setMessage("4", "");
                statusbar.setMessage("5", "");
            }
            mainFrame.enableControls();
        }
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }
}

