/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.symboltables;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.util.UnmodifiableBasicList;
import org.gvsig.tools.util.UnmodifiableBasicListToListAdapter;

public class ListOfFeaturesWrapper
implements UnmodifiableBasicList<Object> {
    private final List<Feature> features;
    private final FeatureSymbolTable featureSymbolTable;
    private final MutableSymbolTable symbolTable;
    private final Expression expression;

    public ListOfFeaturesWrapper(List<Feature> features, SymbolTable symbolTable, String expression) {
        DataManager dataManager = DALLocator.getDataManager();
        ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getManager();
        this.features = features;
        this.featureSymbolTable = dataManager.createFeatureSymbolTable();
        this.symbolTable = this.featureSymbolTable.createParent();
        this.symbolTable.addSymbolTable(symbolTable);
        this.expression = expManager.createExpression();
        this.expression.setPhrase(expression);
    }

    private Object getValue(Feature feature) {
        this.featureSymbolTable.setFeature(feature);
        Object value = this.expression.execute((SymbolTable)this.symbolTable);
        return value;
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    public List<Object> toList() {
        UnmodifiableBasicListToListAdapter x = new UnmodifiableBasicListToListAdapter((UnmodifiableBasicList)this);
        return x;
    }

    public Object get(int position) {
        return this.getValue(this.features.get(position));
    }

    public int size() {
        return this.features.size();
    }

    public Iterator<Object> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<Object> {
        int cursor;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ListOfFeaturesWrapper.this.size();
        }

        @Override
        public Object next() {
            int i = this.cursor;
            if (i >= ListOfFeaturesWrapper.this.size()) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            return ListOfFeaturesWrapper.this.get(i);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

