/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.symboltables.functionPanels.firstlayerfeature;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.symboltables.functionPanels.firstlayerfeature.FirstLayerFeatureAditionalPanelView;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.LayersTreeModel;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class FirstLayerFeatureAditionalPanel
extends FirstLayerFeatureAditionalPanelView
implements Component {
    private final JExpressionBuilder expressionBuilder;
    private AttributeDescriptorPickerController fieldPicker;
    private AttributeDescriptorPickerController pickerFields;
    private ExpressionPickerController picketFilter;
    private FeatureSymbolTable featureSymbolTable;
    private FeatureStoreElement storeElement;

    public FirstLayerFeatureAditionalPanel(JExpressionBuilder expressionBuilder) {
        this.expressionBuilder = expressionBuilder;
        this.initComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        DataManager dataManager = DALLocator.getDataManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        ApplicationManager application = ApplicationLocator.getManager();
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtPreview);
        Project project = application.getCurrentProject();
        List<Document> views = project.getDocuments(ViewManager.TYPENAME);
        ArrayList<ListElement> views2 = new ArrayList<ListElement>();
        for (Document view : views) {
            views2.add(new ListElement(view.getName(), (Object)view));
        }
        Collections.sort(views2, new Comparator<ListElement<Document>>(){

            @Override
            public int compare(ListElement<Document> o1, ListElement<Document> o2) {
                return StringUtils.compare((String)o1.toString(), (String)o2.toString());
            }
        });
        DefaultComboBoxModel<ListElement> model = new DefaultComboBoxModel<ListElement>();
        for (ListElement element : views2) {
            model.addElement(element);
        }
        this.cboViews.setModel(model);
        this.cboViews.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FirstLayerFeatureAditionalPanel.this.doChangeView();
            }
        });
        this.cboLayers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FirstLayerFeatureAditionalPanel.this.doChangeLayer();
            }
        });
        this.pickerFields = DALSwingLocator.getSwingManager().createAttributeDescriptorPickerController(this.cboFields);
        this.pickerFields.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FirstLayerFeatureAditionalPanel.this.doChangeField();
            }
        });
        this.picketFilter = ExpressionEvaluatorSwingLocator.getManager().createExpressionPickerController((JTextComponent)this.txtFilter, this.btnFilter);
        this.cboViews.setSelectedIndex(0);
        this.doChangeView();
        this.btnInsertFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstLayerFeatureAditionalPanel.this.doInsertFunction();
            }
        });
        this.featureSymbolTable = dataManager.createFeatureSymbolTable();
        this.storeElement = dataSwingManager.createFeatureStoreElement();
        this.picketFilter.getConfig().addElement((Element)this.storeElement);
    }

    private void doChangeView() {
        ViewDocument viewdoc = (ViewDocument)ListElement.getSelected((JComboBox)this.cboViews);
        if (viewdoc == null) {
            this.cboLayers.setEnabled(false);
            this.pickerFields.setEnabled(false);
            return;
        }
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        LayersTreeModel layerTreeModel = new LayersTreeModel(viewdoc.getMapContext().getLayers());
        toolsSwingManager.setTreeModel(this.cboLayers, (TreeModel)layerTreeModel);
        this.cboLayers.setEnabled(true);
        this.cboLayers.setSelectedIndex(0);
        this.doChangeLayer();
    }

    private void doChangeLayer() {
        FLayer layer = (FLayer)ListElement.getSelected((JComboBox)this.cboLayers);
        if (layer == null) {
            this.pickerFields.setEnabled(false);
            return;
        }
        if (!(layer instanceof FLyrVect)) {
            this.pickerFields.setEnabled(false);
            return;
        }
        FeatureStore store = ((FLyrVect)layer).getFeatureStore();
        try {
            this.pickerFields.setFeatureType(store.getDefaultFeatureType());
            this.pickerFields.setEnabled(true);
        }
        catch (DataException dataException) {
            // empty catch block
        }
        Feature sampleFeature = null;
        try {
            sampleFeature = store.getFeatureSelection().first();
            if (sampleFeature == null) {
                sampleFeature = store.first();
            }
        }
        catch (DataException dataException) {
            // empty catch block
        }
        if (sampleFeature != null) {
            this.featureSymbolTable.setFeature(sampleFeature);
            this.picketFilter.getConfig().setPreviewSymbolTable((SymbolTable)this.featureSymbolTable.createParent());
        }
        this.storeElement.setFeatureStore(store);
    }

    private void doChangeField() {
        FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)this.pickerFields.get();
        if (descriptor == null) {
            this.txtPreview.setText("");
            return;
        }
        this.doUpdatePreview();
    }

    private void doUpdatePreview() {
    }

    private void doInsertFunction() {
        this.expressionBuilder.insertText(this.txtPreview.getText());
    }
}

