/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.symboltables.functionPanels.perimeter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.app.project.symboltables.functionPanels.perimeter.PerimeterAditionalPanelView;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ListElement;

public class PerimeterAditionalPanel
extends PerimeterAditionalPanelView
implements Component {
    private final JExpressionBuilder expressionBuilder;
    private AttributeDescriptorPickerController fieldPicker;

    public PerimeterAditionalPanel(JExpressionBuilder expressionBuilder) {
        this.expressionBuilder = expressionBuilder;
        this.initComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        this.fieldPicker = dataSwingManager.createAttributeDescriptorPickerController(this.cboFields, (Predicate)new Predicate<FeatureAttributeDescriptor>(){

            @Override
            public boolean test(FeatureAttributeDescriptor descriptor) {
                if (descriptor.getDataType().getType() != 66) {
                    return false;
                }
                GeometryType geomtype = descriptor.getGeomType();
                if (geomtype.getType() == 0) {
                    return true;
                }
                boolean isSurface = geomtype.isTypeOf(3) || geomtype.isTypeOf(9);
                return isSurface;
            }
        });
        FeatureStore store = this.getFeatureStore();
        try {
            this.fieldPicker.setFeatureType(store.getDefaultFeatureType());
        }
        catch (DataException dataException) {
            // empty catch block
        }
        String[] abbrev = MapContext.getDistanceAbbr();
        String[] names = MapContext.getDistanceNames();
        ArrayList<ListElement> elements = new ArrayList<ListElement>();
        for (int j = 0; j < names.length; ++j) {
            elements.add(new ListElement(names[j] + " (" + abbrev[j] + ")", (Object)abbrev[j]));
        }
        Collections.sort(elements, new Comparator<ListElement<String>>(){

            @Override
            public int compare(ListElement<String> o1, ListElement<String> o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        DefaultListModel<ListElement> unitsModel = new DefaultListModel<ListElement>();
        for (ListElement element : elements) {
            unitsModel.addElement(element);
        }
        this.lstUnits.setModel(unitsModel);
        if (this.lstUnits.getModel().getSize() > 0) {
            this.lstUnits.setSelectedIndex(0);
        }
        if (this.cboFields.getModel().getSize() > 0) {
            this.cboFields.setSelectedIndex(0);
        }
        this.cboFields.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PerimeterAditionalPanel.this.doUpdatePreview();
            }
        });
        this.lstUnits.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                PerimeterAditionalPanel.this.doUpdatePreview();
            }
        });
        this.btnInsertFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerimeterAditionalPanel.this.doInsertFunction();
            }
        });
        this.doUpdatePreview();
    }

    private void doUpdatePreview() {
        FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)this.fieldPicker.get();
        String fieldName = descriptor == null ? "{{geometry}}" : descriptor.getName();
        String unitName = (String)ListElement.getSelected((JList)this.lstUnits);
        String template = "PERIMETER( " + fieldName + ", '" + unitName + "' )";
        this.txtPreview.setText(template);
        this.txtPreview.setCaretPosition(0);
    }

    private void doInsertFunction() {
        this.expressionBuilder.insertText(this.txtPreview.getText());
    }

    private FeatureStore getFeatureStore() {
        List elements = this.expressionBuilder.getConfig().getElements();
        for (Element element : elements) {
            FeatureStore store;
            if (!(element instanceof FeatureStoreElement) || (store = ((FeatureStoreElement)element).getFeatureStore()) == null) continue;
            return store;
        }
        return null;
    }
}

