/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.filesystem.swing;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import org.cresques.cts.IProjection;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.prepareAction.PrepareContext;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.FilesystemExplorerWizardPanel;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.FilesystemExplorerWizardPanelView;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.FilesystemExplorerWizardTableModel;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.FilesystemStoreParameteresCellRenderer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.TiledCellRenderer;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ChangeListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemExplorerWizardPanelController
extends FilesystemExplorerWizardPanelView
implements ChangeListenerSupport {
    private static final long serialVersionUID = -2351856603294610783L;
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemExplorerWizardPanelController.class);
    public static final String OPEN_LAYER_FILE_CHOOSER_ID = "OPEN_LAYER_FILE_CHOOSER_ID";
    private static final String DEFAULT_FILTER = "All_supported";
    protected FilesystemServerExplorer explorer;
    private ArrayList<FilesystemExplorerWizardPanel.MyFileFilter> filters;
    protected MapContext mapContext;
    protected int selectedIndex;
    private static FilesystemExplorerWizardPanel.MyFileFilter lastFilter = null;
    private boolean tabularOnly;
    private final ChangeListenerHelper changeListeners;

    public FilesystemExplorerWizardPanelController(MapContext mapContext, FilesystemServerExplorer explorer, ArrayList<FilesystemExplorerWizardPanel.MyFileFilter> filters) {
        this.mapContext = mapContext;
        this.explorer = explorer;
        this.filters = filters;
        this.selectedIndex = -1;
        this.changeListeners = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.initComponents();
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.btnAdd.setText(i18nManager.getTranslation("Anadir"));
        this.btnProperties.setText(i18nManager.getTranslation("Properties"));
        this.btnRemove.setText(i18nManager.getTranslation("Eliminar"));
        this.btnUp.setText(i18nManager.getTranslation("arriba"));
        this.btnDown.setText(i18nManager.getTranslation("abajo"));
        this.btnAdd.setToolTipText(i18nManager.getTranslation(this.btnAdd.getToolTipText()));
        this.btnProperties.setToolTipText(i18nManager.getTranslation(this.btnProperties.getToolTipText()));
        this.btnRemove.setToolTipText(i18nManager.getTranslation(this.btnRemove.getToolTipText()));
        this.btnUp.setToolTipText(i18nManager.getTranslation(this.btnUp.getToolTipText()));
        this.btnDown.setToolTipText(i18nManager.getTranslation(this.btnDown.getToolTipText()));
        this.btnChangeViewProjection.setText(i18nManager.getTranslation(this.btnChangeViewProjection.getText()));
        this.btnChangeViewProjection.setToolTipText(i18nManager.getTranslation(this.btnChangeViewProjection.getToolTipText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    private void initComponents() {
        this.btnAdd.addActionListener(e -> this.doAdd());
        this.btnProperties.addActionListener(e -> this.doOpenProperties());
        this.btnRemove.addActionListener(e -> this.doRemove());
        this.btnUp.addActionListener(e -> this.doUp());
        this.btnDown.addActionListener(e -> this.doDown());
        this.btnChangeViewProjection.addActionListener(e -> this.doChangeViewProjection());
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.tableFiles.setModel(new FilesystemExplorerWizardTableModel());
        this.tableFiles.getColumn(i18nManager.getTranslation("Fichero")).setCellRenderer(new FilesystemStoreParameteresCellRenderer(this.mapContext));
        TableColumn columnTiled = this.tableFiles.getColumn(i18nManager.getTranslation("_tiled"));
        columnTiled.setMaxWidth(80);
        columnTiled.setCellRenderer(new TiledCellRenderer());
        this.tableFiles.getSelectionModel().setSelectionMode(0);
        this.tableFiles.getSelectionModel().addListSelectionListener(e -> this.handleSelectionEvent(e));
        this.btnChangeViewProjection.setEnabled(false);
    }

    protected void updateComponents() {
        this.btnUp.setEnabled(this.selectedIndex > 0 && this.selectedIndex < this.tableFiles.getRowCount());
        this.btnDown.setEnabled(this.selectedIndex >= 0 && this.selectedIndex < this.tableFiles.getRowCount() - 1);
        this.btnProperties.setEnabled(this.selectedIndex >= 0 && this.selectedIndex < this.tableFiles.getRowCount());
        this.btnRemove.setEnabled(this.selectedIndex >= 0 && this.selectedIndex < this.tableFiles.getRowCount());
        this.updateChangeViewProjection();
    }

    protected void handleSelectionEvent(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        DefaultListSelectionModel target = (DefaultListSelectionModel)e.getSource();
        this.selectedIndex = target.getAnchorSelectionIndex();
        this.updateComponents();
    }

    protected void doAdd() {
        List<FilesystemStoreParameters> list = this.chooseFilesParameters();
        FilesystemExplorerWizardTableModel model = (FilesystemExplorerWizardTableModel)this.tableFiles.getModel();
        for (FilesystemStoreParameters filesystemStoreParameters : list) {
            model.add(filesystemStoreParameters);
            this.updateTable();
            int index = model.getRowCount() - 1;
            this.tableFiles.getSelectionModel().setSelectionInterval(index, index);
        }
        this.updateChangeViewProjection();
        this.changeListeners.fireEvent();
    }

    protected void doRemove() {
        FilesystemExplorerWizardTableModel model = (FilesystemExplorerWizardTableModel)this.tableFiles.getModel();
        if (this.selectedIndex >= 0 && this.selectedIndex < model.getRowCount()) {
            int index = this.selectedIndex;
            model.remove(index);
            this.updateTable();
            if (index > model.getRowCount() - 1) {
                index = model.getRowCount() - 1;
            }
            this.tableFiles.getSelectionModel().setSelectionInterval(index, index);
            this.updateChangeViewProjection();
            this.changeListeners.fireEvent();
        }
    }

    protected void doOpenProperties() {
        FilesystemExplorerWizardTableModel model = (FilesystemExplorerWizardTableModel)this.tableFiles.getModel();
        if (this.selectedIndex >= 0 && this.selectedIndex < model.getRowCount()) {
            int index = this.selectedIndex;
            FilesystemStoreParameters parameters = model.getParams(index);
            this.showPropertiesDialog((DynObject)parameters);
            this.updateTable();
            this.tableFiles.getSelectionModel().setSelectionInterval(index, index);
            this.updateChangeViewProjection();
        }
    }

    protected void doUp() {
        FilesystemExplorerWizardTableModel model = (FilesystemExplorerWizardTableModel)this.tableFiles.getModel();
        if (this.selectedIndex > 0 && this.selectedIndex < model.getRowCount()) {
            int index = this.selectedIndex;
            model.up(index);
            this.updateTable();
            this.tableFiles.getSelectionModel().setSelectionInterval(index - 1, index - 1);
            this.updateChangeViewProjection();
        }
    }

    protected void doDown() {
        FilesystemExplorerWizardTableModel model = (FilesystemExplorerWizardTableModel)this.tableFiles.getModel();
        if (this.selectedIndex >= 0 && this.selectedIndex < model.getRowCount() - 1) {
            int index = this.selectedIndex;
            model.down(index);
            this.updateTable();
            this.tableFiles.getSelectionModel().setSelectionInterval(index + 1, index + 1);
            this.updateChangeViewProjection();
        }
    }

    protected void showPropertiesDialog(DynObject parameters) {
        DataStoreParametersPanelManager manager = DALSwingLocator.getDataStoreParametersPanelManager();
        DataStoreParametersPanel panel = manager.createDataStoreParametersPanel(parameters);
        panel.setExcludeGeometryOptions(false);
        manager.showPropertiesDialog(parameters, panel);
    }

    private void updateTable() {
        ((FilesystemExplorerWizardTableModel)this.tableFiles.getModel()).fireTableDataChanged();
        this.updateRowHeights();
        this.tableFiles.getSelectionModel().setSelectionInterval(this.selectedIndex, this.selectedIndex);
    }

    private void updateRowHeights() {
        for (int row = 0; row < this.tableFiles.getRowCount(); ++row) {
            int rowHeight = this.tableFiles.getRowHeight();
            for (int column = 0; column < this.tableFiles.getColumnCount(); ++column) {
                Component comp = this.tableFiles.prepareRenderer(this.tableFiles.getCellRenderer(row, column), row, column);
                rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
            }
            this.tableFiles.setRowHeight(row, rowHeight);
        }
    }

    private List<FilesystemStoreParameters> chooseFilesParameters() {
        FileDialogChooserManager fileDialogChooserManager = ToolsUtilLocator.getFileDialogChooserManager();
        FileDialogChooser fileChooser = fileDialogChooserManager.create(OPEN_LAYER_FILE_CHOOSER_ID);
        fileChooser.setCurrentDirectory(fileDialogChooserManager.getLastPath(OPEN_LAYER_FILE_CHOOSER_ID, this.explorer.getCurrentPath()));
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        Iterator<FilesystemExplorerWizardPanel.MyFileFilter> iter = this.filters.iterator();
        while (iter.hasNext()) {
            fileChooser.addChoosableFileFilter((FileFilter)iter.next());
        }
        if (this.filters.size() > 0) {
            FilesystemExplorerWizardPanel.MyFileFilter firstf = this.filters.get(0);
            fileChooser.setFileFilter((FileFilter)firstf);
        }
        if (lastFilter != null && this.filters.contains(lastFilter)) {
            fileChooser.setFileFilter((FileFilter)lastFilter);
        }
        int result = fileChooser.showOpenDialog((Component)this);
        List<FilesystemStoreParameters> toAdd = new ArrayList<FilesystemStoreParameters>();
        if (result == 0) {
            lastFilter = (FilesystemExplorerWizardPanel.MyFileFilter)fileChooser.getFileFilter();
            String providerName = null;
            if (lastFilter != null && !DEFAULT_FILTER.equalsIgnoreCase(lastFilter.getDescription())) {
                providerName = lastFilter.getName();
            }
            toAdd = this.getParametersList(fileChooser.getCurrentDirectory(), fileChooser.getSelectedFiles(), providerName);
        }
        return toAdd;
    }

    private List<FilesystemStoreParameters> getParametersList(File folder, File[] files, String providerName) {
        ApplicationManager application = ApplicationLocator.getManager();
        PrepareContext context = this.getPrepareDataStoreContext();
        ArrayList<DataStoreParameters> params = new ArrayList<DataStoreParameters>();
        List<DataStoreParameters> preparedParams = null;
        ArrayList<FilesystemStoreParameters> returnParams = new ArrayList<FilesystemStoreParameters>();
        for (File aFile : files) {
            String currentProvider = providerName;
            try {
                DataStoreParameters param;
                if (folder == null) {
                    this.explorer.setCurrentPath(aFile.getParentFile());
                } else {
                    this.explorer.setCurrentPath(folder);
                }
                if (currentProvider == null) {
                    for (int i = 1; i < this.filters.size(); ++i) {
                        FilesystemExplorerWizardPanel.MyFileFilter filter = this.filters.get(i);
                        if (!filter.accept(aFile)) continue;
                        currentProvider = filter.getName();
                        break;
                    }
                }
                if (currentProvider == null || (param = this.explorer.createStoreParameters(aFile, currentProvider)) == null) continue;
                params.add(param);
            }
            catch (DataException e) {
                NotificationManager.addError((Throwable)e);
                return null;
            }
        }
        try {
            preparedParams = application.prepareOpenDataStoreParameters(params, context);
        }
        catch (Exception e) {
            NotificationManager.addError((Throwable)e);
        }
        if (preparedParams != null) {
            for (int i = 0; i < preparedParams.size(); ++i) {
                returnParams.add((FilesystemStoreParameters)preparedParams.get(i));
            }
        }
        return returnParams;
    }

    protected PrepareContext getPrepareDataStoreContext() {
        return new PrepareContext(){

            @Override
            public IProjection getViewProjection() {
                return FilesystemExplorerWizardPanelController.this.mapContext.getProjection();
            }

            @Override
            public Window getOwnerWindow() {
                return null;
            }
        };
    }

    public DataStoreParameters[] getParameters() {
        return ((FilesystemExplorerWizardTableModel)this.tableFiles.getModel()).getParameters();
    }

    public void addFiles(List<File> files) {
        File[] filesArray = files.toArray(new File[files.size()]);
        this.addFilesFromParameters(this.getParametersList(null, filesArray, null));
    }

    private void addFilesFromParameters(List<FilesystemStoreParameters> filesParams) {
        if (filesParams.isEmpty()) {
            return;
        }
        FilesystemExplorerWizardTableModel model = (FilesystemExplorerWizardTableModel)this.tableFiles.getModel();
        model.add(filesParams);
        this.updateChangeViewProjection();
        this.changeListeners.fireEvent();
        this.updateTable();
    }

    public boolean isTiled(DataStoreParameters parameters) {
        return ((FilesystemExplorerWizardTableModel)this.tableFiles.getModel()).isTiled(parameters);
    }

    public void setExplorer(FilesystemServerExplorer explorer) {
        this.explorer = explorer;
    }

    public void setFilters(ArrayList<FilesystemExplorerWizardPanel.MyFileFilter> filters) {
        this.filters = filters;
    }

    public void dispose() {
        if (this.explorer != null) {
            this.explorer.dispose();
            this.explorer = null;
        }
        if (this.filters != null) {
            this.filters.clear();
            this.filters = null;
        }
    }

    private void updateChangeViewProjection() {
        DynObject parameters;
        if (!this.btnChangeViewProjection.isVisible()) {
            return;
        }
        FilesystemExplorerWizardTableModel model = (FilesystemExplorerWizardTableModel)this.tableFiles.getModel();
        if (this.selectedIndex < 0 || this.selectedIndex >= model.getRowCount()) {
            this.btnChangeViewProjection.setEnabled(false);
            return;
        }
        if (model.getRowCount() > 0 && (parameters = (DynObject)model.getParams(this.selectedIndex)).getDynClass().getDynField("CRS") != null) {
            IProjection projection = (IProjection)parameters.getDynValue("CRS");
            if (this.mapContext == null || this.mapContext.getLayers().isEmpty()) {
                if (projection == null) {
                    this.btnChangeViewProjection.setEnabled(false);
                } else if (projection.equals(this.mapContext.getProjection())) {
                    this.btnChangeViewProjection.setEnabled(false);
                } else {
                    for (DataStoreParameters p : model.getParameters()) {
                        String s;
                        projection = (IProjection)p.getDynValue("CRS");
                        if (projection == null || !(s = projection.getFullCode()).contains("@")) continue;
                        this.btnChangeViewProjection.setEnabled(false);
                        return;
                    }
                    this.btnChangeViewProjection.setEnabled(true);
                }
            }
        }
    }

    private void doChangeViewProjection() {
        FilesystemExplorerWizardTableModel model = (FilesystemExplorerWizardTableModel)this.tableFiles.getModel();
        if (model.getRowCount() <= 0 || this.selectedIndex < 0 && this.selectedIndex >= model.getRowCount()) {
            this.btnChangeViewProjection.setEnabled(false);
            return;
        }
        DynObject parameters = (DynObject)model.getParams(this.selectedIndex);
        if (parameters.getDynClass().getDynField("CRS") != null) {
            IProjection projection = (IProjection)parameters.getDynValue("CRS");
            if (this.mapContext == null || this.mapContext.getLayers().isEmpty()) {
                this.mapContext.setProjection(projection);
                this.updateTable();
            }
        }
    }

    void setTabularOnly(boolean tabularOnly) {
        this.tabularOnly = tabularOnly;
        this.btnChangeViewProjection.setVisible(!tabularOnly);
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.removeChangeListener(cl);
    }

    public void removeAllChangeListener() {
        this.changeListeners.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListeners.hasChangeListeners();
    }
}

