/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.prov.jdbc.panels;

import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.newlayer.NewLayerProviderPanel;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.prov.jdbc.NewLayerJDBCProviderParameters;
import org.gvsig.newlayer.prov.jdbc.panels.PostCreatingStatementPanelLayout;
import org.gvsig.newlayer.spi.NewLayerPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class PostCreatingStatementPanel
extends PostCreatingStatementPanelLayout
implements NewLayerProviderPanel {
    private final NewLayerJDBCProviderParameters parameters;
    private final NewLayerWizard wizard;

    public PostCreatingStatementPanel(NewLayerWizard wizard, NewLayerJDBCProviderParameters parameters) {
        this.parameters = parameters;
        this.wizard = wizard;
        this.initComponents();
    }

    private void initComponents() {
        this.chkUsePostCreatingStatement.setEnabled(true);
        this.chkUsePostCreatingStatement.setSelected(false);
        this.txtPostCreatingStatement.setText("");
        this.txtPostCreatingStatement.setEnabled(false);
        this.chkUsePostCreatingStatement.addActionListener(ae -> this.doChangeUsePostCreatingStatement());
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblHeader.setText("<html>" + i18nManager.getTranslation("_Post_creating_statement_header") + "</html>");
        this.chkUsePostCreatingStatement.setText(i18nManager.getTranslation("_Introducir_sentencia_a_ejecutar_tras_la_creacion_de_la_tabla"));
    }

    protected void doChangeUsePostCreatingStatement() {
        this.txtPostCreatingStatement.setEnabled(this.chkUsePostCreatingStatement.isSelected());
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Post_creating_statement");
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setPostCreatingStatement(this.getPostCreatingStatement());
    }

    public boolean validatePanel() throws NewLayerPanelValidationException {
        return true;
    }

    public void enterPanel() {
        this.chkUsePostCreatingStatement.setEnabled(true);
        if (this.parameters.getPostCreatingStatement() != null) {
            String statement = this.parameters.getPostCreatingStatement();
            this.chkUsePostCreatingStatement.setSelected(true);
            this.txtPostCreatingStatement.setText(statement);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getPostCreatingStatement() {
        if (this.chkUsePostCreatingStatement.isEnabled()) {
            String stmt = this.txtPostCreatingStatement.getText();
            if (StringUtils.isBlank((CharSequence)stmt)) {
                return null;
            }
            return stmt.trim();
        }
        return null;
    }
}

