/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.prov.jdbc.panels;

import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.newlayer.NewLayerProviderPanel;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.prov.jdbc.NewLayerJDBCProviderParameters;
import org.gvsig.newlayer.prov.jdbc.panels.SelectTableNamePanelLayout;
import org.gvsig.newlayer.spi.NewLayerPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTableNamePanel
extends SelectTableNamePanelLayout
implements NewLayerProviderPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectTableNamePanel.class);
    private final NewLayerJDBCProviderParameters parameters;
    private final NewLayerWizard wizard;
    private SQLBuilder sqlbuilder;

    public SelectTableNamePanel(NewLayerWizard wizard, NewLayerJDBCProviderParameters parameters) {
        this.parameters = parameters;
        this.wizard = wizard;
        this.initComponents();
    }

    private void initComponents() {
        try {
            this.txtTableName.setText(this.parameters.getTableName());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't set the default value for the table name", (Throwable)ex);
        }
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblHeader.setText(i18nManager.getTranslation("_Indique_donde_desea_insertar_los_datos"));
        this.lblSchema.setText(i18nManager.getTranslation("_Indique_el_esquema_en_el_que_desea_crear_la_tabla"));
        this.lblTableName.setText(i18nManager.getTranslation("_Indique_el_nombre_de_la_tabla"));
    }

    public String getSchema() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.txtSchema.getText(), null);
    }

    public String getTableName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.txtTableName.getText(), null);
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Tablename");
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setSchema(this.getSchema());
        this.parameters.setTableName(this.getTableName());
    }

    public boolean validatePanel() throws NewLayerPanelValidationException {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        String tablename = this.getTableName();
        if (tablename == null) {
            throw new NewLayerPanelValidationException(i18nManager.getTranslation("_The_name_of_table_cannot_be_empty"));
        }
        String schema = this.getSchema();
        if (this.sqlbuilder.support_schemas() && schema == null) {
            throw new NewLayerPanelValidationException(i18nManager.getTranslation("_The_name_of_schema_cannot_be_empty"));
        }
        this.parameters.setSchema(schema);
        this.parameters.setTableName(tablename);
        return true;
    }

    public void enterPanel() {
        JDBCServerExplorerParameters explorerParameters = this.parameters.getExplorerParameters();
        if (explorerParameters == null) {
            this.wizard.setButtonEnabled(1, false);
            return;
        }
        this.wizard.setButtonEnabled(1, true);
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParameters.getExplorerName(), (DataServerExplorerParameters)explorerParameters);
            this.sqlbuilder = explorer.createSQLBuilder();
            if (this.getSchema() == null) {
                this.txtSchema.setText(this.sqlbuilder.default_schema());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve the sqlbuilder", ex);
        }
        if (this.parameters.getSchema() != null) {
            this.txtSchema.setText(this.parameters.getSchema());
            this.txtTableName.setText(this.parameters.getTableName());
        }
    }

    public JComponent asJComponent() {
        return this;
    }
}

