/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.app.rotate;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.legend.picturemarkersymboltable.lib.api.PictureMarkerSymbolTableLegend;
import org.gvsig.legend.urbanhorizontalsignage.app.rotate.RotatePointListener;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatePointBehavior
extends Behavior {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RotatePointBehavior.class);
    protected RotatePointListener listener;
    private double angle;
    private Point2D currentPoint;
    private Point2D centerPoint;
    private IMarkerSymbol symbol;
    private Feature feature;
    private String layerName;
    private PictureMarkerSymbolTableLegend legend;

    public RotatePointBehavior(RotatePointListener listener) {
        this.listener = listener;
    }

    public void setMapControl(MapControl mc) {
        super.setMapControl(mc);
        this.updateCurrentValues();
    }

    public void paintComponent(MapControlDrawer drawer) {
        if (this.feature == null || this.symbol == null || this.currentPoint == null) {
            return;
        }
        Geometry geom = this.feature.getDefaultGeometry();
        if (geom == null) {
            return;
        }
        this.symbol.setRotation(this.angle);
        drawer.draw(geom, (ISymbol)this.symbol);
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        double d = this.distance(this.centerPoint, this.currentPoint);
        drawer.drawLine((int)this.centerPoint.getX(), (int)this.centerPoint.getY(), (int)this.currentPoint.getX(), (int)this.currentPoint.getY());
        drawer.drawLine((int)this.centerPoint.getX(), (int)this.centerPoint.getY(), (int)(this.centerPoint.getX() + d), (int)this.centerPoint.getY());
    }

    private void updateCurrentValues() {
        this.angle = 0.0;
        this.centerPoint = null;
        this.currentPoint = null;
        this.feature = null;
        this.layerName = null;
        this.legend = null;
        this.symbol = null;
        try {
            FLayer[] layers = this.getMapControl().getMapContext().getLayers().getActives();
            if (layers == null || layers.length != 1) {
                return;
            }
            FLyrVect layer = (FLyrVect)layers[0];
            FeatureSelection selection = layer.getFeatureStore().getFeatureSelection();
            this.feature = selection.first();
            if (this.symbol == null && this.feature != null) {
                this.legend = (PictureMarkerSymbolTableLegend)layer.getLegend();
                this.symbol = (IMarkerSymbol)this.legend.getSymbolByFeature(this.feature);
            }
            Point point = (Point)this.feature.getDefaultGeometry();
            ViewPort vp = this.getMapControl().getViewPort();
            this.centerPoint = vp.fromMapPoint(point.getX(), point.getY());
        }
        catch (Exception ex) {
            this.angle = 0.0;
            this.currentPoint = null;
            this.centerPoint = null;
            this.legend = null;
            this.feature = null;
            this.layerName = null;
            this.symbol = null;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) throws BehaviorException {
        if ((mouseEvent.getModifiersEx() & 0x23C0) != 0 || SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        try {
            if (mouseEvent.getClickCount() == 1) {
                this.listener.rotate(this.feature, this.legend.getRotationFieldName(), this.angle);
                return;
            }
            this.currentPoint = mouseEvent.getPoint();
            EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
            double d = this.distance(this.centerPoint, this.currentPoint);
            EuclideanLine2D line = euclideanManager.createLine2D(this.centerPoint.getX(), this.centerPoint.getY(), this.currentPoint.getX(), this.currentPoint.getY());
            this.angle = Math.toDegrees(line.getAngle());
            LOGGER.info("Angulo: " + this.angle);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't rotate from point of the layer " + this.layerName, (Throwable)ex);
        }
    }

    public void mouseDragged(MouseEvent e) throws BehaviorException {
        this.mouseMoved(e);
    }

    public void setListener(ToolListener listener) {
        this.listener = (RotatePointListener)listener;
    }

    public ToolListener getListener() {
        return this.listener;
    }

    public double distance(Point2D p1, Point2D p2) {
        double x = Math.sqrt(Math.pow(p2.getX() - p1.getX(), 2.0) + Math.pow(p2.getY() - p1.getY(), 2.0));
        return x;
    }
}

