/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing;

import java.util.Iterator;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.SelectionChangeException;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTableModel;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureSelectionModel
implements ListSelectionModel,
Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureSelectionModel.class);
    protected EventListenerList listenerList = new EventListenerList();
    protected final FeatureTableModel featureTableModel;
    private int selectionMode = 1;
    private boolean isAdjusting = false;
    private int anchor = -1;
    private int lead = -1;
    private int currentFirst = -1;
    private int currentLast = -1;
    private int minSelectionIndex = -2;
    private int maxSelectionIndex = -2;
    protected ListSelectionModel selectionModelDelegated;
    Thread task = null;

    public FeatureSelectionModel(FeatureTableModel featureTableModel) throws DataException {
        this.featureTableModel = featureTableModel;
        FeatureStore store = this.featureTableModel.getFeatureStore();
        store.addObserver((Observer)this);
        if (!store.getFeatureSelection().isAvailable()) {
            this.selectionModelDelegated = new DefaultListSelectionModel();
        }
    }

    @Override
    public int getAnchorSelectionIndex() {
        if (this.selectionModelDelegated != null) {
            return this.selectionModelDelegated.getAnchorSelectionIndex();
        }
        return this.anchor;
    }

    @Override
    public int getLeadSelectionIndex() {
        if (this.selectionModelDelegated != null) {
            return this.selectionModelDelegated.getLeadSelectionIndex();
        }
        return this.lead;
    }

    @Override
    public int getMaxSelectionIndex() {
        if (this.selectionModelDelegated != null) {
            return this.selectionModelDelegated.getMaxSelectionIndex();
        }
        if (this.maxSelectionIndex > -2) {
            return this.maxSelectionIndex;
        }
        this.refreshCache();
        return this.maxSelectionIndex;
    }

    @Override
    public int getMinSelectionIndex() {
        if (this.selectionModelDelegated != null) {
            return this.selectionModelDelegated.getMinSelectionIndex();
        }
        if (this.minSelectionIndex > -2) {
            return this.minSelectionIndex;
        }
        this.refreshCache();
        return this.minSelectionIndex;
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.insertIndexInterval(index, length, before);
            return;
        }
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.removeIndexInterval(index0, index1);
            return;
        }
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.setAnchorSelectionIndex(index);
            return;
        }
        this.anchor = index;
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.setLeadSelectionIndex(index);
            return;
        }
        this.lead = index;
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.addSelectionInterval(index0, index1);
            return;
        }
        if (this.featureTableModel.isSelectionLocked()) {
            return;
        }
        this.doWithSelection(new FeatureSelectionOperation(){

            @Override
            public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                for (int i = first; i <= last; ++i) {
                    Feature feature = FeatureSelectionModel.this.getFeature(i);
                    if (selection.isSelected(feature)) continue;
                    selection.select(feature);
                }
            }
        }, index0, index1, true);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.setSelectionInterval(index0, index1);
            return;
        }
        if (this.featureTableModel.isSelectionLocked()) {
            return;
        }
        this.doWithSelection(new FeatureSelectionOperation(){

            @Override
            public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                selection.deselectAll();
                for (int i = first; i <= last; ++i) {
                    Feature feature = FeatureSelectionModel.this.getFeature(i);
                    selection.select(feature);
                }
            }
        }, index0, index1, true);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.removeSelectionInterval(index0, index1);
            return;
        }
        if (this.featureTableModel.isSelectionLocked()) {
            return;
        }
        this.doWithSelection(new FeatureSelectionOperation(){

            @Override
            public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                for (int i = first; i <= last; ++i) {
                    Feature feature = FeatureSelectionModel.this.getFeature(i);
                    if (!selection.isSelected(feature)) continue;
                    selection.deselect(feature);
                }
            }
        }, index0, index1, false);
    }

    @Override
    public void clearSelection() {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.clearSelection();
            return;
        }
        if (this.featureTableModel.isSelectionLocked()) {
            return;
        }
        try {
            this.getFeatureSelection().deselectAll();
        }
        catch (DataException e) {
            throw new SelectionChangeException(e);
        }
    }

    @Override
    public boolean isSelectedIndex(int index) {
        try {
            if (this.selectionModelDelegated != null) {
                return this.selectionModelDelegated.isSelectedIndex(index);
            }
            if (index == -1) {
                return false;
            }
            Feature feature = this.featureTableModel.getFeatureAt(index);
            return this.getFeatureSelection().isSelected(feature);
        }
        catch (Throwable th) {
            LOGGER.warn("Cant check selection", th);
            return false;
        }
    }

    @Override
    public boolean isSelectionEmpty() {
        if (this.selectionModelDelegated != null) {
            return this.selectionModelDelegated.isSelectionEmpty();
        }
        try {
            return this.getFeatureSelection().isEmpty();
        }
        catch (Exception ex) {
            throw new SelectionChangeException(ex);
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        if (this.selectionModelDelegated != null) {
            return this.selectionModelDelegated.getValueIsAdjusting();
        }
        return this.isAdjusting;
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.setValueIsAdjusting(valueIsAdjusting);
            return;
        }
        if (this.isAdjusting != valueIsAdjusting) {
            this.isAdjusting = valueIsAdjusting;
            if (this.isAdjusting) {
                this.getFeatureSelection().beginComplexNotification();
            } else {
                this.getFeatureSelection().endComplexNotification();
            }
        }
    }

    @Override
    public int getSelectionMode() {
        if (this.selectionModelDelegated != null) {
            return this.selectionModelDelegated.getSelectionMode();
        }
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.setSelectionMode(selectionMode);
            return;
        }
        this.selectionMode = selectionMode;
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.addListSelectionListener(listener);
            return;
        }
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        if (this.selectionModelDelegated != null) {
            this.selectionModelDelegated.removeListSelectionListener(listener);
            return;
        }
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof FeatureStoreNotification) {
            FeatureStoreNotification fnotification = (FeatureStoreNotification)notification;
            if (!fnotification.getSource().equals(this.getFeatureStore())) {
                return;
            }
            if ("after_SelectionChange_DataStore".equals(fnotification.getType())) {
                try {
                    this.fireValueChanged(-1, -1, false);
                }
                catch (ConcurrentDataModificationException e) {
                    LOGGER.warn("The store has been updated and the selection can not be refreshed", (Throwable)e);
                }
            }
        }
    }

    private FeatureSelection getFeatureSelection() {
        try {
            return (FeatureSelection)this.getFeatureStore().getSelection();
        }
        catch (DataException ex) {
            throw new SelectionChangeException(ex);
        }
    }

    public Iterator<Feature> getSelectedFeaturesIterator() throws DataException {
        return this.getFeatureStore().getFeaturesIterator(this.getFeatureStore().getFeatureSelection().referenceIterator());
    }

    public Iterable<Feature> getSelectedFeatures() throws DataException {
        return this.getFeatureStore().getFeaturesIterable(this.getFeatureStore().getFeatureSelection().referenceIterator());
    }

    protected void doWithSelection(FeatureSelectionOperation operation, int index0, int index1, boolean select) {
        int last;
        this.anchor = index0;
        this.lead = index1;
        int first = index0 <= index1 ? index0 : index1;
        int n = last = index0 <= index1 ? index1 : index0;
        if (this.currentFirst == first && this.currentLast == last) {
            return;
        }
        int oldFirst = this.currentFirst;
        int oldLast = this.currentLast;
        this.currentFirst = first;
        this.currentLast = last;
        FeatureSelection selection = this.getFeatureSelection();
        selection.beginComplexNotification();
        try {
            if (first == 0 && last == this.featureTableModel.getRowCount() - 1) {
                if (select) {
                    selection.selectAll();
                } else {
                    selection.deselectAll();
                }
            } else {
                operation.doWithSelection(selection, first, last);
            }
        }
        catch (DataException e) {
            throw new SelectionChangeException(e);
        }
        finally {
            selection.endComplexNotification();
        }
        if (oldFirst <= first) {
            if (oldLast < first) {
                this.fireValueChanged(oldFirst, oldLast, this.isAdjusting);
                this.fireValueChanged(first, last, this.isAdjusting);
            } else if (last > oldLast) {
                this.fireValueChanged(oldFirst, last, this.isAdjusting);
            } else {
                this.fireValueChanged(oldFirst, oldLast, this.isAdjusting);
            }
        }
        if (first <= oldFirst) {
            if (last < oldFirst) {
                this.fireValueChanged(oldFirst, oldLast, this.isAdjusting);
                this.fireValueChanged(first, last, this.isAdjusting);
            } else if (last > oldLast) {
                this.fireValueChanged(first, last, this.isAdjusting);
            } else {
                this.fireValueChanged(first, oldLast, this.isAdjusting);
            }
        }
    }

    protected Feature getFeature(int index) {
        return this.featureTableModel.getFeatureAt(index);
    }

    private FeatureStore getFeatureStore() {
        return this.featureTableModel.getFeatureStore();
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null) {
                e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    private int getSelectionIndex(boolean last) {
        int resp;
        block8: {
            int ind = -1;
            resp = -1;
            FeatureSet fs = null;
            DisposableIterator diter = null;
            try {
                FeatureSelection selection = this.getFeatureSelection();
                if (selection.isEmpty()) break block8;
                FeatureStore store = this.getFeatureStore();
                FeatureQuery query = store.createFeatureQuery();
                query.addEssentialAttributeNames(store);
                fs = store.getFeatureSet(query);
                diter = fs.fastIterator();
                while (diter.hasNext()) {
                    ++ind;
                    Feature feat = (Feature)diter.next();
                    if (!selection.isSelected(feat)) continue;
                    resp = ind;
                    if (last) continue;
                    break;
                }
            }
            catch (DataException e) {
                throw new SelectionChangeException(e);
            }
            finally {
                if (diter != null) {
                    diter.dispose();
                }
                if (fs != null) {
                    fs.dispose();
                }
            }
        }
        return resp;
    }

    public void clearCache() {
        this.minSelectionIndex = -2;
        this.maxSelectionIndex = -2;
    }

    private synchronized void refreshCache() {
        if (this.task != null) {
            return;
        }
        this.task = new Thread(new Runnable(){

            @Override
            public void run() {
                int ind = -1;
                int count = -1;
                int minIndex = -1;
                int maxIndex = -1;
                FeatureSet fs = null;
                DisposableIterator diter = null;
                try {
                    FeatureSelection selection = FeatureSelectionModel.this.getFeatureSelection();
                    if (selection.isEmpty()) {
                        minIndex = -1;
                        maxIndex = -1;
                    }
                    FeatureStore store = FeatureSelectionModel.this.getFeatureStore();
                    FeatureQuery query = FeatureSelectionModel.this.featureTableModel.getHelper().getFeatureQuery();
                    if (query != null) {
                        query = query.getCopy();
                        query.addEssentialAttributeNames(store);
                    }
                    fs = store.getFeatureSet(query);
                    diter = fs.fastIterator();
                    count = 0;
                    int selectedCount = (int)selection.getSize();
                    while (diter.hasNext()) {
                        ++ind;
                        Feature feat = (Feature)diter.next();
                        if (!selection.isSelected(feat)) continue;
                        if (minIndex < 0) {
                            minIndex = ind;
                        }
                        maxIndex = ind;
                        if (++count < selectedCount) continue;
                    }
                    FeatureSelectionModel.this.minSelectionIndex = minIndex;
                    FeatureSelectionModel.this.maxSelectionIndex = maxIndex;
                }
                catch (DataException e) {
                    throw new SelectionChangeException(e);
                }
                finally {
                    if (diter != null) {
                        diter.dispose();
                    }
                    if (fs != null) {
                        fs.dispose();
                    }
                    FeatureSelectionModel.this.task = null;
                }
            }
        }, "ResfreshCache");
        this.task.run();
    }

    protected static interface FeatureSelectionOperation {
        public void doWithSelection(FeatureSelection var1, int var2, int var3) throws DataException;
    }
}

