/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTableModel;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableFeatureTableModel
extends FeatureTableModel {
    private static final long serialVersionUID = -8223987814719746492L;
    private static final Logger logger = LoggerFactory.getLogger(ConfigurableFeatureTableModel.class);
    private List<String> columnNames;
    private List<String> visibleColumnNames;
    private List<String> visibleColumnNamesOriginal;
    private Map<String, String> name2Alias;
    private Map<String, String> name2AliasOriginal;
    private Map<String, String> patterns = null;
    private Locale localeOfData;

    public ConfigurableFeatureTableModel(FeatureStore featureStore, FeatureQuery featureQuery) throws BaseException {
        super(featureStore, featureQuery);
        this.localeOfData = Locale.getDefault();
    }

    public ConfigurableFeatureTableModel(FeatureStore featureStore, FeatureQuery featureQuery, int pageSize) throws BaseException {
        super(featureStore, featureQuery, pageSize);
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnNames.size();
    }

    public int getOriginalColumnCount() {
        return super.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        try {
            int originalIndex = this.getOriginalColumnIndex(column);
            return this.getAliasForColumn(this.getOriginalColumnName(originalIndex));
        }
        catch (Exception ex) {
            return "C" + column;
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        int originalIndex = this.getOriginalColumnIndex(columnIndex);
        return super.getColumnClass(originalIndex);
    }

    @Override
    public FeatureAttributeDescriptor getDescriptorForColumn(int columnIndex) {
        int originalIndex = this.getOriginalColumnIndex(columnIndex);
        return super.getDescriptorForColumn(originalIndex);
    }

    public String getOriginalColumnName(int column) {
        return super.getColumnName(column);
    }

    public void setVisible(String name, boolean visible) {
        if (!this.columnNames.contains(name)) {
            throw new InvalidParameterException(name);
        }
        if (visible && !this.visibleColumnNames.contains(name)) {
            this.visibleColumnNames.add(name);
            this.setVisibleColumns(this.visibleColumnNames);
        } else {
            this.visibleColumnNames.remove(name);
            this.setVisibleColumns(this.visibleColumnNames);
            this.fireTableStructureChanged();
        }
    }

    @Override
    public void setFeatureType(FeatureType featureType) {
        String colName;
        ArrayList<String> newColumns = new ArrayList<String>();
        ArrayList<String> renamedColumnsNewName = new ArrayList<String>();
        Iterator attrIter = featureType.iterator();
        FeatureAttributeDescriptor fad2 = null;
        EditableFeatureAttributeDescriptor efad = null;
        while (attrIter.hasNext()) {
            fad2 = (FeatureAttributeDescriptor)attrIter.next();
            colName = fad2.getName();
            if (this.columnNames.contains(colName)) continue;
            if (fad2 instanceof EditableFeatureAttributeDescriptor) {
                efad = (EditableFeatureAttributeDescriptor)fad2;
                if (efad.getOriginalName() != null) {
                    if (!this.columnNames.contains(efad.getOriginalName())) {
                        newColumns.add(colName);
                        continue;
                    }
                    renamedColumnsNewName.add(colName);
                    continue;
                }
                newColumns.add(colName);
                continue;
            }
            newColumns.add(colName);
        }
        this.columnNames.clear();
        for (FeatureAttributeDescriptor fad2 : featureType) {
            colName = fad2.getName();
            this.columnNames.add(colName);
            if (this.visibleColumnNames.contains(colName) || !newColumns.contains(colName) && !renamedColumnsNewName.contains(colName) || fad2.getType() == 66) continue;
            this.visibleColumnNames.add(colName);
            this.visibleColumnNamesOriginal.add(colName);
        }
        this.visibleColumnNames = this.intersectKeepOrder(this.columnNames, this.visibleColumnNames);
        this.visibleColumnNamesOriginal = this.intersectKeepOrder(this.columnNames, this.visibleColumnNamesOriginal);
        this.name2Alias.keySet().retainAll(this.columnNames);
        this.name2AliasOriginal.keySet().retainAll(this.columnNames);
        super.setFeatureType(featureType);
    }

    private List<String> intersectKeepOrder(List<String> lista, List<String> listb) {
        ArrayList<String> resp = new ArrayList<String>();
        resp.addAll(lista);
        resp.retainAll(listb);
        return resp;
    }

    private void insertWhereOldNamee(List<String> str_list, String str, FeatureAttributeDescriptor fad) {
        if (fad instanceof EditableFeatureAttributeDescriptor) {
            EditableFeatureAttributeDescriptor efad = (EditableFeatureAttributeDescriptor)fad;
            if (efad.getOriginalName() != null) {
                int old_ind = str_list.indexOf(efad.getOriginalName());
                if (old_ind != -1) {
                    str_list.add(old_ind, str);
                } else {
                    str_list.add(str);
                }
            } else {
                str_list.add(str);
            }
        } else {
            str_list.add(str);
        }
    }

    public void setVisibleColumns(List<String> names) {
        this.visibleColumnNames = new ArrayList<String>(names.size());
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String columnName = this.columnNames.get(i);
            if (!names.contains(columnName)) continue;
            this.visibleColumnNames.add(columnName);
        }
        this.updatePaginHelperWithHiddenColums();
        this.fireTableStructureChanged();
    }

    @Override
    protected String[] getHiddenColumnNames() {
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        hiddenColumns.addAll(this.columnNames);
        for (int i = 0; i < this.visibleColumnNames.size(); ++i) {
            String columnName = this.visibleColumnNames.get(i);
            hiddenColumns.remove(columnName);
        }
        if (hiddenColumns.size() < 1) {
            return null;
        }
        return hiddenColumns.toArray(new String[hiddenColumns.size()]);
    }

    public void setAllVisible() {
        this.visibleColumnNames.clear();
        this.visibleColumnNames.addAll(this.columnNames);
        this.fireTableStructureChanged();
    }

    public void setAlias(String name, String alias) {
        this.name2Alias.put(name, alias);
        this.fireTableStructureChanged();
    }

    public void orderByColumn(String name, boolean ascending) throws BaseException {
        FeatureQueryOrder order = this.getHelper().getFeatureQuery().getOrder();
        order.clear();
        order.add(name, ascending);
        this.getHelper().reload();
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeVisibleColumns();
        this.initializeAliases();
        this.updatePaginHelperWithHiddenColums();
    }

    public boolean isVisible(String name) {
        return this.visibleColumnNames.contains(name);
    }

    private void initializeAliases() {
        int columns = super.getColumnCount();
        this.name2Alias = new HashMap<String, String>(columns);
        this.name2AliasOriginal = new HashMap<String, String>(columns);
    }

    protected void initializeVisibleColumns() {
        int columns = super.getColumnCount();
        this.columnNames = new ArrayList<String>(columns);
        this.visibleColumnNames = new ArrayList<String>(columns);
        block3: for (int i = 0; i < columns; ++i) {
            String columnName = super.getColumnName(i);
            this.columnNames.add(columnName);
            FeatureAttributeDescriptor descriptor = super.getDescriptorForColumn(i);
            switch (descriptor.getType()) {
                case 12: 
                case 15: 
                case 34: 
                case 36: 
                case 66: {
                    continue block3;
                }
                default: {
                    if (descriptor.isHidden()) continue block3;
                    this.visibleColumnNames.add(columnName);
                }
            }
        }
        this.visibleColumnNamesOriginal = new ArrayList<String>(this.visibleColumnNames);
    }

    protected String getAliasForColumn(String name) {
        String alias = this.name2Alias.get(name);
        return alias == null ? name : alias;
    }

    public int getOriginalColumnIndex(int columnIndex) {
        String columnName = this.visibleColumnNames.get(columnIndex);
        return this.columnNames.indexOf(columnName);
    }

    @Override
    protected Object getFeatureValue(Feature feature, int columnIndex) {
        int realColumnIndex = this.getOriginalColumnIndex(columnIndex);
        return super.getFeatureValue(feature, realColumnIndex);
    }

    @Override
    protected EditableFeature setFeatureValue(Feature feature, int columnIndex, Object value) {
        int realColumnIndex = this.getOriginalColumnIndex(columnIndex);
        return super.setFeatureValue(feature, realColumnIndex, value);
    }

    public void acceptChanges() {
        this.visibleColumnNamesOriginal = new ArrayList<String>(this.visibleColumnNames);
        this.name2AliasOriginal = new HashMap<String, String>(this.name2Alias);
    }

    public void cancelChanges() {
        this.visibleColumnNames = new ArrayList<String>(this.visibleColumnNamesOriginal);
        this.name2Alias = new HashMap<String, String>(this.name2AliasOriginal);
        this.fireTableStructureChanged();
    }

    protected void initializeFormattingPatterns() {
        this.patterns = new HashMap<String, String>();
        int columns = super.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            String columnName = super.getColumnName(i);
            this.initializeFormattingPattern(columnName);
        }
    }

    protected void initializeFormattingPattern(String columnName) {
        FeatureAttributeDescriptor descriptor = this.getFeatureType().getAttributeDescriptor(columnName);
        switch (descriptor.getDataType().getType()) {
            case 2: 
            case 4: 
            case 5: {
                String defaultIntegerPattern = "#,##0";
                this.patterns.put(columnName, defaultIntegerPattern);
                break;
            }
            case 7: {
                String defaultDoublePattern = "#,##0.0000000000";
                this.patterns.put(columnName, defaultDoublePattern);
                break;
            }
            case 6: {
                String defaultFloatPattern = "#,##0.0000";
                this.patterns.put(columnName, defaultFloatPattern);
                break;
            }
            case 9: {
                String defaultDatePattern = new SimpleDateFormat().toPattern();
                this.patterns.put(columnName, defaultDatePattern);
                break;
            }
            default: {
                this.patterns.put(columnName, null);
            }
        }
    }

    public String getFormattingPattern(int column) {
        String columnName = this.visibleColumnNames.get(column);
        return this.getFormattingPattern(columnName);
    }

    public String getFormattingPattern(String columnName) {
        String pattern;
        if (this.patterns == null) {
            this.initializeFormattingPatterns();
        }
        if (StringUtils.isBlank((CharSequence)(pattern = this.patterns.get(columnName)))) {
            this.initializeFormattingPattern(columnName);
        }
        return pattern;
    }

    public void setFormattingPattern(String columnName, String pattern) {
        if (this.patterns == null) {
            this.initializeFormattingPatterns();
        }
        this.patterns.put(columnName, pattern);
    }

    public Locale getLocaleOfData() {
        return this.localeOfData;
    }

    public void setLocaleOfData(Locale locale) {
        this.localeOfData = locale;
    }
}

