/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.i18n.Messages;

public class ConfigurationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -825156698327593853L;
    public static final int VISIBILITY_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int ALIAS_COLUMN = 2;
    public static final int TYPE_COLUMN = 3;
    public static final int SIZE_COLUMN = 4;
    public static final int PRECISION_COLUMN = 5;
    public static final int SCALE_COLUMN = 6;
    public static final int PATTERN_COLUMN = 7;
    public static final int EMULATED = 8;
    private static final int COLUMN_COUNT = 9;
    private final ConfigurableFeatureTableModel configurable;

    public ConfigurationTableModel(ConfigurableFeatureTableModel configurable) {
        this.configurable = configurable;
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public int getRowCount() {
        return this.configurable.getOriginalColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String name = this.configurable.getOriginalColumnName(rowIndex);
        FeatureAttributeDescriptor fad = this.configurable.internalGetFeatureDescriptorForColumn(rowIndex);
        if (fad == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.configurable.isVisible(name);
            }
            case 1: {
                return name;
            }
            case 2: {
                return this.configurable.getAliasForColumn(name);
            }
            case 3: {
                return fad.getDataType().getName();
            }
            case 4: {
                if (fad.getSize() < 1) {
                    return null;
                }
                return fad.getSize();
            }
            case 5: {
                if (fad.getPrecision() < 0) {
                    return null;
                }
                return fad.getPrecision();
            }
            case 6: {
                if (fad.getScale() < 0) {
                    return null;
                }
                return fad.getScale();
            }
            case 8: {
                return fad.isComputed();
            }
            case 7: {
                return this.configurable.getFormattingPattern(name);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String name = this.configurable.getOriginalColumnName(rowIndex);
        switch (columnIndex) {
            case 0: {
                this.configurable.setVisible(name, Boolean.TRUE.equals(value));
                break;
            }
            case 2: {
                this.configurable.setAlias(name, (String)value);
                break;
            }
            case 7: {
                this.configurable.setFormattingPattern(name, (String)value);
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 2: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 8: {
                return Boolean.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return String.class;
            }
            case 4: 
            case 5: 
            case 6: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Messages.getText((String)"visible");
            }
            case 1: {
                return Messages.getText((String)"name");
            }
            case 2: {
                return Messages.getText((String)"alias");
            }
            case 4: {
                return Messages.getText((String)"size");
            }
            case 5: {
                return Messages.getText((String)"precision");
            }
            case 6: {
                return Messages.getText((String)"scale");
            }
            case 3: {
                return Messages.getText((String)"type");
            }
            case 7: {
                return Messages.getText((String)"pattern");
            }
            case 8: {
                return Messages.getText((String)"Calculated");
            }
        }
        return "";
    }

    public static int getVisibilityColumn() {
        return 0;
    }

    public void acceptChanges() {
        this.configurable.acceptChanges();
    }

    public void cancelChanges() {
        this.configurable.cancelChanges();
    }

    public String getFormattingPattern(String columnName) {
        return this.configurable.getFormattingPattern(columnName);
    }

    public void setFormattingPattern(String columnName, String pattern) {
        this.configurable.setFormattingPattern(columnName, pattern);
    }
}

