/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class FeatureAttributeCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        c.setBackground(this.getBackgroundColor(table, isSelected, row, column));
        return c;
    }

    protected Color getBackgroundColor(JTable table, boolean isSelected, int row, int column) {
        block9: {
            try {
                if (isSelected) {
                    return table.getSelectionBackground();
                }
                ConfigurableFeatureTableModel tableModel = this.getTableModel(table);
                Feature feature = tableModel.getFeatureAt(row);
                switch (feature.getDataStatus()) {
                    case 1: {
                        return ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor();
                    }
                    case 2: {
                        return ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor().darker();
                    }
                }
                if (!tableModel.getFeatureStore().isFeatureModified(feature)) break block9;
                try {
                    feature.validate(14);
                }
                catch (Exception ex) {
                    return ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor();
                }
            }
            catch (Exception ex) {
                return table.getBackground();
            }
        }
        return table.getBackground();
    }

    public ConfigurableFeatureTableModel getTableModel(JTable table) {
        return (ConfigurableFeatureTableModel)table.getModel();
    }
}

