/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTypeListModel;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;

public class FeatureStoreModel
extends AbstractDisposable {
    private FeatureStore featureStore;
    private FeatureQuery featureQuery;
    private FeatureTypeListModel featureTypeListModel;
    private Map<String, ConfigurableFeatureTableModel> type2TableModel = new HashMap<String, ConfigurableFeatureTableModel>();
    private String currentFeatureTypeId;

    public FeatureStoreModel(FeatureStore store, FeatureQuery query) throws DataException {
        this.featureStore = store;
        this.featureQuery = query;
        this.featureTypeListModel = new FeatureTypeListModel(store, query);
        this.currentFeatureTypeId = query.getFeatureTypeId() == null ? store.getDefaultFeatureType().getId() : query.getFeatureTypeId();
    }

    public FeatureStoreModel(FeatureStore store) throws DataException {
        this(store, null);
    }

    public FeatureTypeListModel getFeatureTypeListModel() {
        return this.featureTypeListModel;
    }

    public ConfigurableFeatureTableModel getCurrentFeatureTableModel() {
        return this.getFeatureTableModel(this.currentFeatureTypeId);
    }

    public ConfigurableFeatureTableModel getFeatureTableModel(FeatureType type) {
        return this.getFeatureTableModel(type.getId());
    }

    public ConfigurableFeatureTableModel getFeatureTableModel(String typeId) {
        ConfigurableFeatureTableModel tableModel = this.type2TableModel.get(typeId);
        if (tableModel == null) {
            try {
                tableModel = new ConfigurableFeatureTableModel(this.featureStore, this.featureQuery);
                this.type2TableModel.put(typeId, tableModel);
            }
            catch (BaseException e) {
                throw new RuntimeException("Error creating a table model", e);
            }
        }
        return tableModel;
    }

    public void setCurrentFeatureTypeId(String currentFeatureTypeId) {
        this.currentFeatureTypeId = currentFeatureTypeId;
    }

    public String getCurrentFeatureTypeId() {
        return this.currentFeatureTypeId;
    }

    public FeatureQuery getFeatureQuery() {
        return this.featureQuery;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    protected void doDispose() throws BaseException {
        if (this.type2TableModel != null) {
            for (ConfigurableFeatureTableModel value : this.type2TableModel.values()) {
                DisposeUtils.disposeQuietly((Disposable)value);
            }
        }
        this.featureStore = null;
        this.featureQuery = null;
        this.featureTypeListModel = null;
        this.type2TableModel = null;
    }
}

