/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;

public class FormattedCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -1409667557139440155L;
    private final ConfigurableFeatureTableModel tableModel;
    private final SimpleDateFormat dateformat;
    private final NumberFormat numberFormat;
    private String pattern;
    private int type;

    public FormattedCellEditor(ConfigurableFeatureTableModel model) {
        super(new JFormattedTextField());
        this.tableModel = model;
        Locale localeOfData = this.tableModel.getLocaleOfData();
        this.dateformat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2, localeOfData);
        this.dateformat.setTimeZone(TimeZone.getDefault());
        this.numberFormat = NumberFormat.getInstance(localeOfData);
        this.numberFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        JFormattedTextField editor = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.pattern = this.tableModel.getFormattingPattern(column);
        if (value == null) {
            int attrindex = this.tableModel.getOriginalColumnIndex(column);
            FeatureAttributeDescriptor attrdesc = this.tableModel.getFeatureType().getAttributeDescriptor(attrindex);
            value = attrdesc.getDefaultValue();
        }
        if (value instanceof Number) {
            this.type = value instanceof Float ? 6 : (value instanceof Integer ? 4 : (value instanceof Long ? 5 : 7));
            editor.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(this.numberFormat)));
            editor.setValue(value);
        }
        if (value instanceof Date) {
            this.type = 9;
            this.dateformat.applyPattern(this.pattern);
            editor.setFormatterFactory(new DefaultFormatterFactory(new DateFormatter(this.dateformat)));
            editor.setValue(value);
        }
        return editor;
    }

    @Override
    public Object getCellEditorValue() {
        Object superValue = super.getCellEditorValue();
        String str = (String)superValue;
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return null;
        }
        try {
            ParsePosition pos = new ParsePosition(0);
            Number n = null;
            switch (this.type) {
                case 7: {
                    n = this.numberFormat.parse(str, pos);
                    if (pos.getIndex() != str.length()) {
                        throw new ParseException("parsing incomplete", pos.getIndex());
                    }
                    return n.doubleValue();
                }
                case 6: {
                    n = this.numberFormat.parse(str, pos);
                    if (pos.getIndex() != str.length()) {
                        throw new ParseException("parsing incomplete", pos.getIndex());
                    }
                    return Float.valueOf(n.floatValue());
                }
                case 4: {
                    n = this.numberFormat.parse(str, pos);
                    if (pos.getIndex() != str.length()) {
                        throw new ParseException("parsing incomplete", pos.getIndex());
                    }
                    return n.intValue();
                }
                case 5: {
                    n = this.numberFormat.parse(str, pos);
                    if (pos.getIndex() != str.length()) {
                        throw new ParseException("parsing incomplete", pos.getIndex());
                    }
                    return n.longValue();
                }
                case 9: {
                    this.dateformat.applyPattern(this.pattern);
                    Date d = this.dateformat.parse(str);
                    return d;
                }
            }
            return superValue;
        }
        catch (ParseException pex) {
            throw new RuntimeException(pex);
        }
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.getCellEditorValue();
            return super.stopCellEditing();
        }
        catch (Exception ex) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
    }
}

