/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.HasDataStore;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.CompoundLayersTreeModel;
import org.gvsig.fmap.mapcontrol.CompoundStoresTreeModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class CompoundStoresTreeModelImpl
implements CompoundStoresTreeModel {
    private final CompoundLayersTreeModel delegated = new CompoundLayersTreeModel();
    private final LabeledValue<Object> root;
    private final Map<Object, Icon> icons = new HashMap<Object, Icon>();

    public CompoundStoresTreeModelImpl() {
        this.root = new LabeledValueImpl("Project", this.delegated.getRoot());
    }

    private Object getNode(Object value) {
        if (value instanceof LabeledValue) {
            return ((LabeledValue)value).getValue();
        }
        return value;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object x = this.delegated.getChild(parent = this.getNode(parent), index);
        if (x instanceof HasDataStore) {
            DataStore store = ((HasDataStore)x).getDataStore();
            return new LabeledValueImpl(store.getName(), (Object)store);
        }
        return x;
    }

    @Override
    public int getChildCount(Object parent) {
        parent = this.getNode(parent);
        return this.delegated.getChildCount(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        node = this.getNode(node);
        return this.delegated.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.delegated.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        parent = this.getNode(parent);
        return this.delegated.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.delegated.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.delegated.removeTreeModelListener(l);
    }

    public Icon getIcon(Object item) {
        if (item instanceof LabeledValue) {
            item = ((LabeledValue)item).getValue();
        }
        if (!this.icons.containsKey(item)) {
            FLayers layers;
            String iconName = item instanceof DataStore ? MapContextLocator.getMapContextManager().getIconLayer((DataStore)item) : (item == this.root.getValue() ? "common-folder-open" : (item instanceof FLayers ? ((layers = (FLayers)item).getParentLayer() != null && layers.getParentLayer().getParentLayer() == null ? "view-navigation-zoom-all" : "layer-icon-group") : "common-leaf"));
            ImageIcon icon = ToolsSwingLocator.getIconThemeManager().getCurrent().get(iconName);
            this.icons.put(item, icon);
        }
        return this.icons.get(item);
    }

    @Override
    public void addLayers(FLayers layers) {
        this.delegated.addLayers(layers);
    }

    public void setFilter(Predicate filter) {
        this.delegated.setFilter((FLayer t) -> {
            if (t instanceof HasDataStore) {
                return filter.test(((HasDataStore)t).getDataStore());
            }
            return false;
        });
    }
}

