/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.swing.pickercontroller.impl;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseWheelBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MoveBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MoveEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.tools.IllegalValueException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.documentfilters.DoubleDocumentFilter;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;

public class ScalePickerControllerImpl
extends AbstractPickerController<Double> {
    private final MapControl mapControl;
    private final JComboBox cboScale;
    private final JButton btnMapControlScale;
    private final JToggleButton btnCapture;
    private ImageIcon captureCursor;
    private Behavior[] captureTool;
    private String previosTool;

    public static void selfRegister() {
        ImageIcon icon;
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        URL url = ScalePickerControllerImpl.class.getClassLoader().getResource("images/picker-scale-cursor-capture.png");
        if (url != null) {
            icon = new ImageIcon(url);
            theme.registerDefault("mapcontrol", "picker", "picker-scale", "picker-scale-cursor-capture", icon, url);
        }
        if ((url = ScalePickerControllerImpl.class.getClassLoader().getResource("images/picker-scale-capture.png")) != null) {
            icon = new ImageIcon(url);
            theme.registerDefault("mapcontrol", "picker", "picker-scale", "picker-scale-capture", icon, url);
        }
        if ((url = ScalePickerControllerImpl.class.getClassLoader().getResource("images/picker-scale-from-mapcontrol.png")) != null) {
            icon = new ImageIcon(url);
            theme.registerDefault("mapcontrol", "picker", "picker-scale", "picker-scale-from-mapcontrol", icon, url);
        }
    }

    public ScalePickerControllerImpl(MapControl mapControl, JComboBox cboScale, JButton btnMapControlScale, JToggleButton btnCapture) {
        this.mapControl = mapControl;
        this.cboScale = cboScale;
        this.btnMapControlScale = btnMapControlScale;
        this.btnCapture = btnCapture;
        this.initComponents();
    }

    private void initComponents() {
        this.captureCursor.setImage(this.getIcon("picker-scale-cursor-capture").getImage());
        this.btnCapture.setIcon(this.getIcon("picker-scale-capture"));
        this.btnMapControlScale.setIcon(this.getIcon("picker-scale-from-mapcontrol"));
        Component comboEditor = this.cboScale.getEditor().getEditorComponent();
        if (comboEditor instanceof JTextField) {
            JTextField editor = (JTextField)comboEditor;
            editor.setHorizontalAlignment(4);
            DoubleDocumentFilter.install((JTextField)editor);
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{"1000", "2000", "5000", "10000", "25000", "50000", "100000", "200000", "500000", "1000000", "2000000", "5000000"});
        this.cboScale.setModel(model);
        this.cboScale.setSelectedItem("10000");
        if (this.mapControl == null) {
            this.btnCapture.setEnabled(false);
            this.btnMapControlScale.setEnabled(false);
        } else {
            this.btnCapture.setEnabled(true);
            this.btnMapControlScale.setEnabled(true);
            CaptureScaleListener captureListener = new CaptureScaleListener();
            this.captureTool = new Behavior[]{new MouseMovementBehavior(captureListener), new MouseWheelBehavior(), new MoveBehavior(captureListener, 2)};
            this.mapControl.addBehavior("picker-scale-capture", this.captureTool);
            this.previosTool = this.mapControl.getCurrentTool();
            this.doSetScaleFromMapControlScale();
        }
        if (this.btnMapControlScale != null) {
            this.btnMapControlScale.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScalePickerControllerImpl.this.doSetScaleFromMapControlScale();
                }
            });
        }
        this.btnCapture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScalePickerControllerImpl.this.doCaptureScale(ScalePickerControllerImpl.this.btnCapture.isSelected());
            }
        });
    }

    protected void doSetScaleFromMapControlScale() {
        if (!this.isEditable()) {
            return;
        }
        try {
            double theScale = this.mapControl.getMapContext().getScaleView();
            this.set(theScale);
        }
        catch (Exception ex) {
            LOG.warn("Can't get scale from mapcontrol.", (Throwable)ex);
        }
    }

    protected void doCaptureScale(boolean enabled) {
        if (!this.isEditable()) {
            return;
        }
        if (enabled) {
            this.previosTool = this.mapControl.getCurrentTool();
            this.mapControl.setTool("picker-scale-capture");
        } else {
            this.mapControl.setTool(this.previosTool);
        }
    }

    public boolean isValid() {
        String value = (String)this.cboScale.getSelectedItem();
        if (value == null) {
            return true;
        }
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isEmpty() {
        String value = (String)this.cboScale.getSelectedItem();
        return value == null;
    }

    public Double get() {
        double scale;
        String value = (String)this.cboScale.getSelectedItem();
        if (value == null) {
            return null;
        }
        try {
            scale = Double.parseDouble(value);
        }
        catch (Exception ex) {
            throw new IllegalValueException((Throwable)ex);
        }
        return scale;
    }

    public void set(Double scale) {
        this.cboScale.setSelectedItem(String.format("%f", scale));
    }

    public void coerceAndSet(Object value) {
        DataType dataType = ToolsLocator.getDataTypesManager().get(7);
        try {
            this.set((Double)dataType.coerce(value));
        }
        catch (CoercionException ex) {
            LOG.warn("Can't set value.", (Throwable)ex);
        }
    }

    public void setEnabled(boolean enabled) {
        this.cboScale.setEnabled(enabled);
        if (this.mapControl != null) {
            this.btnCapture.setEnabled(enabled);
            this.btnMapControlScale.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.cboScale.isEnabled();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.cboScale.setEditable(editable);
    }

    private class CaptureScaleListener
    implements PanListener,
    PointListener {
        private CaptureScaleListener() {
        }

        @Override
        public Image getImageCursor() {
            return ScalePickerControllerImpl.this.captureCursor.getImage();
        }

        @Override
        public boolean cancelDrawing() {
            return false;
        }

        @Override
        public void move(MoveEvent event) throws BehaviorException {
            ScalePickerControllerImpl.this.doSetScaleFromMapControlScale();
        }

        @Override
        public void point(PointEvent event) throws BehaviorException {
            ScalePickerControllerImpl.this.doSetScaleFromMapControlScale();
        }

        @Override
        public void pointDoubleClick(PointEvent event) throws BehaviorException {
            ScalePickerControllerImpl.this.doSetScaleFromMapControlScale();
        }
    }
}

