/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.fmap.mapcontrol.tools.geo.Geo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaListenerImpl
implements PolylineListener {
    private static final Logger logger = LoggerFactory.getLogger(AreaListenerImpl.class);
    protected MapControl mapCtrl;
    protected MeasureEvent event;

    public AreaListenerImpl(MapControl mc) {
        this.mapCtrl = mc;
    }

    @Override
    public void points(MeasureEvent event) {
        this.event = event;
        double dist = 0.0;
        double distAll = 0.0;
        ViewPort vp = this.mapCtrl.getMapContext().getViewPort();
        for (int i = 0; i < event.getXs().length - 1; ++i) {
            dist = 0.0;
            Point p = new Point(event.getXs()[i].intValue(), event.getXs()[i].intValue());
            Point p2 = new Point(event.getXs()[i + 1].intValue(), event.getXs()[i + 1].intValue());
            dist = vp.distanceWorld((Point2D)p, (Point2D)p2);
            distAll += dist;
        }
        logger.debug("Perimetro = {}, Area = {}.", (Object)distAll, (Object)this.returnArea(vp.toMapPoint((Point2D)new Point2D.Double(event.getXs()[event.getXs().length - 2], event.getYs()[event.getYs().length - 2]))));
    }

    protected double returnArea(Point2D point) {
        Double[] xs = this.event.getXs();
        Double[] ys = this.event.getYs();
        if (this.mapCtrl.getProjection().isProjected()) {
            return this.returnCoordsArea(xs, ys, point);
        }
        return this.returnGeoCArea(xs, ys, point);
    }

    public double returnCoordsArea(Double[] xs, Double[] ys, Point2D point) {
        Point2D aux = point;
        double elArea = 0.0;
        Point2D.Double p = new Point2D.Double();
        Point2D.Double pAnt = new Point2D.Double();
        ViewPort vp = this.mapCtrl.getMapContext().getViewPort();
        for (int pos = 0; pos < xs.length - 1; ++pos) {
            Point2D.Double pPixel;
            p = pPixel = new Point2D.Double(xs[pos], ys[pos]);
            if (pos == 0) {
                pAnt.x = aux.getX();
                pAnt.y = aux.getY();
            }
            elArea += (pAnt.x - ((Point2D)p).getX()) * (pAnt.y + ((Point2D)p).getY());
            pAnt.setLocation(p);
        }
        elArea += (pAnt.x - aux.getX()) * (pAnt.y + aux.getY());
        elArea = Math.abs(elArea / 2.0);
        return elArea * Math.pow(MapContext.getDistanceTrans2Meter()[vp.getMapUnits()], 2.0);
    }

    public static void main(String[] args) {
        IProjection projectionUTM = CRSFactory.getCRS((String)"EPSG:23030");
        ViewPort vpUTM = new ViewPort(projectionUTM);
        MapControl mcUTM = new MapControl();
        mcUTM.setMapContext(new MapContext(vpUTM));
        AreaListenerImpl areaListenerUTM = new AreaListenerImpl(mcUTM);
        IProjection projectionGeo = CRSFactory.getCRS((String)"EPSG:4230");
        ViewPort vpGeo = new ViewPort(projectionGeo);
        MapControl mcGeo = new MapControl();
        mcGeo.setMapContext(new MapContext(vpGeo));
        AreaListenerImpl areaListenerGeo = new AreaListenerImpl(mcGeo);
        Double[] xsUTMCaseta = new Double[]{new Double(547508.77), new Double(547517.73), new Double(547512.65)};
        Double[] ysUTMCaseta = new Double[]{new Double(4704333.97), new Double(4704331.3), new Double(4704315.2)};
        double areaUTMCaseta = areaListenerUTM.returnCoordsArea(xsUTMCaseta, ysUTMCaseta, new Point2D.Double(547512.65, 4704315.2));
        Double[] xsGeoCaseta = new Double[]{new Double(-2.42192383), new Double(-2.42181545), new Double(-2.42187771)};
        Double[] ysGeoCaseta = new Double[]{new Double(42.48914909), new Double(42.48912295), new Double(42.48897922)};
        double areaGeoCCaseta = areaListenerGeo.returnGeoCArea(xsGeoCaseta, ysGeoCaseta, new Point2D.Double(-2.42187771, 42.48897922));
        System.out.println("AreaUTMCaseta = " + areaUTMCaseta);
        System.out.println("AreaGeoCCaseta = " + areaGeoCCaseta);
        Double[] xsUTM = new Double[]{new Double(731292.0), new Double(731901.0), new Double(730138.0)};
        Double[] ysUTM = new Double[]{new Double(4351223.0), new Double(4350768.0), new Double(4349232.0)};
        double areaUTM = areaListenerUTM.returnCoordsArea(xsUTM, ysUTM, new Point2D.Double(730138.0, 4349232.0));
        Double[] xsGeo = new Double[]{new Double(-0.31888183), new Double(-0.31173131), new Double(-0.33268401)};
        Double[] ysGeo = new Double[]{new Double(39.27871741), new Double(39.27464327), new Double(39.26117368)};
        double areaGeoC = areaListenerGeo.returnGeoCArea(xsGeo, ysGeo, new Point2D.Double(-0.33268401, 39.26117368));
        System.out.println("AreaUTM = " + areaUTM);
        System.out.println("AreaGeoC = " + areaGeoC);
        Double[] xsUTMspain = new Double[]{new Double(-12806.0), new Double(1025790.0), new Double(-31353.14)};
        Double[] ysUTMspain = new Double[]{new Double(4793276.43), new Double(4719090.94), new Double(4125607.02)};
        double areaUTMspain = areaListenerUTM.returnCoordsArea(xsUTMspain, ysUTMspain, new Point2D.Double(730138.0, 4349232.0));
        Double[] xsGeospain = new Double[]{new Double(-9.22743872), new Double(3.33087936), new Double(-9.01458587), new Double(-9.22743872)};
        Double[] ysGeospain = new Double[]{new Double(43.02384666), new Double(42.38528811), new Double(37.06396689), new Double(43.02384666)};
        double areaGeospainC = areaListenerGeo.returnGeoCArea(xsGeospain, ysGeospain, new Point2D.Double(-9.01458587, 37.06396689));
        System.out.println("AreaUTMSpain = " + areaUTMspain);
        System.out.println("AreaGeoSpainC = " + areaGeospainC);
    }

    public double returnGeoCArea(Double[] xs, Double[] ys, Point2D point) {
        double[] lat = new double[xs.length];
        double[] lon = new double[xs.length];
        for (int K = 0; K < xs.length; ++K) {
            lon[K] = xs[K] / Geo.Degree;
            lat[K] = ys[K] / Geo.Degree;
        }
        return Geo.sphericalPolyArea(lat, lon, xs.length - 1) * Geo.SqM;
    }

    @Override
    public Image getImageCursor() {
        return IconThemeHelper.getImage("cursor-query-area");
    }

    @Override
    public void pointFixed(MeasureEvent event) {
    }

    @Override
    public void polylineFinished(MeasureEvent event) {
    }

    @Override
    public boolean cancelDrawing() {
        return false;
    }
}

