/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.gvsig.fmap.dal.feature.exception.CreateGeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.IBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Behavior
implements IBehavior {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Behavior.class);
    public static final int BUTTON_LEFT = 1;
    public static final int BUTTON_MIDDLE = 2;
    public static final int BUTTON_RIGHT = 4;
    private MapControl mapControl;
    protected static final Logger LOG = LoggerFactory.getLogger(Behavior.class);
    protected GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private int mouseButton = 1;
    private boolean isMyButton = false;
    private boolean useSnapping = true;

    public Behavior() {
    }

    public Behavior(int mouseButton) {
        this.mouseButton = mouseButton;
    }

    @Override
    public abstract ToolListener getListener();

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
    }

    public void paintComponent(MapControlDrawer mapControlDrawer, boolean clean) {
        if (clean) {
            this.clean(mapControlDrawer);
        }
        this.paintComponent(mapControlDrawer);
    }

    public void clean(MapControlDrawer mapControlDrawer) {
        BufferedImage img = this.getMapControl().getImage();
        if (img != null) {
            mapControlDrawer.drawImage(img, 0, 0);
        }
    }

    @Override
    public void setMapControl(MapControl mc) {
        this.mapControl = mc;
    }

    @Override
    public Image getImageCursor() {
        return this.getListener().getImageCursor();
    }

    @Override
    public MapControl getMapControl() {
        return this.mapControl;
    }

    @Override
    public void mouseClicked(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseEntered(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseExited(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) throws BehaviorException {
    }

    protected Point createPoint(double x, double y) {
        Point point = null;
        try {
            point = (Point)this.geomManager.create(1, 0);
            point.setX(x);
            point.setY(y);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            LOG.error("Error creating a point with x=" + x + ", y=" + y, (Throwable)new CreateGeometryException(1, 0, (Throwable)e));
        }
        return point;
    }

    protected Arc createArc(Point2D p1, Point2D p2, Point2D p3) {
        return this.createArc(this.createPoint(p1), this.createPoint(p2), this.createPoint(p3));
    }

    protected Arc createArc(Point p1, Point p2, Point p3) {
        Arc arc = null;
        try {
            arc = (Arc)this.geomManager.create(12, 0);
            arc.setPoints(p1, p2, p3);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            LOG.error("Error creating and arc with p1=" + p1 + ", p2=" + p2 + ",p3=" + p3, (Throwable)new CreateGeometryException(12, 0, (Throwable)e));
        }
        catch (IllegalArgumentException ex) {
            LOG.info("Warning: unable to create arc from points: " + p1.getX() + " " + p1.getY() + " :: " + p2.getX() + " " + p2.getY() + " :: " + p3.getX() + " " + p3.getY());
            arc = null;
        }
        return arc;
    }

    protected Point createPoint(Point2D p1) {
        return this.createPoint(p1.getX(), p1.getY());
    }

    protected Arc createArc(double centerX, double centerY, double radious, double angleStart, double angleExtent) {
        Arc arc = null;
        try {
            arc = (Arc)this.geomManager.create(12, 0);
            arc.setPoints(this.createPoint(centerX, centerY), radious, angleStart, angleExtent);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            LOG.error("Error creating an arc with centerX=" + centerX + ", centerY=" + centerY + ", radious=" + radious + ", angleStart=" + angleStart + ", angleExtent=" + angleExtent, (Throwable)new CreateGeometryException(12, 0, (Throwable)e));
        }
        catch (IllegalArgumentException ex) {
            LOG.info("Warning: unable to create arc from points.");
            arc = null;
        }
        return arc;
    }

    protected Circle createCircle(double centerX, double centerY, double radious) {
        Circle circle = null;
        try {
            circle = (Circle)this.geomManager.create(11, 0);
            circle.setPoints(this.createPoint(centerX, centerY), radious);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            LOG.error("Error creating circle with centerX=" + centerX + ", centerY=" + centerY + ", radious=" + radious, (Throwable)new CreateGeometryException(11, 0, (Throwable)e));
        }
        return circle;
    }

    protected Ellipse createEllipse(Point2D p1, Point2D p2, Point2D p3) {
        Ellipse ellipse = null;
        double radious = 1.0;
        try {
            ellipse = (Ellipse)this.geomManager.create(13, 0);
            radious = p2.distance(p3);
            ellipse.setPoints(this.createPoint(p1), this.createPoint(p2), radious);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            LOG.error("Error creating ellipse with centerX=" + p1.toString() + ", centerY=" + p2.toString() + ", radious=" + radious, (Throwable)new CreateGeometryException(13, 0, (Throwable)e));
        }
        return ellipse;
    }

    public void resetMyButton() {
        this.isMyButton = false;
    }

    public boolean isMyButton(MouseEvent e) {
        if (e == null) {
            return this.isMyButton;
        }
        switch (this.mouseButton) {
            default: {
                this.isMyButton = SwingUtilities.isLeftMouseButton(e);
                return this.isMyButton;
            }
            case 2: {
                this.isMyButton = SwingUtilities.isMiddleMouseButton(e);
                return this.isMyButton;
            }
            case 4: 
        }
        this.isMyButton = SwingUtilities.isRightMouseButton(e);
        return this.isMyButton;
    }

    public boolean isMyButton() {
        return this.isMyButton;
    }

    public boolean getUseSnapping() {
        return this.useSnapping;
    }

    public void setUseSnapping(boolean useSnapping) {
        this.useSnapping = useSnapping;
    }
}

