/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AbstractCircleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircleBehavior
extends Behavior {
    private static final Logger logger = LoggerFactory.getLogger(CircleBehavior.class);
    protected Point2D m_FirstPoint;
    protected Point2D m_LastPoint;
    private AbstractCircleListener listener;
    protected boolean isClicked = false;

    public CircleBehavior(AbstractCircleListener zili) {
        this.listener = zili;
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
        Point2D p2;
        ViewPort vp;
        Point2D p1;
        double radio;
        mapControlDrawer.setColor(Color.black);
        if (this.m_FirstPoint != null && this.m_LastPoint != null && (radio = (p1 = (vp = this.getMapControl().getMapContext().getViewPort()).toMapPoint(this.m_FirstPoint)).distance(p2 = vp.toMapPoint(this.m_LastPoint))) > 0.0) {
            Arc arc = null;
            arc = this.createArc(p1.getX(), p1.getY(), radio, 0.0, Math.PI * 2);
            if (arc != null) {
                mapControlDrawer.draw((Geometry)arc);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isMyButton(e)) {
            this.m_FirstPoint = e.getPoint();
            this.isClicked = true;
            this.getMapControl().repaint();
            if (this.listener.cancelDrawing()) {
                this.getMapControl().cancelDrawing();
                this.isClicked = false;
                this.getMapControl().repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (this.m_FirstPoint == null) {
            return;
        }
        this.m_LastPoint = e.getPoint();
        ViewPort vp = this.getMapControl().getMapContext().getViewPort();
        Point2D p1 = vp.toMapPoint(this.m_FirstPoint);
        Point2D p2 = vp.toMapPoint(this.m_LastPoint);
        Double[] x = new Double[2];
        Double[] y = new Double[2];
        x[0] = p1.getX();
        x[1] = p2.getX();
        y[0] = p1.getY();
        y[1] = p2.getY();
        MeasureEvent event = new MeasureEvent(x, y, e);
        this.listener.circleFinished(event);
        if (this.isMyButton(e)) {
            this.m_FirstPoint = null;
            this.m_LastPoint = null;
            this.isClicked = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        if (this.m_FirstPoint == null) {
            return;
        }
        this.m_LastPoint = e.getPoint();
        ViewPort vp = this.getMapControl().getMapContext().getViewPort();
        Point2D p1 = vp.toMapPoint(this.m_FirstPoint);
        Point2D p2 = vp.toMapPoint(this.m_LastPoint);
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(p1, p2);
        Rectangle rectPixel = new Rectangle();
        rectPixel.setFrameFromDiagonal(this.m_FirstPoint, this.m_LastPoint);
        Double[] x = new Double[2];
        Double[] y = new Double[2];
        x[0] = p1.getX();
        x[1] = p2.getX();
        y[0] = p1.getY();
        y[1] = p2.getY();
        MeasureEvent event = new MeasureEvent(x, y, e);
        this.listener.circle(event);
        this.getMapControl().repaint();
    }

    public void setListener(ToolListener listener) {
        this.listener = (AbstractCircleListener)listener;
    }

    @Override
    public ToolListener getListener() {
        return this.listener;
    }
}

